/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.catalog;

import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.table.MySqlReadableMetadata;
import com.ververica.cdc.debezium.utils.JdbcUrlUtils;
import com.ververica.connectors.mysql.catalog.MySqlCatalog;
import com.ververica.connectors.mysql.table.MySqlOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.catalog.factory.JdbcCatalogFactoryOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class MySqlCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "mysql";

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validateExcept(new String[]{"jdbc.properties."});
        ReadableConfig config = helper.getOptions();
        List<String> metadataColumns = config.getOptional(MySqlOptions.CATALOG_TABLE_METADATA_COLUMN).orElse(Collections.emptyList());
        this.validateMetadataOption(metadataColumns);
        return new MySqlCatalog(context.getName(), (String)config.get(JdbcCatalogFactoryOptions.DEFAULT_DATABASE), (String)config.get(MySqlSourceOptions.HOSTNAME), (Integer)config.get(MySqlSourceOptions.PORT), (String)config.get(MySqlSourceOptions.USERNAME), (String)config.get(MySqlSourceOptions.PASSWORD), (Duration)config.get(MySqlOptions.CATALOG_CACHE_TTL), (Integer)config.get(MySqlSourceOptions.CONNECTION_POOL_SIZE), (Integer)config.get(MySqlSourceOptions.CONNECT_MAX_RETRIES), (Duration)config.get(MySqlSourceOptions.CONNECT_TIMEOUT), (Integer)config.get(MySqlOptions.CATALOG_THREAD_POOL_SIZE), JdbcUrlUtils.getJdbcProperties(context.getOptions()), metadataColumns, (Boolean)config.get(MySqlOptions.CATALOG_TABLE_TREAT_TINYINT1_AS_BOOL));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(MySqlSourceOptions.HOSTNAME);
        options.add(JdbcCatalogFactoryOptions.DEFAULT_DATABASE);
        options.add(MySqlSourceOptions.USERNAME);
        options.add(MySqlSourceOptions.PASSWORD);
        return options;
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MySqlSourceOptions.PORT);
        options.add(MySqlOptions.CATALOG_CACHE_TTL);
        options.add(MySqlOptions.CATALOG_THREAD_POOL_SIZE);
        options.add(MySqlOptions.CATALOG_TABLE_METADATA_COLUMN);
        options.add(MySqlOptions.CATALOG_TABLE_TREAT_TINYINT1_AS_BOOL);
        options.add(MySqlSourceOptions.CONNECTION_POOL_SIZE);
        options.add(MySqlSourceOptions.CONNECT_TIMEOUT);
        options.add(MySqlSourceOptions.CONNECT_MAX_RETRIES);
        return options;
    }

    private void validateMetadataOption(List<String> metadata) {
        if (metadata.isEmpty()) {
            return;
        }
        for (String m : metadata) {
            MySqlReadableMetadata.getMysqlReadableMetadata(m);
        }
    }
}

