/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.Cache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.LRUCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.SynchronizedCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Headers;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.NonEmptyListValidator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.Requirements;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SchemaUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SimpleConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class HeaderFrom<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELDS_FIELD = "fields";
    public static final String HEADERS_FIELD = "headers";
    public static final String OPERATION_FIELD = "operation";
    private static final String MOVE_OPERATION = "move";
    private static final String COPY_OPERATION = "copy";
    public static final String OVERVIEW_DOC = "Moves or copies fields in the key/value of a record into that record's headers. Corresponding elements of <code>fields</code> and <code>headers</code> together identify a field and the header it should be moved or copied to. Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("fields", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "Field names in the record whose values are to be copied or moved to headers.").define("headers", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "Header names, in the same order as the field names listed in the fields configuration property.").define("operation", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.ValidString.in("move", "copy"), ConfigDef.Importance.HIGH, "Either <code>move</code> if the fields are to be moved to the headers (removed from the key/value), or <code>copy</code> if the fields are to be copied to the headers (retained in the key/value).");
    private List<String> fields;
    private List<String> headers;
    private Operation operation;
    private Cache<Schema, Schema> moveSchemaCache = new SynchronizedCache<Schema, Schema>(new LRUCache(16));

    @Override
    public R apply(R record) {
        Object operatingValue = this.operatingValue(record);
        Schema operatingSchema = this.operatingSchema(record);
        if (operatingSchema == null) {
            return this.applySchemaless(record, operatingValue);
        }
        return this.applyWithSchema(record, operatingValue, operatingSchema);
    }

    private R applyWithSchema(R record, Object operatingValue, Schema operatingSchema) {
        Struct updatedValue;
        Schema updatedSchema;
        Headers updatedHeaders = ((ConnectRecord)record).headers().duplicate();
        Struct value = Requirements.requireStruct(operatingValue, "header " + (Object)((Object)this.operation));
        if (this.operation == Operation.MOVE) {
            updatedSchema = this.moveSchema(operatingSchema);
            updatedValue = new Struct(updatedSchema);
            for (Field field : updatedSchema.fields()) {
                updatedValue.put(field, value.get(field.name()));
            }
        } else {
            updatedSchema = operatingSchema;
            updatedValue = value;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldName = this.fields.get(i);
            String headerName = this.headers.get(i);
            Object fieldValue = value.schema().field(fieldName) != null ? value.get(fieldName) : null;
            Schema fieldSchema = operatingSchema.field(fieldName).schema();
            updatedHeaders.add(headerName, fieldValue, fieldSchema);
        }
        return this.newRecord(record, updatedSchema, updatedValue, updatedHeaders);
    }

    private Schema moveSchema(Schema operatingSchema) {
        Schema moveSchema = this.moveSchemaCache.get(operatingSchema);
        if (moveSchema == null) {
            SchemaBuilder builder = SchemaUtil.copySchemaBasics(operatingSchema, SchemaBuilder.struct());
            for (Field field : operatingSchema.fields()) {
                if (this.fields.contains(field.name())) continue;
                builder.field(field.name(), field.schema());
            }
            moveSchema = builder.build();
            this.moveSchemaCache.put(operatingSchema, moveSchema);
        }
        return moveSchema;
    }

    private R applySchemaless(R record, Object operatingValue) {
        Headers updatedHeaders = ((ConnectRecord)record).headers().duplicate();
        Map<String, Object> value = Requirements.requireMap(operatingValue, "header " + (Object)((Object)this.operation));
        HashMap<String, Object> updatedValue = new HashMap<String, Object>(value);
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldName = this.fields.get(i);
            Object fieldValue = value.get(fieldName);
            String headerName = this.headers.get(i);
            if (this.operation == Operation.MOVE) {
                updatedValue.remove(fieldName);
            }
            updatedHeaders.add(headerName, fieldValue, null);
        }
        return this.newRecord(record, null, updatedValue, updatedHeaders);
    }

    protected abstract Object operatingValue(R var1);

    protected abstract Schema operatingSchema(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3, Iterable<Header> var4);

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.fields = config.getList(FIELDS_FIELD);
        this.headers = config.getList(HEADERS_FIELD);
        if (this.headers.size() != this.fields.size()) {
            throw new ConfigException(String.format("'%s' config must have the same number of elements as '%s' config.", FIELDS_FIELD, HEADERS_FIELD));
        }
        this.operation = Operation.fromName(config.getString(OPERATION_FIELD));
    }

    public static class Value<R extends ConnectRecord<R>>
    extends HeaderFrom<R> {
        @Override
        public Object operatingValue(R record) {
            return ((ConnectRecord)record).value();
        }

        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).valueSchema();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue, Iterable<Header> updatedHeaders) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), updatedSchema, updatedValue, ((ConnectRecord)record).timestamp(), updatedHeaders);
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends HeaderFrom<R> {
        @Override
        public Object operatingValue(R record) {
            return ((ConnectRecord)record).key();
        }

        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).keySchema();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue, Iterable<Header> updatedHeaders) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), updatedSchema, updatedValue, ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp(), updatedHeaders);
        }
    }

    static enum Operation {
        MOVE("move"),
        COPY("copy");

        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        static Operation fromName(String name) {
            switch (name) {
                case "move": {
                    return MOVE;
                }
                case "copy": {
                    return COPY;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.name;
        }
    }
}

