/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.AppInfoParser;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkTask;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSinkTask
extends SinkTask {
    private static final Logger log = LoggerFactory.getLogger(MockSinkTask.class);
    private String mockMode;
    private long startTimeMs;
    private long failureDelayMs;

    @Override
    public String version() {
        return AppInfoParser.getVersion();
    }

    @Override
    public void start(Map<String, String> config) {
        this.mockMode = config.get("mock_mode");
        if ("task-failure".equals(this.mockMode)) {
            this.startTimeMs = System.currentTimeMillis();
            String delayMsString = config.get("delay_ms");
            this.failureDelayMs = 15000L;
            if (delayMsString != null) {
                this.failureDelayMs = Long.parseLong(delayMsString);
            }
            log.debug("Started MockSinkTask at {} with failure scheduled in {} ms", (Object)this.startTimeMs, (Object)this.failureDelayMs);
            this.setTimeout();
        }
    }

    @Override
    public void put(Collection<SinkRecord> records) {
        if ("task-failure".equals(this.mockMode)) {
            long now = System.currentTimeMillis();
            if (now - this.startTimeMs > this.failureDelayMs) {
                log.debug("Triggering sink task failure");
                throw new RuntimeException();
            }
            this.setTimeout();
        }
    }

    @Override
    public void flush(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    @Override
    public void stop() {
    }

    private void setTimeout() {
        this.context.timeout(Math.min(this.failureDelayMs, 250L));
    }
}

