/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EndTxnRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EndTxnResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.EndTxnResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.TransactionResult;
import java.nio.ByteBuffer;

public class EndTxnRequest
extends AbstractRequest {
    private final EndTxnRequestData data;

    private EndTxnRequest(EndTxnRequestData data, short version) {
        super(ApiKeys.END_TXN, version);
        this.data = data;
    }

    public TransactionResult result() {
        if (this.data.committed()) {
            return TransactionResult.COMMIT;
        }
        return TransactionResult.ABORT;
    }

    @Override
    public EndTxnRequestData data() {
        return this.data;
    }

    @Override
    public EndTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EndTxnResponse(new EndTxnResponseData().setErrorCode(Errors.forException(e).code()).setThrottleTimeMs(throttleTimeMs));
    }

    public static EndTxnRequest parse(ByteBuffer buffer, short version) {
        return new EndTxnRequest(new EndTxnRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<EndTxnRequest> {
        public final EndTxnRequestData data;

        public Builder(EndTxnRequestData data) {
            super(ApiKeys.END_TXN);
            this.data = data;
        }

        @Override
        public EndTxnRequest build(short version) {
            return new EndTxnRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

