/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.DefaultRecord;
import java.nio.ByteBuffer;

public class PartialDefaultRecord
extends DefaultRecord {
    private final int keySize;
    private final int valueSize;

    PartialDefaultRecord(int sizeInBytes, byte attributes, long offset, long timestamp, int sequence, int keySize, int valueSize) {
        super(sizeInBytes, attributes, offset, timestamp, sequence, null, null, null);
        this.keySize = keySize;
        this.valueSize = valueSize;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.keySize == ((PartialDefaultRecord)o).keySize && this.valueSize == ((PartialDefaultRecord)o).valueSize;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.keySize;
        result = 31 * result + this.valueSize;
        return result;
    }

    @Override
    public String toString() {
        return String.format("PartialDefaultRecord(offset=%d, timestamp=%d, key=%d bytes, value=%d bytes)", this.offset(), this.timestamp(), this.keySize, this.valueSize);
    }

    @Override
    public int keySize() {
        return this.keySize;
    }

    @Override
    public boolean hasKey() {
        return this.keySize >= 0;
    }

    @Override
    public ByteBuffer key() {
        throw new UnsupportedOperationException("key is skipped in PartialDefaultRecord");
    }

    @Override
    public int valueSize() {
        return this.valueSize;
    }

    @Override
    public boolean hasValue() {
        return this.valueSize >= 0;
    }

    @Override
    public ByteBuffer value() {
        throw new UnsupportedOperationException("value is skipped in PartialDefaultRecord");
    }

    @Override
    public Header[] headers() {
        throw new UnsupportedOperationException("headers is skipped in PartialDefaultRecord");
    }
}

