/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class DescribeConfigsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<DescribeConfigsResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(DescribeConfigsResult.SCHEMA_0), "The results for each resource."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public DescribeConfigsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeConfigsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<DescribeConfigsResult>(0);
    }

    @Override
    public short apiKey() {
        return 32;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribeConfigsResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeConfigsResult(_readable, _version));
            }
            this.results = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field results was serialized as null");
            }
            newCollection = new ArrayList<DescribeConfigsResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeConfigsResult(_readable, _version));
            }
            this.results = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.results.size() + 1);
            for (DescribeConfigsResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.results.size());
            for (DescribeConfigsResult resultsElement : this.results) {
                resultsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (DescribeConfigsResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeConfigsResponseData)) {
            return false;
        }
        DescribeConfigsResponseData other = (DescribeConfigsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public DescribeConfigsResponseData duplicate() {
        DescribeConfigsResponseData _duplicate = new DescribeConfigsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DescribeConfigsResult> newResults = new ArrayList<DescribeConfigsResult>(this.results.size());
        for (DescribeConfigsResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "DescribeConfigsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribeConfigsResult> results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeConfigsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeConfigsResponseData setResults(List<DescribeConfigsResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(DescribeConfigsResult.SCHEMA_1), "The results for each resource."));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(DescribeConfigsResult.SCHEMA_3), "The results for each resource."));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(DescribeConfigsResult.SCHEMA_4), "The results for each resource."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class DescribeConfigsSynonym
    implements Message {
        String name;
        String value;
        byte source;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public DescribeConfigsSynonym(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeConfigsSynonym() {
            this.name = "";
            this.value = "";
            this.source = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeConfigsSynonym");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this.source = _readable.readByte();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeConfigsSynonym");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.value);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.source);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeConfigsSynonym");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this.value == null) {
                if (_version >= 4) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.value, _stringBytes);
                if (_version >= 4) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeConfigsSynonym)) {
                return false;
            }
            DescribeConfigsSynonym other = (DescribeConfigsSynonym)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (this.source != other.source) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            hashCode = 31 * hashCode + this.source;
            return hashCode;
        }

        @Override
        public DescribeConfigsSynonym duplicate() {
            DescribeConfigsSynonym _duplicate = new DescribeConfigsSynonym();
            _duplicate.name = this.name;
            _duplicate.value = this.value == null ? null : this.value;
            _duplicate.source = this.source;
            return _duplicate;
        }

        public String toString() {
            return "DescribeConfigsSynonym(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ", source=" + this.source + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public byte source() {
            return this.source;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeConfigsSynonym setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeConfigsSynonym setValue(String v) {
            this.value = v;
            return this;
        }

        public DescribeConfigsSynonym setSource(byte v) {
            this.source = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The synonym name."), new Field("value", Type.NULLABLE_STRING, "The synonym value."), new Field("source", Type.INT8, "The synonym source.")));
            SCHEMA_4 = new Schema(new Field("name", Type.COMPACT_STRING, "The synonym name."), new Field("value", Type.COMPACT_NULLABLE_STRING, "The synonym value."), new Field("source", Type.INT8, "The synonym source."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class DescribeConfigsResourceResult
    implements Message {
        String name;
        String value;
        boolean readOnly;
        boolean isDefault;
        byte configSource;
        boolean isSensitive;
        List<DescribeConfigsSynonym> synonyms;
        byte configType;
        String documentation;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The configuration name."), new Field("value", Type.NULLABLE_STRING, "The configuration value."), new Field("read_only", Type.BOOLEAN, "True if the configuration is read-only."), new Field("is_default", Type.BOOLEAN, "True if the configuration is not set."), new Field("is_sensitive", Type.BOOLEAN, "True if this configuration is sensitive."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public DescribeConfigsResourceResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeConfigsResourceResult() {
            this.name = "";
            this.value = "";
            this.readOnly = false;
            this.isDefault = false;
            this.configSource = (byte)-1;
            this.isSensitive = false;
            this.synonyms = new ArrayList<DescribeConfigsSynonym>(0);
            this.configType = 0;
            this.documentation = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeConfigsResourceResult");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            boolean bl = this.readOnly = _readable.readByte() != 0;
            this.isDefault = _version <= 0 ? _readable.readByte() != 0 : false;
            this.configSource = _version >= 1 ? _readable.readByte() : (byte)-1;
            boolean bl2 = this.isSensitive = _readable.readByte() != 0;
            if (_version >= 1) {
                int i;
                ArrayList<DescribeConfigsSynonym> newCollection;
                int arrayLength;
                if (_version >= 4) {
                    arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field synonyms was serialized as null");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new DescribeConfigsSynonym(_readable, _version));
                    }
                    this.synonyms = newCollection;
                } else {
                    arrayLength = _readable.readInt();
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field synonyms was serialized as null");
                    }
                    newCollection = new ArrayList<DescribeConfigsSynonym>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new DescribeConfigsSynonym(_readable, _version));
                    }
                    this.synonyms = newCollection;
                }
            } else {
                this.synonyms = new ArrayList<DescribeConfigsSynonym>(0);
            }
            this.configType = _version >= 3 ? _readable.readByte() : (byte)0;
            if (_version >= 3) {
                length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.documentation = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field documentation had invalid length " + length);
                    }
                    this.documentation = _readable.readString(length);
                }
            } else {
                this.documentation = "";
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.value == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.value);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeByte(this.readOnly ? (byte)1 : 0);
            if (_version <= 0) {
                _writable.writeByte(this.isDefault ? (byte)1 : 0);
            } else if (this.isDefault) {
                throw new UnsupportedVersionException("Attempted to write a non-default isDefault at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeByte(this.configSource);
            }
            _writable.writeByte(this.isSensitive ? (byte)1 : 0);
            if (_version >= 1) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(this.synonyms.size() + 1);
                    _stringBytes = this.synonyms.iterator();
                    while (_stringBytes.hasNext()) {
                        DescribeConfigsSynonym synonymsElement = (DescribeConfigsSynonym)_stringBytes.next();
                        synonymsElement.write(_writable, _cache, _version);
                    }
                } else {
                    _writable.writeInt(this.synonyms.size());
                    _stringBytes = this.synonyms.iterator();
                    while (_stringBytes.hasNext()) {
                        DescribeConfigsSynonym synonymsElement = (DescribeConfigsSynonym)_stringBytes.next();
                        synonymsElement.write(_writable, _cache, _version);
                    }
                }
            }
            if (_version >= 3) {
                _writable.writeByte(this.configType);
            }
            if (_version >= 3) {
                if (this.documentation == null) {
                    if (_version >= 4) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue(this.documentation);
                    if (_version >= 4) {
                        _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
                    } else {
                        _writable.writeShort((short)((Object)_stringBytes).length);
                    }
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeConfigsResourceResult");
            }
            Object _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, (byte[])_stringBytes);
            if (_version >= 4) {
                _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            } else {
                _size.addBytes(((byte[])_stringBytes).length + 2);
            }
            if (this.value == null) {
                if (_version >= 4) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.value, (byte[])_stringBytes);
                if (_version >= 4) {
                    _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
                } else {
                    _size.addBytes(((byte[])_stringBytes).length + 2);
                }
            }
            _size.addBytes(1);
            if (_version <= 0) {
                _size.addBytes(1);
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            _size.addBytes(1);
            if (_version >= 1) {
                if (_version >= 4) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.synonyms.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                _stringBytes = this.synonyms.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeConfigsSynonym synonymsElement = (DescribeConfigsSynonym)_stringBytes.next();
                    synonymsElement.addSize(_size, _cache, _version);
                }
            }
            if (_version >= 3) {
                _size.addBytes(1);
            }
            if (_version >= 3) {
                if (this.documentation == null) {
                    if (_version >= 4) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(2);
                    }
                } else {
                    _stringBytes = this.documentation.getBytes(StandardCharsets.UTF_8);
                    if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                        throw new RuntimeException("'documentation' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.documentation, (byte[])_stringBytes);
                    if (_version >= 4) {
                        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
                    } else {
                        _size.addBytes(((byte[])_stringBytes).length + 2);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeConfigsResourceResult)) {
                return false;
            }
            DescribeConfigsResourceResult other = (DescribeConfigsResourceResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (this.readOnly != other.readOnly) {
                return false;
            }
            if (this.isDefault != other.isDefault) {
                return false;
            }
            if (this.configSource != other.configSource) {
                return false;
            }
            if (this.isSensitive != other.isSensitive) {
                return false;
            }
            if (this.synonyms == null ? other.synonyms != null : !this.synonyms.equals(other.synonyms)) {
                return false;
            }
            if (this.configType != other.configType) {
                return false;
            }
            if (this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            hashCode = 31 * hashCode + (this.readOnly ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.isDefault ? 1231 : 1237);
            hashCode = 31 * hashCode + this.configSource;
            hashCode = 31 * hashCode + (this.isSensitive ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.synonyms == null ? 0 : this.synonyms.hashCode());
            hashCode = 31 * hashCode + this.configType;
            hashCode = 31 * hashCode + (this.documentation == null ? 0 : this.documentation.hashCode());
            return hashCode;
        }

        @Override
        public DescribeConfigsResourceResult duplicate() {
            DescribeConfigsResourceResult _duplicate = new DescribeConfigsResourceResult();
            _duplicate.name = this.name;
            _duplicate.value = this.value == null ? null : this.value;
            _duplicate.readOnly = this.readOnly;
            _duplicate.isDefault = this.isDefault;
            _duplicate.configSource = this.configSource;
            _duplicate.isSensitive = this.isSensitive;
            ArrayList<DescribeConfigsSynonym> newSynonyms = new ArrayList<DescribeConfigsSynonym>(this.synonyms.size());
            for (DescribeConfigsSynonym _element : this.synonyms) {
                newSynonyms.add(_element.duplicate());
            }
            _duplicate.synonyms = newSynonyms;
            _duplicate.configType = this.configType;
            _duplicate.documentation = this.documentation == null ? null : this.documentation;
            return _duplicate;
        }

        public String toString() {
            return "DescribeConfigsResourceResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ", readOnly=" + (this.readOnly ? "true" : "false") + ", isDefault=" + (this.isDefault ? "true" : "false") + ", configSource=" + this.configSource + ", isSensitive=" + (this.isSensitive ? "true" : "false") + ", synonyms=" + MessageUtil.deepToString(this.synonyms.iterator()) + ", configType=" + this.configType + ", documentation=" + (this.documentation == null ? "null" : "'" + this.documentation.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public boolean readOnly() {
            return this.readOnly;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public byte configSource() {
            return this.configSource;
        }

        public boolean isSensitive() {
            return this.isSensitive;
        }

        public List<DescribeConfigsSynonym> synonyms() {
            return this.synonyms;
        }

        public byte configType() {
            return this.configType;
        }

        public String documentation() {
            return this.documentation;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeConfigsResourceResult setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeConfigsResourceResult setValue(String v) {
            this.value = v;
            return this;
        }

        public DescribeConfigsResourceResult setReadOnly(boolean v) {
            this.readOnly = v;
            return this;
        }

        public DescribeConfigsResourceResult setIsDefault(boolean v) {
            this.isDefault = v;
            return this;
        }

        public DescribeConfigsResourceResult setConfigSource(byte v) {
            this.configSource = v;
            return this;
        }

        public DescribeConfigsResourceResult setIsSensitive(boolean v) {
            this.isSensitive = v;
            return this;
        }

        public DescribeConfigsResourceResult setSynonyms(List<DescribeConfigsSynonym> v) {
            this.synonyms = v;
            return this;
        }

        public DescribeConfigsResourceResult setConfigType(byte v) {
            this.configType = v;
            return this;
        }

        public DescribeConfigsResourceResult setDocumentation(String v) {
            this.documentation = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The configuration name."), new Field("value", Type.NULLABLE_STRING, "The configuration value."), new Field("read_only", Type.BOOLEAN, "True if the configuration is read-only."), new Field("config_source", Type.INT8, "The configuration source."), new Field("is_sensitive", Type.BOOLEAN, "True if this configuration is sensitive."), new Field("synonyms", new ArrayOf(DescribeConfigsSynonym.SCHEMA_1), "The synonyms for this configuration key."));
            SCHEMA_3 = new Schema(new Field("name", Type.STRING, "The configuration name."), new Field("value", Type.NULLABLE_STRING, "The configuration value."), new Field("read_only", Type.BOOLEAN, "True if the configuration is read-only."), new Field("config_source", Type.INT8, "The configuration source."), new Field("is_sensitive", Type.BOOLEAN, "True if this configuration is sensitive."), new Field("synonyms", new ArrayOf(DescribeConfigsSynonym.SCHEMA_1), "The synonyms for this configuration key."), new Field("config_type", Type.INT8, "The configuration data type. Type can be one of the following values - BOOLEAN, STRING, INT, SHORT, LONG, DOUBLE, LIST, CLASS, PASSWORD"), new Field("documentation", Type.NULLABLE_STRING, "The configuration documentation."));
            SCHEMA_4 = new Schema(new Field("name", Type.COMPACT_STRING, "The configuration name."), new Field("value", Type.COMPACT_NULLABLE_STRING, "The configuration value."), new Field("read_only", Type.BOOLEAN, "True if the configuration is read-only."), new Field("config_source", Type.INT8, "The configuration source."), new Field("is_sensitive", Type.BOOLEAN, "True if this configuration is sensitive."), new Field("synonyms", new CompactArrayOf(DescribeConfigsSynonym.SCHEMA_4), "The synonyms for this configuration key."), new Field("config_type", Type.INT8, "The configuration data type. Type can be one of the following values - BOOLEAN, STRING, INT, SHORT, LONG, DOUBLE, LIST, CLASS, PASSWORD"), new Field("documentation", Type.COMPACT_NULLABLE_STRING, "The configuration documentation."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class DescribeConfigsResult
    implements Message {
        short errorCode;
        String errorMessage;
        byte resourceType;
        String resourceName;
        List<DescribeConfigsResourceResult> configs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if we were able to successfully describe the configurations."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if we were able to successfully describe the configurations."), new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configs", new ArrayOf(DescribeConfigsResourceResult.SCHEMA_0), "Each listed configuration."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public DescribeConfigsResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeConfigsResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.resourceType = 0;
            this.resourceName = "";
            this.configs = new ArrayList<DescribeConfigsResourceResult>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribeConfigsResourceResult> newCollection;
            int arrayLength;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeConfigsResult");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            this.resourceType = _readable.readByte();
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeConfigsResourceResult(_readable, _version));
                }
                this.configs = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                newCollection = new ArrayList<DescribeConfigsResourceResult>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribeConfigsResourceResult(_readable, _version));
                }
                this.configs = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeByte(this.resourceType);
            _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.configs.size() + 1);
                _stringBytes = this.configs.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeConfigsResourceResult configsElement = (DescribeConfigsResourceResult)_stringBytes.next();
                    configsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.configs.size());
                _stringBytes = this.configs.iterator();
                while (_stringBytes.hasNext()) {
                    DescribeConfigsResourceResult configsElement = (DescribeConfigsResourceResult)_stringBytes.next();
                    configsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeConfigsResult");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                if (_version >= 4) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                if (_version >= 4) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(1);
            _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.configs.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (DescribeConfigsResourceResult configsElement : this.configs) {
                configsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeConfigsResult)) {
                return false;
            }
            DescribeConfigsResult other = (DescribeConfigsResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.configs == null ? other.configs != null : !this.configs.equals(other.configs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + (this.configs == null ? 0 : this.configs.hashCode());
            return hashCode;
        }

        @Override
        public DescribeConfigsResult duplicate() {
            DescribeConfigsResult _duplicate = new DescribeConfigsResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.resourceType = this.resourceType;
            _duplicate.resourceName = this.resourceName;
            ArrayList<DescribeConfigsResourceResult> newConfigs = new ArrayList<DescribeConfigsResourceResult>(this.configs.size());
            for (DescribeConfigsResourceResult _element : this.configs) {
                newConfigs.add(_element.duplicate());
            }
            _duplicate.configs = newConfigs;
            return _duplicate;
        }

        public String toString() {
            return "DescribeConfigsResult(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", configs=" + MessageUtil.deepToString(this.configs.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public List<DescribeConfigsResourceResult> configs() {
            return this.configs;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeConfigsResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeConfigsResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DescribeConfigsResult setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DescribeConfigsResult setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DescribeConfigsResult setConfigs(List<DescribeConfigsResourceResult> v) {
            this.configs = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if we were able to successfully describe the configurations."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if we were able to successfully describe the configurations."), new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configs", new ArrayOf(DescribeConfigsResourceResult.SCHEMA_1), "Each listed configuration."));
            SCHEMA_3 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if we were able to successfully describe the configurations."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if we were able to successfully describe the configurations."), new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configs", new ArrayOf(DescribeConfigsResourceResult.SCHEMA_3), "Each listed configuration."));
            SCHEMA_4 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if we were able to successfully describe the configurations."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if we were able to successfully describe the configurations."), new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.COMPACT_STRING, "The resource name."), new Field("configs", new CompactArrayOf(DescribeConfigsResourceResult.SCHEMA_4), "Each listed configuration."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

