/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.RequestCompletionHandler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.RequestHeaderData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.RequestHeader;

public final class ClientRequest {
    private final String destination;
    private final AbstractRequest.Builder<?> requestBuilder;
    private final int correlationId;
    private final String clientId;
    private final long createdTimeMs;
    private final boolean expectResponse;
    private final int requestTimeoutMs;
    private final RequestCompletionHandler callback;

    public ClientRequest(String destination, AbstractRequest.Builder<?> requestBuilder, int correlationId, String clientId, long createdTimeMs, boolean expectResponse, int requestTimeoutMs, RequestCompletionHandler callback) {
        this.destination = destination;
        this.requestBuilder = requestBuilder;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.createdTimeMs = createdTimeMs;
        this.expectResponse = expectResponse;
        this.requestTimeoutMs = requestTimeoutMs;
        this.callback = callback;
    }

    public String toString() {
        return "ClientRequest(expectResponse=" + this.expectResponse + ", callback=" + this.callback + ", destination=" + this.destination + ", correlationId=" + this.correlationId + ", clientId=" + this.clientId + ", createdTimeMs=" + this.createdTimeMs + ", requestBuilder=" + this.requestBuilder + ")";
    }

    public boolean expectResponse() {
        return this.expectResponse;
    }

    public ApiKeys apiKey() {
        return this.requestBuilder.apiKey();
    }

    public RequestHeader makeHeader(short version) {
        ApiKeys requestApiKey = this.apiKey();
        return new RequestHeader(new RequestHeaderData().setRequestApiKey(requestApiKey.id).setRequestApiVersion(version).setClientId(this.clientId).setCorrelationId(this.correlationId), requestApiKey.requestHeaderVersion(version));
    }

    public AbstractRequest.Builder<?> requestBuilder() {
        return this.requestBuilder;
    }

    public String destination() {
        return this.destination;
    }

    public RequestCompletionHandler callback() {
        return this.callback;
    }

    public long createdTimeMs() {
        return this.createdTimeMs;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }
}

