/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.table;

import com.ververica.cdc.connectors.mysql.MySqlSource;
import com.ververica.cdc.connectors.mysql.rds.config.AliyunRdsConfig;
import com.ververica.cdc.connectors.mysql.source.MySqlEvolvingSourceDeserializeSchema;
import com.ververica.cdc.connectors.mysql.source.MySqlSourceBuilder;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.source.utils.SerializerUtils;
import com.ververica.cdc.connectors.mysql.table.MySqlDeserializationConverterFactory;
import com.ververica.cdc.connectors.mysql.table.MySqlReadableMetadata;
import com.ververica.cdc.connectors.mysql.table.MySqlReadableSystemColumn;
import com.ververica.cdc.connectors.mysql.table.MySqlTableSpec;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.table.MetadataConverter;
import com.ververica.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.EvolvingSourceProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsSchemaEvolutionReading;
import org.apache.flink.table.connector.source.abilities.SupportsTableSourceMerge;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class MySqlTableSource
implements ScanTableSource,
SupportsReadingMetadata,
SupportsSchemaEvolutionReading,
SupportsTableSourceMerge {
    private final ResolvedSchema physicalSchemaWithSystemData;
    private final int port;
    private final String hostname;
    private final String database;
    private final String username;
    private final String password;
    private final String serverId;
    private final String tableName;
    private final ZoneId serverTimeZone;
    private final Properties dbzProperties;
    private final boolean enableParallelRead;
    private final int splitSize;
    private final int splitMetaGroupSize;
    private final int fetchSize;
    private final Duration connectTimeout;
    private final int connectionPoolSize;
    private final int connectMaxRetries;
    private final double distributionFactorUpper;
    private final double distributionFactorLower;
    private final StartupOptions startupOptions;
    private final ObjectIdentifier sourceTablePath;
    private final boolean isShardingTable;
    private final boolean scanNewlyAddedTableEnabled;
    private final boolean closeIdleReaders;
    private final Properties jdbcProperties;
    private final Duration heartbeatInterval;
    private Map<ObjectPath, String> chunkKeyColumns = new HashMap<ObjectPath, String>();
    @Nullable
    private final AliyunRdsConfig rdsConfig;
    protected DataType producedDataType;
    protected List<String> metadataKeys;
    private boolean isEvolvingSource;
    protected Set<MySqlTableSpec> capturedTables;

    public MySqlTableSource(ResolvedSchema physicalSchemaWithSystemData, int port, String hostname, String database, String tableName, String username, String password, ZoneId serverTimeZone, Properties dbzProperties, @Nullable String serverId, boolean enableParallelRead, int splitSize, int splitMetaGroupSize, int fetchSize, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, double distributionFactorUpper, double distributionFactorLower, StartupOptions startupOptions, boolean scanNewlyAddedTableEnabled, boolean closeIdleReaders, Properties jdbcProperties, Duration heartbeatInterval, ObjectIdentifier sourceTablePath, boolean isShardingTable, @Nullable String chunkKeyColumn, @Nullable AliyunRdsConfig rdsConfig) {
        this.physicalSchemaWithSystemData = physicalSchemaWithSystemData;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.serverId = serverId;
        this.serverTimeZone = serverTimeZone;
        this.dbzProperties = dbzProperties;
        this.enableParallelRead = enableParallelRead;
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.fetchSize = fetchSize;
        this.connectTimeout = connectTimeout;
        this.connectMaxRetries = connectMaxRetries;
        this.connectionPoolSize = connectionPoolSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.startupOptions = startupOptions;
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        this.closeIdleReaders = closeIdleReaders;
        this.jdbcProperties = jdbcProperties;
        this.heartbeatInterval = heartbeatInterval;
        if (chunkKeyColumn != null) {
            this.chunkKeyColumns.put(new ObjectPath(database, tableName), chunkKeyColumn);
        }
        this.isShardingTable = isShardingTable;
        this.producedDataType = physicalSchemaWithSystemData.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.sourceTablePath = sourceTablePath;
        this.isEvolvingSource = false;
        this.capturedTables = new HashSet<MySqlTableSpec>();
        this.capturedTables.add(new MySqlTableSpec(sourceTablePath.toObjectPath(), new ObjectPath(database, tableName), isShardingTable));
        this.rdsConfig = rdsConfig;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.all();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        ResolvedSchema physicalSchema;
        MetadataConverter[] systemColumnConverters;
        if (!this.enableParallelRead && this.isEvolvingSource) {
            throw new IllegalArgumentException("MySql CDC as evolving source only works for the parallel source.");
        }
        if (this.isShardingTable) {
            this.validateShardingTable();
            systemColumnConverters = (MetadataConverter[])Arrays.stream(MySqlReadableSystemColumn.values()).map(MySqlReadableSystemColumn::getConverter).toArray(MetadataConverter[]::new);
            physicalSchema = this.extractPhysicalRowType(this.physicalSchemaWithSystemData);
        } else {
            systemColumnConverters = new MetadataConverter[]{};
            physicalSchema = this.physicalSchemaWithSystemData;
        }
        RowType physicalDataType = (RowType)physicalSchema.toPhysicalRowDataType().getLogicalType();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        ArrayList<String> databases = new ArrayList<String>();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (MySqlTableSpec tableSpec : this.capturedTables) {
            ObjectPath pathInMySql = tableSpec.getTablePathInMySql();
            databases.add(pathInMySql.getDatabaseName());
            tableNames.add(pathInMySql.getDatabaseName() + "\\." + pathInMySql.getObjectName());
        }
        MetadataConverter[] metadataConverters = SerializerUtils.getMetadataConverters(this.metadataKeys);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setSystemColumnConverters(systemColumnConverters).setMetadataConverters(metadataConverters).setResultTypeInfo((TypeInformation<RowData>)typeInfo).setServerTimeZone(this.serverTimeZone).setUserDefinedConverterFactory(MySqlDeserializationConverterFactory.instance()).build();
        if (this.enableParallelRead) {
            MySqlSourceBuilder<RowData> parallelSourceBuilder = this.isEvolvingSource ? com.ververica.cdc.connectors.mysql.source.MySqlSource.builder() : com.ververica.cdc.connectors.mysql.source.MySqlSource.builder();
            parallelSourceBuilder.hostname(this.hostname).port(this.port).databaseList(databases.toArray(new String[0])).tableList(tableNames.toArray(new String[0])).username(this.username).password(this.password).serverTimeZone(this.serverTimeZone.toString()).serverId(this.serverId).splitSize(this.splitSize).splitMetaGroupSize(this.splitMetaGroupSize).distributionFactorUpper(this.distributionFactorUpper).distributionFactorLower(this.distributionFactorLower).fetchSize(this.fetchSize).connectTimeout(this.connectTimeout).connectMaxRetries(this.connectMaxRetries).connectionPoolSize(this.connectionPoolSize).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).closeIdleReaders(this.closeIdleReaders).scanNewlyAddedTableEnabled(this.scanNewlyAddedTableEnabled).jdbcProperties(this.jdbcProperties).heartbeatInterval(this.heartbeatInterval).chunkKeyColumns(this.chunkKeyColumns);
            if (this.rdsConfig != null) {
                parallelSourceBuilder.enableReadingRdsArchivedBinlog(this.rdsConfig);
            }
            if (this.isEvolvingSource) {
                MySqlEvolvingSourceDeserializeSchema evolvingSourceDeserializeSchema = new MySqlEvolvingSourceDeserializeSchema(this.capturedTables, this.serverTimeZone, scanContext.getEvolvingSourceTypeInfo(), Boolean.parseBoolean(this.jdbcProperties.getProperty("tinyInt1isBit", "true")));
                return EvolvingSourceProvider.of(parallelSourceBuilder.deserializer((DebeziumDeserializationSchema<RowData>)evolvingSourceDeserializeSchema).build());
            }
            return this.getParallelSourceProviderWithCheckPK(parallelSourceBuilder.deserializer(deserializer).build(), physicalSchema, this.chunkKeyColumns.get(new ObjectPath(this.database, this.tableName)));
        }
        MySqlSource.Builder<RowData> builder = MySqlSource.builder().hostname(this.hostname).port(this.port).databaseList(this.database).tableList(this.database + "\\." + this.tableName).username(this.username).password(this.password).serverTimeZone(this.serverTimeZone.toString()).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).deserializer(deserializer);
        Optional.ofNullable(this.serverId).ifPresent(serverId -> builder.serverId(Integer.parseInt(serverId)));
        DebeziumSourceFunction<RowData> sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(MySqlReadableMetadata.values()).collect(Collectors.toMap(MySqlReadableMetadata::getKey, MySqlReadableMetadata::getDataType, (existingValue, newValue) -> newValue, LinkedHashMap::new));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
        HashSet<MySqlTableSpec> tablesWithMetadata = new HashSet<MySqlTableSpec>();
        for (MySqlTableSpec tableSpec : this.capturedTables) {
            tableSpec.setMetadataKeys(metadataKeys);
            tablesWithMetadata.add(tableSpec);
        }
        this.capturedTables = tablesWithMetadata;
    }

    public DynamicTableSource copy() {
        MySqlTableSource copiedSource = new MySqlTableSource(this.physicalSchemaWithSystemData, this.port, this.hostname, this.database, this.tableName, this.username, this.password, this.serverTimeZone, this.dbzProperties, this.serverId, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.startupOptions, this.scanNewlyAddedTableEnabled, this.closeIdleReaders, this.jdbcProperties, this.heartbeatInterval, this.sourceTablePath, this.isShardingTable, null, this.rdsConfig);
        copiedSource.metadataKeys = this.metadataKeys;
        copiedSource.producedDataType = this.producedDataType;
        copiedSource.isEvolvingSource = this.isEvolvingSource;
        copiedSource.capturedTables = this.capturedTables;
        copiedSource.chunkKeyColumns = this.chunkKeyColumns;
        return copiedSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlTableSource)) {
            return false;
        }
        MySqlTableSource that = (MySqlTableSource)o;
        return this.port == that.port && this.enableParallelRead == that.enableParallelRead && this.splitSize == that.splitSize && this.splitMetaGroupSize == that.splitMetaGroupSize && this.fetchSize == that.fetchSize && this.distributionFactorUpper == that.distributionFactorUpper && this.distributionFactorLower == that.distributionFactorLower && Objects.equals(this.physicalSchemaWithSystemData, that.physicalSchemaWithSystemData) && this.closeIdleReaders == that.closeIdleReaders && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.serverId, that.serverId) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.connectMaxRetries, that.connectMaxRetries) && Objects.equals(this.connectionPoolSize, that.connectionPoolSize) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.scanNewlyAddedTableEnabled, that.scanNewlyAddedTableEnabled) && Objects.equals(this.jdbcProperties, that.jdbcProperties) && Objects.equals(this.heartbeatInterval, that.heartbeatInterval) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.isEvolvingSource, that.isEvolvingSource) && Objects.equals(this.sourceTablePath, that.sourceTablePath) && Objects.equals(this.isShardingTable, that.isShardingTable) && Objects.equals(this.capturedTables, that.capturedTables) && Objects.equals(this.chunkKeyColumns, that.chunkKeyColumns) && Objects.equals(this.rdsConfig, that.rdsConfig);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchemaWithSystemData, this.port, this.hostname, this.database, this.username, this.password, this.serverId, this.tableName, this.serverTimeZone, this.dbzProperties, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.startupOptions, this.producedDataType, this.metadataKeys, this.scanNewlyAddedTableEnabled, this.closeIdleReaders, this.jdbcProperties, this.heartbeatInterval, this.isEvolvingSource, this.sourceTablePath, this.isShardingTable, this.capturedTables, this.chunkKeyColumns, this.rdsConfig);
    }

    public String asSummaryString() {
        return "MySQL-CDC";
    }

    public void applySchemaEvolution() {
        this.isEvolvingSource = true;
    }

    public boolean applyTableSource(ScanTableSource anotherScanTableSource) {
        if (anotherScanTableSource instanceof MySqlTableSource) {
            MySqlTableSource anotherMySQLTableSource = (MySqlTableSource)anotherScanTableSource;
            if (!this.enableParallelRead || !anotherMySQLTableSource.enableParallelRead) {
                throw new IllegalArgumentException("Table source merge is only supported when all tables enable parallel read.");
            }
            if (this.hostname.equals(anotherMySQLTableSource.hostname) && this.port == anotherMySQLTableSource.port && this.dbzProperties.equals(anotherMySQLTableSource.dbzProperties) && this.startupOptions.equals(anotherMySQLTableSource.startupOptions)) {
                this.capturedTables.addAll(((MySqlTableSource)anotherScanTableSource).capturedTables);
                this.chunkKeyColumns.putAll(((MySqlTableSource)anotherScanTableSource).chunkKeyColumns);
                return true;
            }
        }
        return false;
    }

    private SourceProvider getParallelSourceProviderWithCheckPK(final Source<RowData, ?, ?> source, final ResolvedSchema physicalSchema, final @Nullable String chunkKeyColumn) {
        return new SourceProvider(){

            public Source<RowData, ?, ?> createSource() {
                MySqlTableSource.this.validatePrimaryKeyIfEnableParallel(physicalSchema, chunkKeyColumn);
                return source;
            }

            public boolean isBounded() {
                return Boundedness.BOUNDED.equals((Object)source.getBoundedness());
            }
        };
    }

    private void validatePrimaryKeyIfEnableParallel(ResolvedSchema physicalSchema, @Nullable String chunkKeyColumn) {
        if (chunkKeyColumn == null && !physicalSchema.getPrimaryKey().isPresent()) {
            throw new ValidationException(String.format("'%s' is required for table without primary key when '%s' enabled.", MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN.key(), MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED.key()));
        }
    }

    private void validateShardingTable() {
        boolean isLegal = false;
        if (this.physicalSchemaWithSystemData.getColumnCount() >= MySqlReadableSystemColumn.values().length) {
            isLegal = true;
            for (MySqlReadableSystemColumn systemData : MySqlReadableSystemColumn.values()) {
                Optional column = this.physicalSchemaWithSystemData.getColumn(systemData.getIndex());
                if (!column.isPresent()) {
                    isLegal = false;
                    break;
                }
                Column actualColumn = (Column)column.get();
                if (actualColumn.getName().equals(systemData.getKey()) && actualColumn.getDataType().equals((Object)systemData.getDataType())) continue;
                isLegal = false;
                break;
            }
        }
        if (!isLegal) {
            throw new IllegalArgumentException(String.format("Sharding table should has all the system columns, but get schema: %s.", this.physicalSchemaWithSystemData));
        }
    }

    /*
     * Exception decompiling
     */
    private ResolvedSchema extractPhysicalRowType(ResolvedSchema inputSchema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResolvedSchema projectSchema(ResolvedSchema tableSchema, int[][] projectedFields) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int[] fieldPath : projectedFields) {
            Preconditions.checkArgument((fieldPath.length == 1 ? 1 : 0) != 0, (Object)"Nested projection push down is not supported yet.");
            Column column = (Column)tableSchema.getColumn(fieldPath[0]).get();
            columns.add(column);
        }
        return new ResolvedSchema(columns, Collections.emptyList(), (UniqueConstraint)tableSchema.getPrimaryKey().orElse(null));
    }

    private static /* synthetic */ int[][] lambda$extractPhysicalRowType$4(int x$0) {
        return new int[x$0][];
    }
}

