/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.table.MetadataConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;

public enum MySqlReadableSystemColumn {
    DATABASE_NAME(0, "_db_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("db"));
        }
    }),
    TABLE_NAME(1, "_table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("table"));
        }
    });

    private final int index;
    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;

    private MySqlReadableSystemColumn(int index, String key, DataType dataType, MetadataConverter converter) {
        this.index = index;
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public int getIndex() {
        return this.index;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }
}

