/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public class TableSchemaCache
implements Serializable {
    private final String[] fieldNames;
    private final DataType[] fieldDataTypes;
    private final RowData.FieldGetter[] fieldGetters;
    private final Map<String, Integer> fieldNameToIndex = new HashMap<String, Integer>();
    @Nullable
    private final List<String> pkFields;

    public TableSchemaCache(TableSchema tableSchema) {
        int i;
        Preconditions.checkNotNull((Object)tableSchema);
        this.fieldNames = tableSchema.getFieldNames();
        this.fieldDataTypes = tableSchema.getFieldDataTypes();
        for (i = 0; i < this.fieldNames.length; ++i) {
            this.fieldNameToIndex.put(this.fieldNames[i], i);
        }
        this.fieldGetters = new RowData.FieldGetter[this.fieldNames.length];
        for (i = 0; i < this.fieldGetters.length; ++i) {
            this.fieldGetters[i] = RowData.createFieldGetter((LogicalType)this.fieldDataTypes[i].getLogicalType(), (int)i);
        }
        this.pkFields = tableSchema.getPrimaryKey().map(UniqueConstraint::getColumns).orElse(null);
    }

    public int getArity() {
        return this.fieldGetters.length;
    }

    public RowData.FieldGetter[] getFieldGetters() {
        return this.fieldGetters;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public DataType[] getFieldDataTypes() {
        return this.fieldDataTypes;
    }

    public DataType[] getPrimaryKeyFieldDataTypes() {
        Preconditions.checkNotNull(this.pkFields);
        DataType[] keyTypes = new DataType[this.pkFields.size()];
        for (int i = 0; i < this.pkFields.size(); ++i) {
            int fieldIndex = this.fieldNameToIndex.get(this.pkFields.get(i));
            keyTypes[i] = this.fieldDataTypes[fieldIndex];
        }
        return keyTypes;
    }

    @Nullable
    public List<String> getPkFields() {
        return this.pkFields;
    }

    public RowData getPrimaryKey(RowData rowData) {
        Preconditions.checkNotNull(this.pkFields);
        GenericRowData keyRow = new GenericRowData(this.pkFields.size());
        for (int i = 0; i < this.pkFields.size(); ++i) {
            int fieldIndex = this.fieldNameToIndex.get(this.pkFields.get(i));
            keyRow.setField(i, this.fieldGetters[fieldIndex].getFieldOrNull(rowData));
        }
        return keyRow;
    }
}

