/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.dim;

import com.alibaba.ververica.connectors.common.dim.DimJoinFetcher;
import com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy;
import com.alibaba.ververica.connectors.common.source.SourceUtils;
import com.alibaba.ververica.connectors.jdbc.util.JdbcRowConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcRowFetcherBase
extends DimJoinFetcher<List<RowData>>
implements FlatMapFunction<RowData, RowData>,
ResultTypeQueryable<RowData> {
    private static final long serialVersionUID = 281376837810034203L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRowFetcherBase.class);
    protected final String queryTemplate;
    protected final int maxRetries;
    protected final int maxFetchResults;
    protected final String[] fieldNames;
    protected final DataType[] fieldTypes;
    protected final DataType[] lookupKeyTypes;
    protected final JdbcRowConverter jdbcRowConverter;
    protected final JdbcRowConverter lookupKeyRowConverter;
    protected volatile transient Connection connection = null;
    protected transient PreparedStatement statement;
    protected volatile boolean isClosed = false;
    protected static final long MAX_RETRY_SLEEP_TIME = 5000L;
    protected final TypeInformation<RowData> producedType;
    protected final boolean hasPrimaryKey;

    public JdbcRowFetcherBase(String sqlTableName, TableSchema tableSchema, String[] lookupKeys, CacheStrategy cacheStrategy, int maxRetries, int maxFetchResults, String queryTemplate, Function<DataType[], JdbcRowConverter> jdbcRowConverterFunction) {
        super(sqlTableName, (RowType)tableSchema.toPhysicalRowDataType().getLogicalType(), lookupKeys, cacheStrategy);
        this.maxRetries = maxRetries;
        this.maxFetchResults = maxFetchResults;
        this.fieldNames = tableSchema.getFieldNames();
        this.fieldTypes = tableSchema.getFieldDataTypes();
        this.lookupKeyTypes = new DataType[lookupKeys.length];
        List<String> nameList = Arrays.asList(this.fieldNames);
        for (int i = 0; i < lookupKeys.length; ++i) {
            DataType keyType;
            Preconditions.checkArgument((boolean)nameList.contains(lookupKeys[i]), (String)"keyName %s can't find in fieldNames %s.", (Object[])new Object[]{lookupKeys[i], nameList});
            int keyIdx = nameList.indexOf(lookupKeys[i]);
            this.lookupKeyTypes[i] = keyType = this.fieldTypes[keyIdx];
        }
        this.queryTemplate = queryTemplate;
        LOG.info("queryTemplate is : {}", (Object)queryTemplate);
        this.jdbcRowConverter = jdbcRowConverterFunction.apply(this.fieldTypes);
        this.lookupKeyRowConverter = jdbcRowConverterFunction.apply(this.lookupKeyTypes);
        this.hasPrimaryKey = SourceUtils.hasValidPrimaryKey(tableSchema, lookupKeys);
        this.producedType = InternalTypeInfo.of((LogicalType)tableSchema.toRowDataType().getLogicalType());
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    @Override
    public void openConnection(Configuration parameters) {
        try {
            this.createConnectionAndStatement();
        }
        catch (SQLException e) {
            LOG.error("Fail to open connection for table:" + this.sqlTableName, e);
            throw new RuntimeException("Fail to open connection for table:" + this.sqlTableName, e);
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOG.error("Fail to close connection for table:" + this.sqlTableName, e);
            throw new RuntimeException("Fail to close connection for table:" + this.sqlTableName, e);
        }
        finally {
            this.closeDataSource();
        }
    }

    protected void createConnectionAndStatement() throws SQLException {
        if (null == this.connection || this.connection.isClosed()) {
            if (this.statement != null) {
                this.statement.close();
            }
            this.connection = this.connectToTable();
            LOG.debug("queryTemplate: {}", (Object)this.queryTemplate);
            this.statement = this.connection.prepareStatement(this.queryTemplate);
        }
    }

    protected abstract Connection connectToTable();

    protected abstract void closeDataSource();

    protected abstract String getConnectorType();

    @Override
    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedType;
    }

    public void flatMap(RowData row, Collector<RowData> collector) throws Exception {
        Object key = this.getSourceKey(row);
        if (key == null) {
            LOG.debug("Join {} on empty key of row: {}", (Object)this.getConnectorType(), (Object)row);
            return;
        }
        List cachedRows = (List)this.cache.get(key);
        if (cachedRows != null) {
            int resultCount = 0;
            for (RowData cachedRow : cachedRows) {
                if (resultCount >= this.maxFetchResults) break;
                collector.collect((Object)cachedRow);
                ++resultCount;
            }
            return;
        }
        try (ResultSet resultSet = this.retryExecuteQuery(row);){
            ArrayList<RowData> rowDatas = new ArrayList<RowData>();
            for (int resultCount = 0; resultSet.next() && resultCount < this.maxFetchResults; ++resultCount) {
                RowData rowData = this.jdbcRowConverter.toInternal(resultSet);
                rowDatas.add(rowData);
                collector.collect((Object)rowData);
            }
            rowDatas.trimToSize();
            this.cache.put(key, rowDatas);
        }
    }

    private ResultSet retryExecuteQuery(RowData keysRow) throws Exception {
        int attemptNum = 0;
        Exception lastError = null;
        while (attemptNum++ < this.maxRetries) {
            if (this.isClosed) {
                throw new RuntimeException("JdbcRowFetcher has been closed!");
            }
            try {
                this.createConnectionAndStatement();
                this.statement.clearParameters();
                this.statement = this.lookupKeyRowConverter.toExternal(keysRow, this.statement);
                return this.statement.executeQuery();
            }
            catch (Exception e) {
                LOG.warn("Error happens when query MySQL, try for the {} time.", (Object)attemptNum, (Object)e);
                lastError = e;
                try {
                    if (this.isClosed || attemptNum >= this.maxRetries) continue;
                    Thread.sleep(Math.min(1000L * (long)attemptNum, 5000L));
                }
                catch (Exception exception) {}
            }
        }
        assert (lastError != null);
        throw lastError;
    }
}

