/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc;

import com.alibaba.ververica.connectors.common.util.ContextUtil;
import com.alibaba.ververica.connectors.jdbc.VervericaJdbcDynamicTableSource;
import com.alibaba.ververica.connectors.jdbc.VervericaJdbcValidator;
import com.alibaba.ververica.connectors.jdbc.dim.VervericaJdbcLookupOptions;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;

public abstract class VervericaJdbcDynamicTableSourceSinkFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private final String connectorType;
    private final JdbcDialect dialect;

    public VervericaJdbcDynamicTableSourceSinkFactory(String connectorType, JdbcDialect dialect) {
        this.connectorType = connectorType;
        this.dialect = dialect;
    }

    protected JdbcDialect getJdbcDialect(ReadableConfig config) {
        return this.dialect;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        DynamicTableFactory.Context normalizedContext = ContextUtil.normalizeContext((DynamicTableFactory)this, context);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)normalizedContext);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        JdbcDialect jdbcDialect = this.getJdbcDialect(config);
        VervericaJdbcValidator.validateConfigOptions(config, jdbcDialect);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)normalizedContext.getCatalogTable().getSchema());
        return new VervericaJdbcDynamicTableSource(this.getJdbcOptions(helper.getOptions(), jdbcDialect), this.getJdbcLookupOptions(helper.getOptions()), physicalSchema);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        DynamicTableFactory.Context normalizedContext = ContextUtil.normalizeContext((DynamicTableFactory)this, context);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)normalizedContext);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        JdbcDialect jdbcDialect = this.getJdbcDialect(config);
        VervericaJdbcValidator.validateConfigOptions(config, jdbcDialect);
        InternalJdbcConnectionOptions jdbcOptions = this.getJdbcOptions(config, jdbcDialect);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)normalizedContext.getCatalogTable().getSchema());
        return new JdbcDynamicTableSink(jdbcOptions, this.getJdbcSinkOptions(config), this.getJdbcDmlOptions(jdbcOptions, physicalSchema), physicalSchema.toPhysicalRowDataType());
    }

    private InternalJdbcConnectionOptions getJdbcOptions(ReadableConfig readableConfig, JdbcDialect jdbcDialect) {
        InternalJdbcConnectionOptions.Builder builder = InternalJdbcConnectionOptions.builder().setDBUrl((String)readableConfig.get(VervericaJdbcValidator.URL)).setTableName((String)readableConfig.get(VervericaJdbcValidator.TABLENAME)).setDialect(jdbcDialect).setConnectionCheckTimeoutSeconds((int)((Duration)readableConfig.get(VervericaJdbcValidator.MAX_RETRY_TIMEOUT)).getSeconds());
        readableConfig.getOptional(VervericaJdbcValidator.USERNAME).ifPresent(builder::setUsername);
        readableConfig.getOptional(VervericaJdbcValidator.PASSWORD).ifPresent(builder::setPassword);
        return builder.build();
    }

    private JdbcExecutionOptions getJdbcSinkOptions(ReadableConfig config) {
        JdbcExecutionOptions.Builder builder = JdbcExecutionOptions.builder();
        builder.withBatchSize((Integer)config.get(VervericaJdbcValidator.SINK_BUFFER_FLUSH_MAX_ROWS));
        builder.withBatchIntervalMs((Long)config.get(VervericaJdbcValidator.SINK_BUFFER_FLUSH_INTERVAL));
        builder.withMaxRetries((Integer)config.get(VervericaJdbcValidator.MAX_RETRIES));
        return builder.build();
    }

    private VervericaJdbcLookupOptions getJdbcLookupOptions(ReadableConfig readableConfig) {
        VervericaJdbcLookupOptions.Builder builder = VervericaJdbcLookupOptions.builder();
        builder.withCacheStrategy((String)readableConfig.get(VervericaJdbcValidator.LOOKUP_CACHE_STRATEGY)).withCacheMaxSize((Long)readableConfig.get(VervericaJdbcValidator.LOOKUP_CACHE_MAX_ROWS)).withCacheExpireMs((Long)readableConfig.get(VervericaJdbcValidator.LOOKUP_CACHE_TTL)).withMaxRetryTimes((Integer)readableConfig.get(VervericaJdbcValidator.MAX_RETRIES));
        return builder.build();
    }

    private JdbcDmlOptions getJdbcDmlOptions(InternalJdbcConnectionOptions jdbcOptions, TableSchema schema) {
        String[] keyFields = schema.getPrimaryKey().map(pk -> pk.getColumns().toArray(new String[0])).orElse(null);
        return JdbcDmlOptions.builder().withTableName(jdbcOptions.getTableName()).withDialect(jdbcOptions.getDialect()).withFieldNames(schema.getFieldNames()).withKeyFields(keyFields).build();
    }

    public String factoryIdentifier() {
        return this.connectorType;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(VervericaJdbcValidator.URL);
        requiredOptions.add(VervericaJdbcValidator.TABLENAME);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(VervericaJdbcValidator.USERNAME);
        optionalOptions.add(VervericaJdbcValidator.PASSWORD);
        optionalOptions.add(VervericaJdbcValidator.MAX_RETRIES);
        optionalOptions.add(VervericaJdbcValidator.LOOKUP_CACHE_STRATEGY);
        optionalOptions.add(VervericaJdbcValidator.LOOKUP_CACHE_MAX_ROWS);
        optionalOptions.add(VervericaJdbcValidator.LOOKUP_CACHE_TTL);
        optionalOptions.add(VervericaJdbcValidator.SINK_BUFFER_FLUSH_MAX_ROWS);
        optionalOptions.add(VervericaJdbcValidator.SINK_BUFFER_FLUSH_INTERVAL);
        optionalOptions.add(VervericaJdbcValidator.MAX_RETRY_TIMEOUT);
        return optionalOptions;
    }
}

