/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.nio.charset.Charset;
import org.apache.flink.table.data.binary.BinaryStringData;

public class StringUtils {
    public static boolean isEmpty(String ... strs) {
        for (String str : strs) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(String ... strs) {
        return !StringUtils.isEmpty(strs);
    }

    public static String[] splitPreserveAllTokens(String src, String delimiter) {
        if (src == null) {
            return null;
        }
        if (delimiter == null) {
            return new String[]{src};
        }
        if (delimiter.length() == 1) {
            return org.apache.commons.lang3.StringUtils.splitPreserveAllTokens((String)src, (char)delimiter.charAt(0));
        }
        return org.apache.commons.lang3.StringUtils.splitPreserveAllTokens((String)src, (String)delimiter);
    }

    public static String[] split(String src, String delimiter) {
        return org.apache.commons.lang3.StringUtils.split((String)src, (String)delimiter);
    }

    public static String join(String[] src) {
        return StringUtils.join(src, ",");
    }

    public static String join(String[] src, String delimiter) {
        return org.apache.commons.lang3.StringUtils.join((Object[])src, (String)delimiter);
    }

    public static boolean isBlank(String str, String delimiter) {
        if (str == null || str.length() == 0) {
            return true;
        }
        if (null == delimiter) {
            return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str);
        }
        if (delimiter.length() == 1) {
            char dChar = delimiter.charAt(0);
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(str.charAt(i)) || dChar == str.charAt(i)) continue;
                return false;
            }
        } else {
            String[] array;
            for (String s : array = org.apache.commons.lang3.StringUtils.split((String)str, (String)delimiter)) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmptyKey(Object key) {
        if (key == null) {
            return true;
        }
        String val = String.valueOf(key);
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)val);
    }

    public static String coalesce(String ... candidates) {
        if (null != candidates && candidates.length > 0) {
            for (String c : candidates) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)c)) continue;
                return c;
            }
        }
        return null;
    }

    public static byte[] toBytes(BinaryStringData string, Charset stringCharset) {
        if (stringCharset == Charset.forName("UTF-8")) {
            return string.toBytes();
        }
        return string.toString().getBytes(stringCharset);
    }

    public static BinaryStringData fromBytes(byte[] bytes, Charset stringCharset) {
        if (stringCharset == Charset.forName("UTF-8")) {
            return BinaryStringData.fromBytes((byte[])bytes);
        }
        return BinaryStringData.fromString((String)new String(bytes, stringCharset));
    }
}

