/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.flink.api.java.tuple.Tuple2;

public class DateUtil {
    private static FastDateFormat dfTimeStamp = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private static ConcurrentHashMap<String, FastDateFormat> sdfCache = new ConcurrentHashMap();

    private static FastDateFormat getDateFormat(String timeZone, String format) {
        String key = String.valueOf(timeZone) + String.valueOf(format);
        if (null == timeZone || timeZone.isEmpty()) {
            return dfTimeStamp;
        }
        if (sdfCache.containsKey(key)) {
            return sdfCache.get(key);
        }
        FastDateFormat sdf = FastDateFormat.getInstance((String)format, (TimeZone)TimeZone.getTimeZone(timeZone));
        sdfCache.put(key, sdf);
        return sdf;
    }

    public static String timeStamp2String(Timestamp value, String timeZone) {
        if (null == timeZone || timeZone.isEmpty()) {
            String res = dfTimeStamp.format((Date)value);
            return res;
        }
        return DateUtil.timeStamp2String(value, timeZone, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeStamp2String(Timestamp value, String timeZone, @Nonnull String format) {
        FastDateFormat sdf = DateUtil.getDateFormat(timeZone, format);
        return sdf.format((Date)value);
    }

    public static String date2String(java.sql.Date value, String timeZone) {
        return DateUtil.date2String(value, timeZone, "yyyy-MM-dd");
    }

    public static String date2String(java.sql.Date value, String timeZone, @Nonnull String format) {
        FastDateFormat sdf = DateUtil.getDateFormat(timeZone, format);
        return sdf.format((Date)value);
    }

    public static Long parseDateString(String formatString, String dateString, String timeZone) throws ParseException {
        FastDateFormat simpleDateFormat = DateUtil.getDateFormat(timeZone, formatString);
        return simpleDateFormat.parse(dateString).getTime();
    }

    public static boolean isTimeInRange(List<Tuple2<Long, Long>> rangeList, long time) {
        for (Tuple2<Long, Long> range : rangeList) {
            if ((Long)range.f0 > time || time > (Long)range.f1) continue;
            return true;
        }
        return false;
    }
}

