/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.sts;

import com.alibaba.ververica.connectors.common.sts.DecodeUtil;
import com.alibaba.ververica.connectors.common.sts.StsConstants;
import com.alibaba.ververica.connectors.common.sts.StsOptions;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.X509TrustAll;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import org.apache.flink.configuration.Configuration;

public class StsServiceRequest {
    private static final String INNER_STS_ENDPOINT = "__inner__blink_sts_endpoints__";

    public static AssumeRoleResponse assumeRoleWithServiceIdentity(String streamAccessId, String streamAccessKey, String roleArn, String roleSessionName, String assumeRoleFor, Configuration properties) throws Exception {
        String endPoints;
        String decodeKey = DecodeUtil.decrypt(streamAccessKey, "xxx");
        String regionId = properties.getString(StsOptions.STS.STS_REGION_ID);
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)streamAccessId, (String)decodeKey);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        if (properties.containsKey(INNER_STS_ENDPOINT) && properties.getString(INNER_STS_ENDPOINT, null) != null && !(endPoints = (String)properties.toMap().get(INNER_STS_ENDPOINT)).isEmpty()) {
            String[] endPointItem;
            for (String item : endPointItem = endPoints.split(",")) {
                String[] partItems = item.split("#");
                if (null == partItems || partItems.length != 4) continue;
                DefaultProfile.addEndpoint((String)partItems[0], (String)partItems[1], (String)partItems[2], (String)partItems[3]);
            }
        }
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setMethod(MethodType.POST);
        request.setProtocol(StsConstants.PROTOCOL_TYPE);
        request.setDurationSeconds(StsConstants.DURATION);
        request.setRoleArn(roleArn);
        request.setRoleSessionName(roleSessionName);
        X509TrustAll.ignoreSSLCertificate();
        AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        return response;
    }
}

