/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source;

import com.alibaba.ververica.connectors.common.source.AbstractParallelSourceBase;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicParallelSource<T, CURSOR extends Serializable>
extends AbstractParallelSourceBase<T, CURSOR>
implements CheckpointedFunction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDynamicParallelSource.class);
    private static final long serialVersionUID = -7848357196819780804L;
    private static final String SOURCE_STATE_NAME = "source_offsets_state_name";
    protected transient List<Tuple2<InputSplit, CURSOR>> reservedProgress;
    private transient ListState<InnerProgress<CURSOR>> unionInitialProgress;
    private transient List<InnerProgress<CURSOR>> allSplitsInCP;

    public abstract List<Tuple2<InputSplit, CURSOR>> reAssignInputSplitsForCurrentSubTask(int var1, int var2, List<InnerProgress<CURSOR>> var3) throws IOException;

    public List<Tuple2<InputSplit, CURSOR>> reserveInputSplitsForCurrentSubTask(int numberOfParallelSubTasks, int indexOfThisSubTask, List<InnerProgress<CURSOR>> allSplitsInState) throws IOException {
        ArrayList<Tuple2<InputSplit, CURSOR>> result = new ArrayList<Tuple2<InputSplit, CURSOR>>();
        return result;
    }

    @Override
    protected void createParallelReader(Configuration config) throws IOException {
        if (this.isRecoveryFromState()) {
            LOG.info("Reocory State!");
            this.initialProgress = this.reAssignInputSplitsForCurrentSubTask(this.getRuntimeContext().getNumberOfParallelSubtasks(), this.getRuntimeContext().getIndexOfThisSubtask(), this.allSplitsInCP);
            this.reservedProgress = this.reserveInputSplitsForCurrentSubTask(this.getRuntimeContext().getNumberOfParallelSubtasks(), this.getRuntimeContext().getIndexOfThisSubtask(), this.allSplitsInCP);
        }
        super.createParallelReader(config);
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        LOG.info("initializeState");
        ParameterizedType p = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        TypeInformation type0 = TypeExtractor.createTypeInfo(InputSplit.class);
        TypeInformation type1 = TypeExtractor.createTypeInfo((Type)p.getActualTypeArguments()[1]);
        ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
        pojoFields.add(new PojoField(InnerProgress.class.getField("inputSplit"), type0));
        pojoFields.add(new PojoField(InnerProgress.class.getField("cursor"), type1));
        PojoTypeInfo stateTypeInfo = new PojoTypeInfo(InnerProgress.class, pojoFields);
        ListStateDescriptor descriptor = new ListStateDescriptor(SOURCE_STATE_NAME, (TypeInformation)stateTypeInfo);
        this.unionInitialProgress = context.getOperatorStateStore().getUnionListState(descriptor);
        LOG.info("Restoring state: {}", (Object)this.unionInitialProgress);
        this.allSplitsInCP = new ArrayList<InnerProgress<CURSOR>>();
        if (context.isRestored()) {
            this.recoveryFromState = true;
            for (InnerProgress progress : (Iterable)this.unionInitialProgress.get()) {
                this.allSplitsInCP.add(new InnerProgress(progress.inputSplit, progress.cursor));
            }
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        if (this.disableParallelRead) {
            return;
        }
        this.unionInitialProgress.clear();
        HashSet<InputSplit> partitionWithState = new HashSet<InputSplit>();
        for (Map.Entry entry : this.parallelReader.getProgress().getProgress().entrySet()) {
            this.unionInitialProgress.add(new InnerProgress<Serializable>(entry.getKey(), (Serializable)entry.getValue()));
            partitionWithState.add(entry.getKey());
        }
        for (Tuple2 tuple2 : this.initialProgress) {
            if (partitionWithState.contains(tuple2.f0)) continue;
            this.unionInitialProgress.add(new InnerProgress<Serializable>((InputSplit)tuple2.f0, (Serializable)tuple2.f1));
        }
        if (null != this.reservedProgress) {
            for (Tuple2 tuple2 : this.reservedProgress) {
                if (partitionWithState.contains(tuple2.f0)) continue;
                this.unionInitialProgress.add(new InnerProgress<Serializable>((InputSplit)tuple2.f0, (Serializable)tuple2.f1));
            }
        }
    }

    public static class InnerProgress<CURSOR extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -7756210303146639268L;
        public InputSplit inputSplit;
        public CURSOR cursor;

        public InnerProgress() {
        }

        public InnerProgress(InputSplit inputSplit, CURSOR cursor) {
            this.inputSplit = inputSplit;
            this.cursor = cursor;
        }

        public InputSplit getInputSplit() {
            return this.inputSplit;
        }

        public InnerProgress setInputSplit(InputSplit inputSplit) {
            this.inputSplit = inputSplit;
            return this;
        }

        public CURSOR getCursor() {
            return this.cursor;
        }

        public InnerProgress setCursor(CURSOR cursor) {
            this.cursor = cursor;
            return this;
        }

        public String toString() {
            return "InnerProgress{inputSplit=" + this.inputSplit + ", cursor=" + this.cursor + '}';
        }
    }
}

