/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.precheck;

import com.alibaba.ververica.connectors.common.precheck.ConnectivityChecker;
import com.alibaba.ververica.connectors.common.precheck.ConnectivityCheckerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class ConnectivityCheckerUtils {
    public static ConnectivityChecker createSourceConnectivityChecker(Map<String, String> tableOptions) {
        String connectorIdentifier = tableOptions.get(FactoryUtil.CONNECTOR.key());
        Preconditions.checkArgument((connectorIdentifier != null ? 1 : 0) != 0, (String)"Cannot find field '%s' in the table option. This is required for factory discovering.", (Object[])new Object[]{FactoryUtil.CONNECTOR.key()});
        return ConnectivityCheckerUtils.discoverConnectivityCheckerFactory(connectorIdentifier).createSourceConnectivityChecker(tableOptions);
    }

    public static ConnectivityChecker createSinkConnectivityChecker(Map<String, String> tableOptions) {
        String connectorIdentifier = tableOptions.get(FactoryUtil.CONNECTOR.key());
        Preconditions.checkArgument((connectorIdentifier != null ? 1 : 0) != 0, (String)"Cannot find field '%s' in the table option. This is required for factory discovering.", (Object[])new Object[]{FactoryUtil.CONNECTOR.key()});
        return ConnectivityCheckerUtils.discoverConnectivityCheckerFactory(connectorIdentifier).createSinkConnectivityChecker(tableOptions);
    }

    public static ConnectivityCheckerFactory<?, ?> discoverConnectivityCheckerFactory(String factoryIdentifier) {
        ArrayList factories = new ArrayList();
        ServiceLoader.load(ConnectivityCheckerFactory.class).iterator().forEachRemaining(factories::add);
        if (factories.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not find any connectivity checker factories that implement '%s' in the classpath.", ConnectivityCheckerFactory.class.getName()));
        }
        List matchingFactories = factories.stream().filter(f -> f.factoryIdentifier().equals(factoryIdentifier)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not find any connectivity checker factory for identifier '%s' that implements '%s' in the classpath.", factoryIdentifier, ConnectivityCheckerFactory.class.getName()));
        }
        if (matchingFactories.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple factories for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", factoryIdentifier, ConnectivityCheckerFactory.class.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (ConnectivityCheckerFactory)matchingFactories.get(0);
    }
}

