/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.meta;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;

public interface ConnectorMetadataFactory {
    public String propertiesIdentifier();

    default public String getGroupId() {
        return Utils.retrieveProperty(this.getClass().getClassLoader(), this.propertiesIdentifier(), "groupId");
    }

    default public String getArtifactId() {
        return Utils.retrieveProperty(this.getClass().getClassLoader(), this.propertiesIdentifier(), "artifactId");
    }

    default public String getType() {
        return "jar";
    }

    default public String getVersion() {
        return Utils.retrieveProperty(this.getClass().getClassLoader(), this.propertiesIdentifier(), "version");
    }

    default public Boolean runtimeBundled() {
        return true;
    }

    default public String runtimeClassifier() {
        return "jar-with-dependencies";
    }

    default public String getRuntimeArtifactFileName() {
        if (this.runtimeBundled().booleanValue()) {
            return String.format("%s-%s.%s", this.getArtifactId(), this.getVersion(), this.getType());
        }
        return String.format("%s-%s-%s.%s", this.getArtifactId(), this.getVersion(), this.runtimeClassifier(), this.getType());
    }

    public static class Utils {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String retrieveProperty(ClassLoader classLoader, String propertiesIdentifier, String propertyKey) {
            String propertiesFile = String.format("META-INF/%s.properties", propertiesIdentifier);
            try (InputStream propertiesStream = classLoader.getResourceAsStream(propertiesFile);){
                if (propertiesStream == null) {
                    throw new FileNotFoundException(propertiesFile + " not found in classpath");
                }
                Properties properties = new Properties();
                properties.load(propertiesStream);
                String string = properties.getProperty(propertyKey);
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

