/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.Cache;
import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;

public class LRUCache<K, V>
implements Cache<K, V> {
    private final org.apache.flink.shaded.guava30.com.google.common.cache.Cache<K, V> cache;

    public LRUCache(long cacheSize, boolean isRecordingStats) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().maximumSize(cacheSize);
        if (isRecordingStats) {
            builder = builder.recordStats();
        }
        this.cache = builder.build();
    }

    public LRUCache(long cacheSize, long ttlMs, boolean isRecordingStats) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(ttlMs, TimeUnit.MILLISECONDS);
        if (isRecordingStats) {
            builder = builder.recordStats();
        }
        this.cache = builder.build();
    }

    @Override
    public V get(K key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public void put(K key, V row) {
        this.cache.put(key, row);
    }

    @Override
    public void remove(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public double hitRate() {
        return this.cache.stats().hitRate();
    }
}

