/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.Cache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flink.table.connector.source.KeyGroupPruner;
import org.apache.flink.table.data.RowData;

public class AllCache<K, V>
implements Cache<K, V> {
    public final ReadWriteLock lock = new ReentrantReadWriteLock();
    public AtomicBoolean isRegisteredTimer = new AtomicBoolean(false);
    public AtomicInteger counter = new AtomicInteger(0);
    private Map<K, V> cache = new HashMap(256);
    protected Map<K, V> tempCache = null;
    private ScheduledFuture<?> scheduledFuture;
    protected KeyGroupPruner<RowData> cachePartitioner;
    private volatile long lastUpdated = 0L;
    private volatile Exception exception = null;

    protected void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setCachePartitioner(KeyGroupPruner<RowData> cachePartitioner) {
        this.cachePartitioner = cachePartitioner;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isLoadedOrThrowException() throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.lastUpdated > 0L;
    }

    public boolean isLoaded() {
        return this.lastUpdated > 0L;
    }

    public void initialize() {
        this.tempCache = new HashMap(this.cache.size());
    }

    protected void switchCacheInner() {
        this.cache = this.tempCache;
    }

    public void switchCache() {
        this.lock.writeLock().lock();
        try {
            this.switchCacheInner();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.tempCache = null;
        this.lastUpdated = System.currentTimeMillis();
    }

    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public Map<K, V> getTempCache() {
        return this.tempCache;
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void put(K key, V value) {
        if (this.cachePartitioner == null || this.cachePartitioner.belongsToCurrentSubTask((RowData)value)) {
            this.tempCache.put(key, value);
        }
    }

    @Override
    public void remove(K key) {
        throw new UnsupportedOperationException("ALL cache do not support remove operation.");
    }

    @Override
    public long size() {
        this.lock.readLock().lock();
        try {
            long l = this.cache.size();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public double hitRate() {
        throw new UnsupportedOperationException("ALL cache do not support hitRate operation.");
    }
}

