/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim;

import com.alibaba.ververica.connectors.common.dim.RuntimeContextWrapper;
import com.alibaba.ververica.connectors.common.natives.NativeOptions;
import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.util.Collector;

public class LookupFunctionWrapper
extends TableFunction<RowData> {
    private static final long serialVersionUID = 6941593589582551911L;
    private final FlatMapFunction<RowData, RowData> fetcher;
    private final Collector<RowData> collector;

    public LookupFunctionWrapper(FlatMapFunction<RowData, RowData> fetcher) {
        this.fetcher = fetcher;
        this.collector = new CollectorWrapper();
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)new RuntimeContextWrapper(context));
        String nativeOperatorHandle = context.getJobParameter(NativeOptions.NATIVE_LOOKUP_HANDLE_ADDR.key(), (String)NativeOptions.NATIVE_LOOKUP_HANDLE_ADDR.defaultValue());
        String nativeBatchSize = context.getJobParameter(NativeOptions.NATIVE_ENGINE_BATCH_SIZE.key(), String.valueOf(NativeOptions.NATIVE_ENGINE_BATCH_SIZE.defaultValue()));
        String offHeapMemorySize = context.getJobParameter(TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key(), String.valueOf(((MemorySize)TaskManagerOptions.TASK_OFF_HEAP_MEMORY.defaultValue()).getBytes()));
        Configuration configuration = new Configuration();
        configuration.setString(NativeOptions.NATIVE_LOOKUP_HANDLE_ADDR, nativeOperatorHandle);
        configuration.setString(NativeOptions.NATIVE_ENGINE_BATCH_SIZE.key(), nativeBatchSize);
        configuration.setString(TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key(), offHeapMemorySize);
        FunctionUtils.openFunction(this.fetcher, (Configuration)configuration);
    }

    public void eval(Object ... inputs) throws Exception {
        GenericRowData row = GenericRowData.of((Object[])inputs);
        this.fetcher.flatMap((Object)row, this.collector);
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.fetcher);
    }

    @VisibleForTesting
    public FlatMapFunction<RowData, RowData> getFetcher() {
        return this.fetcher;
    }

    private class CollectorWrapper
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CollectorWrapper() {
        }

        public void collect(RowData baseRow) {
            LookupFunctionWrapper.this.collect(baseRow);
        }

        public void close() {
        }
    }
}

