/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class DimOptions {
    public static final ConfigOption<String> CACHE_TYPE = ConfigOptions.key((String)"cache").stringType().defaultValue((Object)"ALL");
    public static final ConfigOption<Long> MAX_CACHE_SIZE = ConfigOptions.key((String)"cacheSize").longType().defaultValue((Object)100000L);
    public static final ConfigOption<Long> MAX_ROW_COUNT = ConfigOptions.key((String)"maxRowCount").longType().defaultValue((Object)100000L);
    public static final ConfigOption<Long> CACHE_TTL = ConfigOptions.key((String)"cacheTTLMs").longType().defaultValue((Object)Long.MAX_VALUE);
    public static final ConfigOption<Boolean> CACHE_EMPTY = ConfigOptions.key((String)"cacheEmpty").booleanType().defaultValue((Object)true);
    public static final ConfigOption<String> CACHE_RELOAD_TIME_BLACKLIST = ConfigOptions.key((String)"cacheReloadTimeBlackList").stringType().noDefaultValue();
    public static final ConfigOption<Integer> CACHE_SCAN_LIMIT = ConfigOptions.key((String)"cacheScanLimit").intType().defaultValue((Object)100);
    public static final ConfigOption<Boolean> BINARY_CACHE_OPTION = ConfigOptions.key((String)"enableBinaryCache").booleanType().defaultValue((Object)true);
    public static final ConfigOption<Boolean> OPTIONAL_ASYNC = ConfigOptions.key((String)"async".toLowerCase()).defaultValue((Object)false);
    public static final ConfigOption<String> OPTIONAL_ASYNC_RESULT_ORDER = ConfigOptions.key((String)"asyncResultOrder".toLowerCase()).defaultValue((Object)"unordered");
    public static final ConfigOption<Long> OPTIONAL_ASYNC_TIMEOUT_MS = ConfigOptions.key((String)"asyncTimeoutMs".toLowerCase()).defaultValue((Object)180000L);
    public static final ConfigOption<Integer> OPTIONAL_ASYNC_CAPACITY = ConfigOptions.key((String)"asyncCapacity".toLowerCase()).defaultValue((Object)100);

    public static List<Tuple2<Long, Long>> parseTimeRangeBlacklist(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return Collections.emptyList();
        }
        String[] timeranges = str.split(",");
        ArrayList<Tuple2<Long, Long>> result = new ArrayList<Tuple2<Long, Long>>();
        for (String timerange : timeranges) {
            Date date2;
            Date date1;
            String[] times = timerange.split("->");
            if (times.length != 2) {
                throw new IllegalArgumentException(String.format("Incorrect time range Sep: %s.", str));
            }
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                date1 = dateFormat.parse(times[0]);
                date2 = dateFormat.parse(times[1]);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Dateformat error: %s, %s.", times[0], times[1]), e);
            }
            long timestamp1 = date1.getTime();
            long timestamp2 = date2.getTime();
            if (timestamp1 > timestamp2) {
                throw new IllegalArgumentException(String.format("Incorrect time range: %s, %s.", times[0], times[1]));
            }
            result.add((Tuple2<Long, Long>)Tuple2.of((Object)date1.getTime(), (Object)date2.getTime()));
        }
        return result;
    }
}

