/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.UninterruptibleThread;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5d!\u0002\u001c8\u0001]\n\u0005\"\u00031\u0001\u0005\u000b\u0007I\u0011A\u001cb\u0011!9\u0007A!A!\u0002\u0013\u0011\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u0011q\u0004!\u0011!Q\u0001\nuD\u0011\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0015\u0005\u001d\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0011)A\u0005\u0003#Aq!!\u0007\u0001\t\u0003\tY\u0002\u0003\u0006\u0002,\u0001\u0011\r\u0011\"\u00018\u0003[A\u0001\"!\u000e\u0001A\u0003%\u0011q\u0006\u0005\u000b\u0003o\u0001!\u0019!C\u0001o\u0005e\u0002\u0002CA!\u0001\u0001\u0006I!a\u000f\t\u0015\u0005\r\u0003A1A\u0005\u0002]\nI\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001e\u0011)\t9\u0005\u0001b\u0001\n\u00039\u0014Q\u0006\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u00020!Q\u00111\n\u0001C\u0002\u0013\u0005q'!\u0014\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u001fB\u0011\"a\u0017\u0001\u0001\u0004%I!!\f\t\u0013\u0005u\u0003\u00011A\u0005\n\u0005}\u0003\u0002CA6\u0001\u0001\u0006K!a\f\t\u0013\u00055\u0004A1A\u0005\n\u0005=\u0004\u0002CA9\u0001\u0001\u0006I!!\u0005\t\u0017\u0005M\u0004\u00011AA\u0002\u0013%\u0011Q\u000f\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0004\u0002\u0001\r\u0011!Q!\n\u0005]\u0004bCAC\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fC1\"a&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\"Y\u0011Q\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BAE\u0011-\ty\n\u0001a\u0001\u0002\u0004%I!a\"\t\u0017\u0005\u0005\u0006\u00011AA\u0002\u0013%\u00111\u0015\u0005\f\u0003O\u0003\u0001\u0019!A!B\u0013\tI\tC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011Q\u0018\u0001\u0005B\u0005-\u0006bBA`\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0011\u0001\u0011\u0005#1\u0005\u0005\b\u0005K\u0001A\u0011\tB\u0014\u0011\u001d\u0011I\u0003\u0001C!\u0005WAqA!\u000f\u0001\t\u0013\u0011Y\u0004C\u0004\u0003>\u0001!IAa\u0010\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!Q\u000b\u0001\u0005B\t\rra\u0002B,o!\u0005!\u0011\f\u0004\u0007m]B\tAa\u0017\t\u000f\u0005e1\u0007\"\u0001\u0003d!9!\u0011F\u001a\u0005\u0002\t\u0015$!F&bM.\fW*[2s_\n\u000bGo\u00195TiJ,\u0017-\u001c\u0006\u0003qe\n\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003um\n1a]9m\u0015\taT(A\u0003ta\u0006\u00148N\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<7C\u0002\u0001C\u0015R;&\f\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A.\u00198h\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\r=\u0013'.Z2u!\tY%+D\u0001M\u0015\tie*A\u0005tiJ,\u0017-\\5oO*\u0011q\nU\u0001\u0005e\u0016\fGM\u0003\u0002Rs\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003'2\u00131dU;qa>\u0014Ho\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><\bCA&V\u0013\t1FJ\u0001\u000bSKB|'\u000f^:T_V\u00148-Z'fiJL7m\u001d\t\u0003\u0017bK!!\u0017'\u0003!5K7M]8CCR\u001c\u0007n\u0015;sK\u0006l\u0007CA._\u001b\u0005a&BA/<\u0003!Ig\u000e^3s]\u0006d\u0017BA0]\u0005\u001daunZ4j]\u001e\f\u0011c[1gW\u0006|eMZ:fiJ+\u0017\rZ3s+\u0005\u0011\u0007CA2e\u001b\u00059\u0014BA38\u0005EY\u0015MZ6b\u001f\u001a47/\u001a;SK\u0006$WM]\u0002\u0001\u0003IY\u0017MZ6b\u001f\u001a47/\u001a;SK\u0006$WM\u001d\u0011\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0011\t)lwNQ\u0007\u0002W*\u0011ANR\u0001\u0005kRLG.\u0003\u0002oW\n\u0019Q*\u00199\u0011\u0005ALhBA9x!\t\u0011X/D\u0001t\u0015\t!h-\u0001\u0004=e>|GO\u0010\u0006\u0002m\u0006)1oY1mC&\u0011\u00010^\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002yk\u00069q\u000e\u001d;j_:\u001c\bc\u0001@\u0002\u00025\tqP\u0003\u0002ms%\u0019\u00111A@\u00031\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016\u001cFO]5oO6\u000b\u0007/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b.A\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;t!\r\u0019\u00171B\u0005\u0004\u0003\u001b9$!F&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e^\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\u0011\t\u0019\"!\u0006\u000e\u0003UL1!a\u0006v\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDCDA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011\u0006\t\u0003G\u0002AQ\u0001\u0019\u0005A\u0002\tDQ\u0001\u001b\u0005A\u0002%DQ\u0001 \u0005A\u0002uDa!!\u0002\t\u0001\u0004y\u0007bBA\u0004\u0011\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003\u001fA\u0001\u0019AA\t\u00035\u0001x\u000e\u001c7US6,w.\u001e;NgV\u0011\u0011q\u0006\t\u0005\u0003'\t\t$C\u0002\u00024U\u0014A\u0001T8oO\u0006q\u0001o\u001c7m)&lWm\\;u\u001bN\u0004\u0013\u0001F7bq>3gm]3ugB+'\u000f\u0016:jO\u001e,'/\u0006\u0002\u0002<A1\u00111CA\u001f\u0003_I1!a\u0010v\u0005\u0019y\u0005\u000f^5p]\u0006)R.\u0019=PM\u001a\u001cX\r^:QKJ$&/[4hKJ\u0004\u0013aE7j]>3gm]3u!\u0016\u0014HK]5hO\u0016\u0014\u0018\u0001F7j]>3gm]3u!\u0016\u0014HK]5hO\u0016\u0014\b%A\tnCb$&/[4hKJ$U\r\\1z\u001bN\f!#\\1y)JLwmZ3s\t\u0016d\u0017-_'tA\u0005)1\r\\8dWV\u0011\u0011q\n\t\u0005\u0003#\n)&\u0004\u0002\u0002T)\u0011AnO\u0005\u0005\u0003/\n\u0019FA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u0012Y\u0006\u001cH\u000f\u0016:jO\u001e,'/T5mY&\u001c\u0018!\u00067bgR$&/[4hKJl\u0015\u000e\u001c7jg~#S-\u001d\u000b\u0005\u0003C\n9\u0007\u0005\u0003\u0002\u0014\u0005\r\u0014bAA3k\n!QK\\5u\u0011%\tI\u0007FA\u0001\u0002\u0004\ty#A\u0002yIE\n!\u0003\\1tiR\u0013\u0018nZ4fe6KG\u000e\\5tA\u0005q\u0011N\\2mk\u0012,\u0007*Z1eKJ\u001cXCAA\t\u0003=Ign\u00197vI\u0016DU-\u00193feN\u0004\u0013aE3oIB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cXCAA<!\r\u0019\u0017\u0011P\u0005\u0004\u0003w:$!E&bM.\f7k\\;sG\u0016|eMZ:fi\u00069RM\u001c3QCJ$\u0018\u000e^5p]>3gm]3ug~#S-\u001d\u000b\u0005\u0003C\n\t\tC\u0005\u0002je\t\t\u00111\u0001\u0002x\u0005!RM\u001c3QCJ$\u0018\u000e^5p]>3gm]3ug\u0002\na\u0003\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u0012:\u00191-!$\n\u0007\u0005=u'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0015Q\u0013\u0002\u0013!\u0006\u0014H/\u001b;j_:|eMZ:fi6\u000b\u0007OC\u0002\u0002\u0010^\n!\u0004\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]0%KF$B!!\u0019\u0002\u001c\"I\u0011\u0011\u000e\u000f\u0002\u0002\u0003\u0007\u0011\u0011R\u0001\u0018Y\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ug\u0002\nQ$\u00197m\t\u0006$\u0018MR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^\u0001\"C2dG)\u0019;b\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po~#S-\u001d\u000b\u0005\u0003C\n)\u000bC\u0005\u0002j}\t\t\u00111\u0001\u0002\n\u0006q\u0012\r\u001c7ECR\fgi\u001c:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w\u000fI\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\u0015\u0005\u00055\u0006cA&\u00020&\u0019\u0011\u0011\u0017'\u0003\r=3gm]3u\u0003M9W\r\u001e#fM\u0006,H\u000e\u001e*fC\u0012d\u0015.\\5u)\t\t9\fE\u0002L\u0003sK1!a/M\u0005%\u0011V-\u00193MS6LG/\u0001\nsKB|'\u000f\u001e'bi\u0016\u001cHo\u00144gg\u0016$\u0018\u0001\u00047bi\u0016\u001cHo\u00144gg\u0016$HCBAW\u0003\u0007\f9\rC\u0004\u0002F\u0016\u0002\r!!,\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005%W\u00051\u0001\u00028\u0006I!/Z1e\u0019&l\u0017\u000e^\u0001\u000bI\u0016d\u0017-\u001f\"bi\u000eDGCCA\t\u0003\u001f\f\u0019.a;\u0002p\"9\u0011\u0011\u001b\u0014A\u0002\u0005=\u0012\u0001C7j]2KW.\u001b;\t\u000f\u0005Ug\u00051\u0001\u0002X\u0006iA.\u0019;fgR|eMZ:fiN\u0004r\u0001]Am\u00037\fy#\u0003\u0002owB!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018AB2p[6|gNC\u0002\u0002fv\nQa[1gW\u0006LA!!;\u0002`\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAwM\u0001\u0007\u0011q[\u0001\u000fGV\u0014(/\u001a8u\u001f\u001a47/\u001a;t\u0011\u001d\t9E\na\u0001\u0003_\t1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$b!!>\u0003\u0004\t\u0015\u0001CBA\n\u0003o\fY0C\u0002\u0002zV\u0014Q!\u0011:sCf\u0004B!!@\u0002\u00006\ta*C\u0002\u0003\u00029\u0013a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002F\u001e\u0002\r!!,\t\u000f\t\u001dq\u00051\u0001\u0002.\u0006\u0019QM\u001c3\u0002'\r\u0014X-\u0019;f%\u0016\fG-\u001a:GC\u000e$xN]=\u0015\u0005\t5\u0001\u0003BA\u007f\u0005\u001fI1A!\u0005O\u0005Y\u0001\u0016M\u001d;ji&|gNU3bI\u0016\u0014h)Y2u_JL\u0018!\u00053fg\u0016\u0014\u0018.\u00197ju\u0016|eMZ:fiR!\u0011Q\u0016B\f\u0011\u0019\u0011I\"\u000ba\u0001_\u0006!!n]8o\u0003\u0019\u0019w.\\7jiR!\u0011\u0011\rB\u0010\u0011\u001d\u00119A\u000ba\u0001\u0003[\u000bAa\u001d;paR\u0011\u0011\u0011M\u0001\ti>\u001cFO]5oOR\tq.A\u0004nKR\u0014\u0018nY:\u0015\t\t5\"q\u0006\t\u0005U6|w\u000eC\u0004\u000325\u0002\rAa\r\u0002)1\fG/Z:u\u0007>t7/^7fI>3gm]3u!\u0015Q'QGAW\u0013\r\u00119d\u001b\u0002\t\u001fB$\u0018n\u001c8bY\u0006\u0011s-\u001a;Pe\u000e\u0013X-\u0019;f\u0013:LG/[1m!\u0006\u0014H/\u001b;j_:|eMZ:fiN$\"!!#\u0002\u0013I\fG/\u001a'j[&$H\u0003CAE\u0005\u0003\u0012)E!\u0013\t\u000f\t\rs\u00061\u0001\u00020\u0005)A.[7ji\"9!qI\u0018A\u0002\u0005%\u0015\u0001\u00024s_6DqAa\u00130\u0001\u0004\tI)A\u0003v]RLG.\u0001\bsKB|'\u000f\u001e#bi\u0006dun]:\u0015\t\u0005\u0005$\u0011\u000b\u0005\u0007\u0005'\u0002\u0004\u0019A8\u0002\u000f5,7o]1hK\u0006i\u0002O]3qCJ,gi\u001c:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w/A\u000bLC\u001a\\\u0017-T5de>\u0014\u0015\r^2i'R\u0014X-Y7\u0011\u0005\r\u001c4\u0003B\u001a\u0003^i\u0003B!a\u0005\u0003`%\u0019!\u0011M;\u0003\r\u0005s\u0017PU3g)\t\u0011I\u0006\u0006\u0004\u0003.\t\u001d$\u0011\u000e\u0005\b\u0005c)\u0004\u0019\u0001B\u001a\u0011\u001d\u0011Y'\u000ea\u0001\u0003\u0013\u000bq\u0004\\1uKN$\u0018I^1jY\u0006\u0014G.\u001a)beRLG/[8o\u001f\u001a47/\u001a;t\u0001")
public class KafkaMicroBatchStream
implements SupportsTriggerAvailableNow,
ReportsSourceMetrics,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private long lastTriggerMillis;
    private final boolean includeHeaders;
    private KafkaSourceOffset endPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private KafkaSourceOffset endPartitionOffsets() {
        return this.endPartitionOffsets;
    }

    private void endPartitionOffsets_$eq(KafkaSourceOffset x$1) {
        this.endPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReadLimit.allAvailable()));
    }

    public Offset reportLatestOffset() {
        return new KafkaSourceOffset(this.latestPartitionOffsets());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map map;
        Seq seq;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        this.latestPartitionOffsets_$eq(this.allDataForTriggerAvailableNow() != null ? this.allDataForTriggerAvailableNow() : this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets)));
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit2;
            seq = Predef$.MODULE$.wrapRefArray((Object[])compositeReadLimit.getReadLimits());
        } else {
            seq = (Seq)new .colon.colon((Object)readLimit2, (List)Nil$.MODULE$);
        }
        Seq limits = seq;
        if (limits.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$1(x$3)))) {
            map = this.latestPartitionOffsets();
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$2(x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> (ReadMinRows)x$5);
            Option upperLimit = limits.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KafkaMicroBatchStream.$anonfun$latestOffset$4(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> (ReadMaxRows)x$7);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable & scala.Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), this.latestPartitionOffsets(), startPartitionOffsets, limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some((Object)startPartitionOffsets);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> upperLimit.map((Function1 & Serializable & scala.Serializable)limit -> this.rateLimit(limit.maxRows(), startPartitionOffsets, this.latestPartitionOffsets()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.latestPartitionOffsets());
        }
        scala.collection.immutable.Map offsets = map;
        this.endPartitionOffsets_$eq(new KafkaSourceOffset(offsets));
        return this.endPartitionOffsets();
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapLike)latestOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Iterable iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))))));
                return iterable;
            }, Map$.MODULE$.canBuildFrom())).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    public Map<String, String> metrics(Optional<Offset> latestConsumedOffset) {
        return KafkaMicroBatchStream$.MODULE$.metrics(latestConsumedOffset, this.latestPartitionOffsets());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_12;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true, strategy);
            } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                long ts = globalTimestampRangeLimit.timestamp();
                Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchGlobalTimestampBasedOffsets(ts, true, strategy);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, (Object)offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
            return var3_12;
        }))).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    public void prepareForTriggerAvailableNow() {
        this.allDataForTriggerAvailableNow_$eq(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(this.getOrCreateInitialPartitionOffsets())));
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minOffsetPerTrigger$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$1(ReadLimit x$3) {
        return x$3 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$4) {
        return x$4 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$4(ReadLimit x$6) {
        return x$6 instanceof ReadMaxRows;
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((GenSet)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.minOffsetPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$minOffsetPerTrigger$1(x$2)));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = options.containsKey((Object)KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.lastTriggerMillis = 0L;
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

