/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glyph;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.TextUtils;
import com.autonavi.base.ae.gmap.glyph.Font;
import com.autonavi.base.ae.gmap.glyph.FontMetrics;
import com.autonavi.base.ae.gmap.glyph.FontMetricsRequestParam;
import com.autonavi.base.ae.gmap.glyph.FontStyle;
import com.autonavi.base.ae.gmap.glyph.GlyphMetrics;
import com.autonavi.base.ae.gmap.glyph.GlyphRaster;
import com.autonavi.base.ae.gmap.glyph.GlyphRequestParam;
import com.autonavi.base.amap.mapcore.tools.GLConvertUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GlyphLoader {
    private static GlyphMetrics loadGlyphMetrics(String string2, FontStyle fontStyle, float f2, String string3, boolean bl2, float f3) {
        GlyphMetrics glyphMetrics = new GlyphMetrics();
        if (fontStyle == null) {
            return glyphMetrics;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return glyphMetrics;
        }
        try {
            fontStyle = GlyphLoader.newTextPaint(fontStyle, f2, string3, bl2, f3);
            Rect rect = new Rect();
            fontStyle.getTextBounds(string2, 0, string2.length(), rect);
            if (rect.width() == 0 && rect.height() == 0) {
                float f4 = fontStyle.measureText(" ", 0, 1);
                float f5 = Math.abs(fontStyle.getFontMetrics().ascent) + Math.abs(fontStyle.getFontMetrics().descent);
                rect.top = 0;
                rect.left = 0;
                rect.right = (int)f4;
                rect.bottom = (int)f5;
            }
            if (bl2 && f3 > 0.0f) {
                float f6 = f3 / 2.0f;
                rect.top = (int)((float)rect.top - f6);
                rect.left = (int)((float)rect.left - f6);
                rect.right = (int)((float)rect.right + f6);
                rect.bottom = (int)((float)rect.bottom + f6);
            }
            glyphMetrics.bSuccess = true;
            glyphMetrics.fLeft = rect.left;
            glyphMetrics.fTop = Math.abs(fontStyle.getFontMetrics().ascent) - (float)Math.abs(rect.top);
            glyphMetrics.nWidth = rect.width();
            glyphMetrics.nHeight = rect.height();
            glyphMetrics.fAdvance = fontStyle.measureText(string2);
        }
        catch (Exception exception) {
            glyphMetrics.bSuccess = false;
        }
        return glyphMetrics;
    }

    private static GlyphRaster loadGlyphRaster(String object, FontStyle object2, float f2, String string2, boolean bl2, float f3) {
        GlyphRaster glyphRaster = new GlyphRaster();
        if (object2 == null) {
            return glyphRaster;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            return glyphRaster;
        }
        try {
            object2 = GlyphLoader.newTextPaint((FontStyle)object2, f2, string2, bl2, f3);
            Rect rect = new Rect();
            object2.getTextBounds((String)object, 0, ((String)object).length(), rect);
            if (rect.width() == 0 && rect.height() == 0) {
                float f4 = object2.measureText(" ", 0, 1);
                float f5 = Math.abs(object2.getFontMetrics().ascent) + Math.abs(object2.getFontMetrics().descent);
                rect.right = (int)f4;
                rect.bottom = (int)f5;
                rect.left = 0;
                rect.top = 0;
            }
            if (bl2 && f3 > 0.0f) {
                float f6 = f3 / 2.0f;
                rect.top = (int)((float)rect.top - f6);
                rect.left = (int)((float)rect.left - f6);
                rect.right = (int)((float)rect.right + f6);
                rect.bottom = (int)((float)rect.bottom + f6);
            }
            if (!rect.isEmpty()) {
                Bitmap bitmap = Bitmap.createBitmap((int)rect.width(), (int)rect.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
                Canvas canvas = new Canvas(bitmap);
                float f7 = 0 - rect.left;
                f3 = 0 - rect.top;
                canvas.drawText((String)object, f7, f3, (Paint)object2);
                byte[] byArray = new byte[rect.width() * rect.height()];
                object = byArray;
                object2 = ByteBuffer.wrap(byArray);
                glyphRaster.bitmapWidth = rect.width();
                glyphRaster.bitmapHeight = rect.height();
                glyphRaster.bitmapPixelMode = 0;
                glyphRaster.bitmapSize = ((Object)object).length;
                bitmap.copyPixelsToBuffer((Buffer)object2);
                bitmap.recycle();
                glyphRaster.bitmapBuffer = (byte[])object;
                glyphRaster.bSuccess = true;
            }
        }
        catch (Exception exception) {
            glyphRaster.bSuccess = false;
        }
        return glyphRaster;
    }

    private static GlyphRequestParam genGlyphRequestParam(byte[] byArray) {
        GlyphRequestParam glyphRequestParam = new GlyphRequestParam();
        int n2 = GLConvertUtil.getInt(byArray, 0);
        glyphRequestParam.strBuffer = new String(byArray, 4, n2);
        int n3 = 4 + n2;
        Font font = new Font();
        new Font().nFontStyleCode = GLConvertUtil.getInt(byArray, n3);
        font.nFontSize = GLConvertUtil.getInt(byArray, n3 += 4);
        n2 = GLConvertUtil.getInt(byArray, n3 += 4);
        font.strName = new String(byArray, n3 += 4, n2);
        FontMetrics fontMetrics = new FontMetrics();
        int n4 = GLConvertUtil.getInt(byArray, n3 += n2);
        fontMetrics.fAscent = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        fontMetrics.fDescent = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        fontMetrics.fLeading = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        fontMetrics.fHeight = (float)n4 * 0.001f;
        font.fontMetrics = fontMetrics;
        glyphRequestParam.font = font;
        glyphRequestParam.drawingMode = GLConvertUtil.getInt(byArray, n3 += 4);
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        glyphRequestParam.strokeWidth = (float)n4 * 0.001f;
        int n5 = GLConvertUtil.getInt(byArray, n3 += 4);
        glyphRequestParam.languageArr = new String(byArray, n3 += 4, n5);
        n5 = GLConvertUtil.getInt(byArray, n3);
        n3 += 4;
        if (1 == n5) {
            GlyphMetrics glyphMetrics = new GlyphMetrics();
            new GlyphMetrics().nWidth = GLConvertUtil.getInt(byArray, n3);
            glyphMetrics.nHeight = GLConvertUtil.getInt(byArray, n3 += 4);
            n4 = GLConvertUtil.getInt(byArray, n3 += 4);
            glyphMetrics.fLeft = (float)n4 * 0.001f;
            n4 = GLConvertUtil.getInt(byArray, n3 += 4);
            glyphMetrics.fTop = (float)n4 * 0.001f;
            n4 = GLConvertUtil.getInt(byArray, n3 += 4);
            glyphMetrics.fAdvance = (float)n4 * 0.001f;
            glyphRequestParam.fGlyphMetrics = glyphMetrics;
        }
        return glyphRequestParam;
    }

    private static FontMetricsRequestParam genFontMetricsParam(byte[] byArray) {
        FontMetricsRequestParam fontMetricsRequestParam = new FontMetricsRequestParam();
        int n2 = 0;
        int n3 = GLConvertUtil.getInt(byArray, 0);
        n2 += 4;
        fontMetricsRequestParam.fFontSize = (float)n3 * 0.001f;
        fontMetricsRequestParam.nFontStyleCode = GLConvertUtil.getInt(byArray, 4);
        n2 += 4;
        n3 = GLConvertUtil.getInt(byArray, 8);
        n2 += 4;
        if (1 == n3) {
            n3 = GLConvertUtil.getInt(byArray, 12);
            fontMetricsRequestParam.strName = new String(byArray, 16, n3);
            n2 = 16 + n3;
        }
        n3 = GLConvertUtil.getInt(byArray, n2);
        fontMetricsRequestParam.languageArr = new String(byArray, n2 += 4, n3);
        return fontMetricsRequestParam;
    }

    private static GlyphMetrics getGlyphMetrics(byte[] object) {
        object = GlyphLoader.genGlyphRequestParam(object);
        FontStyle fontStyle = new FontStyle(object.font.nFontStyleCode);
        boolean bl2 = false;
        if (object.drawingMode == 1) {
            bl2 = true;
        }
        return GlyphLoader.loadGlyphMetrics(object.strBuffer, fontStyle, object.font.nFontSize, object.languageArr, bl2, object.strokeWidth);
    }

    private static GlyphRaster getGlyphRaster(byte[] object) {
        object = GlyphLoader.genGlyphRequestParam(object);
        FontStyle fontStyle = new FontStyle(object.font.nFontStyleCode);
        boolean bl2 = false;
        if (object.drawingMode == 1) {
            bl2 = true;
        }
        return GlyphLoader.loadGlyphRaster(object.strBuffer, fontStyle, object.font.nFontSize, object.languageArr, bl2, object.strokeWidth);
    }

    private static FontMetrics getFontMetrics(byte[] object) {
        object = GlyphLoader.genFontMetricsParam(object);
        object = GlyphLoader.newTextPaint(new FontStyle(object.nFontStyleCode), object.fFontSize, object.languageArr, false, 0.0f).getFontMetrics();
        FontMetrics fontMetrics = new FontMetrics();
        new FontMetrics().bSuccess = true;
        fontMetrics.fAscent = Math.abs(object.ascent);
        fontMetrics.fDescent = Math.abs(object.descent);
        fontMetrics.fLeading = Math.abs(object.leading);
        fontMetrics.fHeight = Math.abs(object.ascent) + Math.abs(object.descent);
        return fontMetrics;
    }

    private static String decodeUnicode(short s2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)s2);
        return stringBuffer.toString();
    }

    private static String decodeUnicode(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static TextPaint newTextPaint(FontStyle fontStyle, float f2, String string2, boolean bl2, float f3) {
        void var3_11;
        boolean bl3;
        boolean bl4;
        TextPaint textPaint = new TextPaint();
        if (fontStyle == null) {
            return textPaint;
        }
        textPaint.setColor(-1);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTextSize(f2);
        textPaint.setTextAlign(Paint.Align.LEFT);
        if (bl2) {
            void var4_12;
            textPaint.setStyle(Paint.Style.STROKE);
            textPaint.setStrokeWidth((float)var4_12);
        } else {
            textPaint.setStyle(Paint.Style.FILL);
        }
        switch (fontStyle.getSlant()) {
            case 0: {
                bl4 = false;
                break;
            }
            case 1: 
            case 2: {
                bl4 = true;
                break;
            }
            default: {
                bl4 = false;
            }
        }
        switch (fontStyle.getWeight()) {
            case 400: {
                bl3 = false;
                break;
            }
            case 0: 
            case 100: 
            case 200: 
            case 300: {
                bl3 = false;
                break;
            }
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: 
            case 1000: {
                bl3 = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        boolean bl5 = false;
        if (bl3 && bl4) {
            int n2 = 3;
        } else if (bl3) {
            boolean bl6 = true;
        } else if (bl4) {
            int n3 = 2;
        }
        Typeface typeface = string2.isEmpty() ? Typeface.create((Typeface)Typeface.DEFAULT, (int)var3_11) : Typeface.create((String)string2, (int)var3_11);
        textPaint.setTypeface(typeface);
        return textPaint;
    }

    public static long createGlyphLoader() {
        return GlyphLoader.nativeCreateGlyphLoader();
    }

    public static void destroyGlyphLoader(long l2) {
        GlyphLoader.nativeDestroyGlyphLoader(l2);
    }

    private static native long nativeCreateGlyphLoader();

    private static native void nativeDestroyGlyphLoader(long var0);
}

