/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.gloverlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.amap.api.mapcore.util.er;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.CrossOverlay;
import com.autonavi.ae.gmap.gloverlay.AVectorCrossAttr;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import com.autonavi.amap.mapcore.interfaces.ICrossVectorOverlay;
import com.autonavi.base.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.base.ae.gmap.gloverlay.GLCrossVector;
import com.autonavi.base.ae.gmap.gloverlay.GLTextureProperty;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBindingInclude
public class CrossVectorOverlay
extends BaseMapOverlay<GLCrossVector, Object>
implements ICrossVectorOverlay {
    private boolean isImageMode = false;
    private CrossOverlay.GenerateCrossImageListener imageListener;
    private CrossOverlay.OnCrossVectorUpdateListener updateListener;
    AVectorCrossAttr attr = null;

    public CrossVectorOverlay(int n2, Context context, IAMap iAMap) {
        super(n2, context, iAMap);
    }

    @Override
    protected void iniGLOverlay() {
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                public void run() {
                    CrossVectorOverlay.this.mGLOverlay = new GLCrossVector(CrossVectorOverlay.this.mEngineID, CrossVectorOverlay.this.mMapView, this.hashCode());
                }
            });
        }
    }

    @Override
    public void addItem(Object object) {
    }

    @Override
    public void resumeMarker(final Bitmap bitmap) {
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                public void run() {
                    CrossVectorOverlay.this.addOverlayTexture(bitmap, 12345, 4);
                    ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setArrowResId(false, 12345);
                    ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setCarResId(12345);
                    BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromAsset("cross/crossing_nigth_bk.data");
                    Bitmap bitmap2 = null;
                    if (bitmapDescriptor != null) {
                        bitmap2 = bitmapDescriptor.getBitmap();
                    }
                    CrossVectorOverlay.this.addOverlayTexture(bitmap2, 54321, 0);
                    ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setBackgroundResId(54321);
                }
            });
        }
    }

    public void addOverlayTexture(Bitmap bitmap, int n2, int n3) {
        GLTextureProperty gLTextureProperty = new GLTextureProperty();
        new GLTextureProperty().mId = n2;
        gLTextureProperty.mAnchor = n3;
        gLTextureProperty.mBitmap = bitmap;
        gLTextureProperty.mXRatio = 0.0f;
        gLTextureProperty.mYRatio = 0.0f;
        gLTextureProperty.isGenMimps = true;
        this.mMapView.addOverlayTexture(this.mEngineID, gLTextureProperty);
    }

    public int dipToPixel(Context context, int n2) {
        if (context == null) {
            return n2;
        }
        try {
            return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        catch (Exception exception) {
            return n2;
        }
    }

    @Override
    public void setAttribute(AVectorCrossAttr aVectorCrossAttr) {
        this.attr = aVectorCrossAttr;
    }

    @Override
    public void setVisible(final boolean bl2) {
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                public void run() {
                    if (CrossVectorOverlay.this.mGLOverlay != null) {
                        ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).setVisible(bl2);
                    }
                }
            });
        }
    }

    @Override
    public int setData(final byte[] byArray) {
        if (Build.VERSION.SDK_INT < 21) {
            this.drawVectorFailed(-1);
            return -1;
        }
        if (this.attr == null) {
            this.attr = new AVectorCrossAttr();
            this.attr.stAreaRect = new Rect(0, 0, this.mMapView.getMapWidth(), this.mMapView.getMapHeight() * 4 / 11);
            this.attr.stAreaColor = Color.argb((int)217, (int)95, (int)95, (int)95);
            CrossVectorOverlay crossVectorOverlay = this;
            this.attr.fArrowBorderWidth = crossVectorOverlay.dipToPixel(crossVectorOverlay.mContext, 22);
            this.attr.stArrowBorderColor = Color.argb((int)0, (int)0, (int)50, (int)20);
            CrossVectorOverlay crossVectorOverlay2 = this;
            this.attr.fArrowLineWidth = crossVectorOverlay2.dipToPixel(crossVectorOverlay2.mContext, 18);
            this.attr.stArrowLineColor = Color.argb((int)255, (int)255, (int)253, (int)65);
            this.attr.dayMode = false;
        }
        if (byArray != null && this.attr != null && this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                public void run() {
                    CrossVectorOverlay.this.initImageMode(CrossVectorOverlay.this.isImageMode);
                    int n2 = ((GLCrossVector)CrossVectorOverlay.this.mGLOverlay).addVectorItem(CrossVectorOverlay.this.attr, byArray, byArray.length);
                    if (n2 != 0) {
                        CrossVectorOverlay.this.drawVectorFailed(n2);
                        return;
                    }
                    if (CrossVectorOverlay.this.updateListener != null) {
                        CrossOverlay.UpdateItem updateItem = new CrossOverlay.UpdateItem();
                        new CrossOverlay.UpdateItem().dataUpdateFlag = n2;
                        CrossVectorOverlay.this.updateListener.onUpdate(0, updateItem);
                    }
                }
            });
        }
        return -1;
    }

    private void drawVectorFailed(int n2) {
        if (this.isImageMode && this.imageListener != null) {
            this.imageListener.onGenerateComplete(null, n2);
        }
        if (this.updateListener != null) {
            CrossOverlay.UpdateItem updateItem = new CrossOverlay.UpdateItem();
            new CrossOverlay.UpdateItem().dataUpdateFlag = n2;
            this.updateListener.onUpdate(0, updateItem);
        }
    }

    private void initImageMode(boolean bl2) {
        if (this.mGLOverlay != null) {
            ((GLCrossVector)this.mGLOverlay).initTextureCallback(this, bl2);
        }
    }

    @Override
    public void remove() {
        this.imageListener = null;
        this.setVisible(false);
        if (this.mMapView != null) {
            this.mMapView.queueEvent(new Runnable(){

                public void run() {
                    CrossVectorOverlay.this.releaseInstance();
                }
            });
        }
    }

    @Override
    public void setImageMode(boolean bl2) {
        this.isImageMode = bl2;
    }

    @Override
    public void setGenerateCrossImageListener(CrossOverlay.GenerateCrossImageListener generateCrossImageListener) {
        this.imageListener = generateCrossImageListener;
    }

    @Override
    public void setOnCrossVectorUpdateListener(CrossOverlay.OnCrossVectorUpdateListener onCrossVectorUpdateListener) {
        this.updateListener = onCrossVectorUpdateListener;
    }

    @JBindingInclude
    public void imageContentResult(int[] object, int n2, int n3) {
        if (object == null) {
            this.drawVectorFailed(-1);
            return;
        }
        if (this.imageListener != null) {
            this.imageListener.onGenerateComplete((Bitmap)object, (object = (Object)er.a(object, n2, n3)) != null ? 0 : -1);
        }
    }
}

