/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import com.autonavi.amap.api.mapcore.IGLMapState;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import com.autonavi.base.amap.mapcore.FPoint;

public class GLMapState
implements IGLMapState {
    private long nativeStateInstance = 0L;
    private long nativeEngineInstance = 0L;
    private boolean isNewInstance = false;

    public GLMapState(int n2, long l2) {
        if (l2 != 0L) {
            this.nativeEngineInstance = l2;
            this.nativeStateInstance = GLMapState.nativeNewInstance(n2, l2);
            this.isNewInstance = true;
        }
    }

    public GLMapState(long l2, long l3) {
        if (l2 != 0L) {
            this.nativeEngineInstance = l2;
            this.nativeStateInstance = l3;
            this.isNewInstance = true;
        }
    }

    public static void lonlat2Geo(double d2, double d3, IPoint iPoint) {
        Point point = VirtualEarthProjection.latLongToPixels(d3, d2, 20);
        iPoint.x = point.x;
        iPoint.y = point.y;
    }

    public static void geo2LonLat(int n2, int n3, DPoint dPoint) {
        DPoint dPoint2 = VirtualEarthProjection.pixelsToLatLong(n2, n3, 20);
        dPoint.x = dPoint2.x;
        dPoint.y = dPoint2.y;
        dPoint2.recycle();
    }

    public void screenToP20Point(int n2, int n3, Point point) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeScreenToP20Point(this.nativeStateInstance, n2, n3, point);
        }
    }

    public void p20ToScreenPoint(int n2, int n3, FPoint fPoint) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeP20ToScreenPoint(this.nativeStateInstance, n2, n3, 0, fPoint);
        }
    }

    public void getMapGeoCenter(IPoint iPoint) {
        GLMapState.nativeGetMapCenter(this.nativeStateInstance, iPoint);
    }

    public DPoint getMapGeoCenter() {
        DPoint dPoint = new DPoint();
        new DPoint().x = GLMapState.nativeGetMapCenterXDouble(this.nativeStateInstance);
        dPoint.y = GLMapState.nativeGetMapCenterYDouble(this.nativeStateInstance);
        return dPoint;
    }

    public double getMapGeoCenterX() {
        return GLMapState.nativeGetMapCenterXDouble(this.nativeStateInstance);
    }

    public double getMapGeoCenterY() {
        return GLMapState.nativeGetMapCenterXDouble(this.nativeStateInstance);
    }

    public void setMapGeoCenter(double d2, double d3) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeSetMapCenter(this.nativeStateInstance, d2, d3);
        }
    }

    public void setCameraDegree(float f2) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeSetCameraDegree(this.nativeStateInstance, f2);
        }
    }

    public void setMapAngle(float f2) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeSetMapAngle(this.nativeStateInstance, f2);
        }
    }

    public void setMapZoomer(float f2) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeSetMapZoomer(this.nativeStateInstance, f2);
        }
    }

    public float getMapZoomer() {
        if (this.nativeStateInstance != 0L) {
            return GLMapState.nativeGetMapZoomer(this.nativeStateInstance);
        }
        return 0.0f;
    }

    public float getCameraDegree() {
        if (this.nativeStateInstance != 0L) {
            return GLMapState.nativeGetCameraDegree(this.nativeStateInstance);
        }
        return 0.0f;
    }

    public float getMapAngle() {
        if (this.nativeStateInstance != 0L) {
            return GLMapState.nativeGetMapAngle(this.nativeStateInstance);
        }
        return 0.0f;
    }

    public void recalculate() {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeRecalculate(this.nativeStateInstance);
        }
    }

    public void recycle() {
        if (this.nativeStateInstance != 0L && this.isNewInstance) {
            GLMapState.nativeStateDestroy(this.nativeStateInstance);
        }
        this.nativeStateInstance = 0L;
    }

    public void reset() {
        if (this.nativeStateInstance != 0L) {
            this.recycle();
        }
        if (this.nativeEngineInstance != 0L) {
            this.nativeStateInstance = GLMapState.nativeNewInstance(1, this.nativeEngineInstance);
        }
    }

    public float getMapLenWithWin(int n2) {
        return this.getGLUnitWithWin(n2);
    }

    public float getGLUnitWithWin(int n2) {
        if (this.nativeStateInstance != 0L) {
            return GLMapState.nativeGetGLUnitWithWin(this.nativeStateInstance, n2);
        }
        return 0.0f;
    }

    public void getPixel20Bound(Rect rect, int n2, int n3) {
        if (this.nativeStateInstance != 0L) {
            GLMapState.nativeGetPixel20Bound(this.nativeStateInstance, rect, n2, n3);
        }
    }

    public long getNativeInstance() {
        return this.nativeStateInstance;
    }

    public void getViewMatrix(float[] fArray) {
        if (fArray != null && fArray.length == 16) {
            GLMapState.nativeGetViewMatrix(this.nativeStateInstance, fArray);
        }
    }

    public void getProjectionMatrix(float[] fArray) {
        if (fArray != null && fArray.length == 16) {
            GLMapState.nativeGetProjectionMatrix(this.nativeStateInstance, fArray);
        }
    }

    public float getSkyHeight() {
        if (this.nativeStateInstance != 0L) {
            return GLMapState.nativeGetSkyHeight(this.nativeStateInstance);
        }
        return 0.0f;
    }

    public float calculateMapZoomer(int n2, int n3, int n4, int n5, int n6) {
        if (this.nativeStateInstance != 0L) {
            return GLMapState.nativeCalculateMapZoomer(this.nativeStateInstance, n2, n3, n4, n5, n6);
        }
        return 3.0f;
    }

    public void setNativeMapengineState(int n2, long l2) {
        if (l2 == 0L || this.nativeStateInstance == 0L) {
            return;
        }
        this.nativeEngineInstance = l2;
        GLMapState.nativeSetMapState(n2, l2, this.nativeStateInstance);
    }

    public static float calMapZoomScalefactor(int n2, int n3, int n4) {
        return GLMapState.nativeCalMapZoomScalefactor(n2, n3, n4);
    }

    public static native long nativeNewInstance(int var0, long var1);

    private static native void nativeSetMapState(int var0, long var1, long var3);

    public static native void nativeScreenToP20Point(long var0, float var2, float var3, Point var4);

    public static native void nativeP20ToScreenPoint(long var0, int var2, int var3, int var4, PointF var5);

    public static native void nativeSetMapCenter(long var0, double var2, double var4);

    public static native void nativeGetMapCenter(long var0, Point var2);

    public static native double nativeGetMapCenterXDouble(long var0);

    public static native double nativeGetMapCenterYDouble(long var0);

    public static native float nativeGetMapZoomer(long var0);

    public static native void nativeSetMapZoomer(long var0, float var2);

    public static native void nativeSetMapAngle(long var0, float var2);

    public static native float nativeGetCameraDegree(long var0);

    public static native float nativeGetMapAngle(long var0);

    public static native void nativeSetCameraDegree(long var0, float var2);

    public static native void nativeRecalculate(long var0);

    public static native void nativeStateDestroy(long var0);

    public static native void nativeGetViewMatrix(long var0, float[] var2);

    public static native void nativeGetProjectionMatrix(long var0, float[] var2);

    public static native float nativeGetSkyHeight(long var0);

    public static native float nativeGetGLUnitWithWin(long var0, int var2);

    public static native void nativeGetPixel20Bound(long var0, Rect var2, int var3, int var4);

    public static native float nativeCalMapZoomScalefactor(int var0, int var1, float var2);

    public static native float nativeCalculateMapZoomer(long var0, int var2, int var3, int var4, int var5, int var6);

    public String toString() {
        return "instance: " + this.nativeStateInstance + " center: " + this.getMapGeoCenter().x + " , " + this.getMapGeoCenter().y + " bearing:" + this.getCameraDegree() + "  tilt:" + this.getMapAngle() + "  zoom:" + this.getMapZoomer() + "  ";
    }
}

