/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.amap.api.mapcore.util.eq;
import com.amap.api.mapcore.util.er;
import com.amap.api.mapcore.util.hn;
import com.amap.api.maps.AMap;
import com.amap.api.maps.MapsInitializer;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.autonavi.amap.api.mapcore.IGLMapEngine;
import com.autonavi.amap.api.mapcore.IGLMapState;
import com.autonavi.amap.mapcore.AbstractCameraUpdateMessage;
import com.autonavi.amap.mapcore.tools.GlMapUtil;
import com.autonavi.base.ae.gmap.GLMapState;
import com.autonavi.base.ae.gmap.gesture.EAMapPlatformGestureInfo;
import com.autonavi.base.ae.gmap.glanimation.AdglMapAnimFling;
import com.autonavi.base.ae.gmap.glanimation.AdglMapAnimGroup;
import com.autonavi.base.ae.gmap.glanimation.AdglMapAnimationMgr;
import com.autonavi.base.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.base.ae.gmap.gloverlay.GLOverlayBundle;
import com.autonavi.base.ae.gmap.gloverlay.GLTextureProperty;
import com.autonavi.base.ae.gmap.style.StyleItem;
import com.autonavi.base.amap.api.mapcore.IAMapDelegate;
import com.autonavi.base.amap.mapcore.FileUtil;
import com.autonavi.base.amap.mapcore.IAMapEngineCallback;
import com.autonavi.base.amap.mapcore.interfaces.IAMapListener;
import com.autonavi.base.amap.mapcore.jbinding.JBindingInclude;
import com.autonavi.base.amap.mapcore.maploader.AMapLoader;
import com.autonavi.base.amap.mapcore.maploader.NetworkState;
import com.autonavi.base.amap.mapcore.message.AbstractGestureMapMessage;
import com.autonavi.base.amap.mapcore.message.HoverGestureMapMessage;
import com.autonavi.base.amap.mapcore.message.MoveGestureMapMessage;
import com.autonavi.base.amap.mapcore.message.RotateGestureMapMessage;
import com.autonavi.base.amap.mapcore.message.ScaleGestureMapMessage;
import com.autonavi.base.amap.mapcore.tools.GLConvertUtil;
import com.autonavi.base.amap.mapcore.tools.TextTextureGenerator;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBindingInclude
public class GLMapEngine
implements IGLMapEngine,
IAMapEngineCallback,
NetworkState.NetworkChangeListener {
    private Context context;
    private long mNativeMapengineInstance = 0L;
    private TextTextureGenerator mTextTextureGenerator;
    private String userAgent;
    private IAMapListener mMapListener;
    private IAMapDelegate mGlMapView = null;
    private final List<AbstractCameraUpdateMessage> mStateMessageList = new Vector<AbstractCameraUpdateMessage>();
    private final List<AbstractGestureMapMessage> mGestureMessageList = new Vector<AbstractGestureMapMessage>();
    private List<AbstractGestureMapMessage> mGestureEndMessageList = new Vector<AbstractGestureMapMessage>();
    private final List<AbstractCameraUpdateMessage> mAnimateStateMessageList = new Vector<AbstractCameraUpdateMessage>();
    boolean isMoveCameraStep = false;
    boolean isGestureStep = false;
    private int mapGestureCount = 0;
    private AdglMapAnimationMgr mapAnimationMgr = null;
    private GLMapState copyGLMapState = null;
    private Lock mLock = new ReentrantLock();
    private Object mutLock = new Object();
    private NetworkState mNetworkState = null;
    GLOverlayBundle<BaseMapOverlay<?, ?>> bundle = null;
    private boolean isEngineRenderComplete = false;
    Hashtable<Long, AMapLoader> aMapLoaderHashtable = new Hashtable();
    boolean mRequestDestroy = false;
    boolean isNetworkConnected = false;
    private AtomicInteger mRequestID = new AtomicInteger(1);
    GLMapState state;

    @Override
    @JBindingInclude
    public byte[] requireMapResource(int n2, String string2) {
        if (string2 == null) {
            return null;
        }
        byte[] byArray = null;
        String string3 = "map_assets/".concat(String.valueOf(string2));
        try {
            String string4 = "icons_5";
            String string5 = "bktile";
            if (this.mGlMapView.getMapConfig().isCustomStyleEnable()) {
                if (this.mGlMapView.getCustomStyleManager() != null && (byArray = this.mGlMapView.getCustomStyleManager().a(string2)) != null) {
                    return byArray;
                }
                if (string2.startsWith(string4)) {
                    byArray = FileUtil.readFileContents(this.mGlMapView.getMapConfig().getCustomTextureResourcePath());
                } else if (string2.startsWith(string5)) {
                    byArray = FileUtil.readFileContentsFromAssets(this.context, string3);
                    int n3 = this.mGlMapView.getMapConfig().getCustomBackgroundColor();
                    if (n3 != 0) {
                        byArray = er.a(byArray, n3);
                    }
                }
                if (byArray != null) {
                    return byArray;
                }
            }
            return FileUtil.readFileContentsFromAssets(this.context, string3);
        }
        catch (Throwable throwable) {
            er.a(throwable);
            return null;
        }
    }

    @Override
    public void reloadMapResource(int n2, String string2, int n3) {
    }

    @Override
    @JBindingInclude
    public int generateRequestId() {
        return this.mRequestID.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JBindingInclude
    public int requireMapDataAsyn(int n2, byte[] object) {
        if (this.mRequestDestroy) {
            return 0;
        }
        if (object != null) {
            Object object2 = new AMapLoader.ADataRequestParam();
            int n3 = GLConvertUtil.getInt(object, 0);
            ((AMapLoader.ADataRequestParam)object2).requestBaseUrl = GLConvertUtil.getString(object, 4, n3);
            int n4 = 4 + n3;
            n3 = GLConvertUtil.getInt(object, n4);
            ((AMapLoader.ADataRequestParam)object2).requestUrl = GLConvertUtil.getString(object, n4 += 4, n3);
            ((AMapLoader.ADataRequestParam)object2).handler = GLConvertUtil.getLong(object, n4 += n3);
            ((AMapLoader.ADataRequestParam)object2).nRequestType = GLConvertUtil.getInt(object, n4 += 8);
            n3 = GLConvertUtil.getInt(object, n4 += 4);
            ((AMapLoader.ADataRequestParam)object2).enCodeString = GLConvertUtil.getSubBytes(object, n4 += 4, n3);
            ((AMapLoader.ADataRequestParam)object2).nCompress = GLConvertUtil.getInt(object, n4 += n3);
            object = object2;
            final AMapLoader aMapLoader = new AMapLoader(n2, this, (AMapLoader.ADataRequestParam)object);
            object2 = this;
            synchronized (object2) {
                this.aMapLoaderHashtable.put(object.handler, aMapLoader);
            }
            try {
                eq.a().a(new Runnable(){

                    public void run() {
                        try {
                            if (GLMapEngine.this.mRequestDestroy) {
                                return;
                            }
                            if (aMapLoader == null) {
                                return;
                            }
                            aMapLoader.doRequest();
                            return;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            hn.c(throwable, "download Thread", "AMapLoader doRequest");
                            er.a(throwable2);
                            return;
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                object2 = throwable;
                hn.c(throwable, "download Thread", "requireMapData");
                er.a((Throwable)object2);
            }
        }
        return 0;
    }

    @Override
    @JBindingInclude
    public void requireMapData(int n2, byte[] byArray) {
    }

    @Override
    @JBindingInclude
    public void cancelRequireMapData(Object object) {
        if (object != null && object instanceof AMapLoader) {
            ((AMapLoader)object).doCancel();
        }
    }

    @Override
    @JBindingInclude
    public byte[] requireCharBitmap(int n2, int n3, int n4) {
        return this.mTextTextureGenerator.getTextPixelBuffer(n3, n4);
    }

    @Override
    @JBindingInclude
    public byte[] requireCharsWidths(int n2, int[] nArray, int n3, int n4) {
        return this.mTextTextureGenerator.getCharsWidths(nArray);
    }

    @Override
    public void requireMapRender(int n2, int n3, int n4) {
    }

    @Override
    @JBindingInclude
    public void onMapRender(int n2, int n3) {
        try {
            switch (n3) {
                case 5: {
                    if (this.mMapListener == null) break;
                    this.mMapListener.beforeDrawLabel(n2, this.getMapState(n2));
                    return;
                }
                case 6: {
                    if (this.mMapListener == null) break;
                    this.mMapListener.afterDrawLabel(n2, this.getMapState(n2));
                    return;
                }
                case 7: {
                    if (this.mMapListener == null) break;
                    this.mMapListener.afterRendererOver(n2, this.getMapState(n2));
                    return;
                }
                case 13: {
                    this.isEngineRenderComplete = true;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Override
    @JBindingInclude
    public void OnIndoorBuildingActivity(int n2, byte[] byArray) {
        if (this.mGlMapView != null) {
            try {
                this.mGlMapView.onIndoorBuildingActivity(n2, byArray);
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public synchronized void receiveNetData(int n2, long l2, byte[] byArray, int n3) {
        if (this.mRequestDestroy) {
            return;
        }
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeReceiveNetData(n2, this.mNativeMapengineInstance, byArray, l2, n3);
        }
    }

    public boolean getMapDataTaskIsCancel(int n2, long l2) {
        return !this.aMapLoaderHashtable.containsKey(l2);
    }

    public synchronized void finishDownLoad(int n2, long l2) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeFinishDownLoad(n2, this.mNativeMapengineInstance, l2);
        }
        this.aMapLoaderHashtable.remove(l2);
    }

    public synchronized void netStop(int n2, long l2, int n3) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeCancelDownLoad(n2, this.mNativeMapengineInstance, l2);
        }
        this.aMapLoaderHashtable.remove(l2);
    }

    public synchronized void netError(int n2, long l2, int n3, int n4) {
        if (!this.aMapLoaderHashtable.containsKey(l2)) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeFailedDownLoad(n2, this.mNativeMapengineInstance, l2, n4);
        }
        this.aMapLoaderHashtable.remove(l2);
        try {
            if (MapsInitializer.getExceptionLogger() != null) {
                MapsInitializer.getExceptionLogger().onDownloaderException(n3, n4);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setMapLoaderToTask(int n2, long l2, AMapLoader aMapLoader) {
    }

    public Context getContext() {
        return this.context;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setParamater(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mLock.lock();
        try {
            if (this.mNativeMapengineInstance != 0L) {
                GLMapEngine.nativeSetParameter(n2, this.mNativeMapengineInstance, n3, n4, n5, n6, n7);
            }
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void onClearCache(int n2) {
    }

    public boolean isInMapAction(int n2) {
        return false;
    }

    public long getNativeInstance() {
        return this.mNativeMapengineInstance;
    }

    public boolean canStopMapRender(int n2) {
        return this.isEngineRenderComplete;
    }

    public int getEngineIDWithType(int n2) {
        return 1;
    }

    public boolean isEngineCreated(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            return GLMapEngine.nativeIsEngineCreated(this.mNativeMapengineInstance, n2);
        }
        return false;
    }

    public long getMapStateInstance(int n2) {
        return 0L;
    }

    public int getEngineIDWithGestureInfo(EAMapPlatformGestureInfo eAMapPlatformGestureInfo) {
        return 1;
    }

    public void setServiceViewRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GLMapEngine.nativeSetServiceViewRect(n2, this.mNativeMapengineInstance, n3, n4, n5, n6, n7, n8);
    }

    public void setSrvViewStateBoolValue(int n2, int n3, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetSrvViewStateBoolValue(n2, this.mNativeMapengineInstance, n3, bl2);
        }
    }

    public boolean getSrvViewStateBoolValue(int n2, int n3) {
        if (this.mNativeMapengineInstance != 0L) {
            return GLMapEngine.nativeGetSrvViewStateBoolValue(n2, this.mNativeMapengineInstance, n3);
        }
        return false;
    }

    public boolean getIsProcessBuildingMark(int n2) {
        return false;
    }

    public void setIndoorBuildingToBeActive(int n2, String string2, int n3, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetIndoorBuildingToBeActive(n2, this.mNativeMapengineInstance, string2, n3, string3);
        }
    }

    public void setMapListener(IAMapListener iAMapListener) {
        this.mMapListener = iAMapListener;
    }

    public void setInternaltexture(int n2, byte[] byArray, int n3) {
    }

    public GLMapState getMapState(int n2) {
        this.mLock.lock();
        try {
            long l2;
            if (this.mNativeMapengineInstance != 0L && this.state == null && (l2 = GLMapEngine.nativeGetCurrentMapState(n2, this.mNativeMapengineInstance)) != 0L) {
                this.state = new GLMapState(this.mNativeMapengineInstance, l2);
            }
        }
        finally {
            this.mLock.unlock();
        }
        return this.state;
    }

    @Override
    public IGLMapState getNewMapState(int n2) {
        this.mLock.lock();
        try {
            if (this.mNativeMapengineInstance != 0L) {
                GLMapState gLMapState = new GLMapState(n2, this.mNativeMapengineInstance);
                return gLMapState;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return null;
    }

    public GLMapState getCloneMapState() {
        this.mLock.lock();
        try {
            if (this.mNativeMapengineInstance != 0L) {
                if (this.copyGLMapState == null) {
                    this.copyGLMapState = new GLMapState(1, this.mNativeMapengineInstance);
                }
                this.copyGLMapState.setMapZoomer(this.mGlMapView.getMapConfig().getSZ());
                this.copyGLMapState.setCameraDegree(this.mGlMapView.getMapConfig().getSC());
                this.copyGLMapState.setMapAngle(this.mGlMapView.getMapConfig().getSR());
                this.copyGLMapState.setMapGeoCenter(this.mGlMapView.getMapConfig().getSX(), this.mGlMapView.getMapConfig().getSY());
            }
        }
        finally {
            this.mLock.unlock();
        }
        return this.copyGLMapState;
    }

    public void setMapState(int n2, GLMapState gLMapState) {
        this.setMapState(n2, gLMapState, true);
    }

    public void setMapState(int n2, GLMapState gLMapState, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            if (bl2 && this.mGlMapView != null && this.mGlMapView.getMapConfig() != null) {
                this.mGlMapView.checkMapState(gLMapState);
            }
            this.mLock.lock();
            try {
                gLMapState.setNativeMapengineState(n2, this.mNativeMapengineInstance);
                return;
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAnimation() {
        if (this.mStateMessageList.size() > 0) {
            return;
        }
        AbstractCameraUpdateMessage abstractCameraUpdateMessage = null;
        List<AbstractCameraUpdateMessage> list = this.mAnimateStateMessageList;
        synchronized (list) {
            if (this.mAnimateStateMessageList.size() > 0) {
                abstractCameraUpdateMessage = this.mAnimateStateMessageList.remove(0);
            }
        }
        if (abstractCameraUpdateMessage != null) {
            abstractCameraUpdateMessage.generateMapAnimation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGestureMessage(int n2, AbstractGestureMapMessage abstractGestureMapMessage, boolean bl2, int n3, int n4) {
        if (abstractGestureMapMessage == null) {
            return;
        }
        abstractGestureMapMessage.isGestureScaleByMapCenter = bl2;
        List<AbstractGestureMapMessage> list = this.mGestureMessageList;
        synchronized (list) {
            this.mGestureMessageList.add(abstractGestureMapMessage);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMessage() {
        try {
            GLMapState gLMapState = (GLMapState)this.getNewMapState(1);
            boolean bl2 = this.processGestureMessage(gLMapState);
            if (this.mGestureMessageList.size() <= 0) {
                bl2 = bl2 || this.processStateMapMessage(gLMapState);
            } else {
                List<AbstractCameraUpdateMessage> list = this.mStateMessageList;
                synchronized (list) {
                    if (this.mStateMessageList.size() > 0) {
                        this.mStateMessageList.clear();
                    }
                }
            }
            if (bl2 = bl2 || this.processAnimations(gLMapState)) {
                float f2 = gLMapState.getCameraDegree();
                f2 = er.a(this.mGlMapView.getMapConfig(), f2, gLMapState.getMapZoomer());
                gLMapState.setCameraDegree(f2);
                this.setMapState(1, gLMapState);
            }
            gLMapState.recycle();
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processGestureMessage(GLMapState gLMapState) {
        if (this.mGestureMessageList.size() <= 0) {
            if (this.isGestureStep) {
                this.isGestureStep = false;
            }
            return false;
        }
        this.isGestureStep = true;
        if (gLMapState == null) {
            return false;
        }
        while (true) {
            int n2;
            AbstractGestureMapMessage abstractGestureMapMessage = null;
            List<AbstractGestureMapMessage> list = this.mGestureMessageList;
            synchronized (list) {
                if (this.mGestureMessageList.size() > 0) {
                    abstractGestureMapMessage = this.mGestureMessageList.remove(0);
                }
                if (abstractGestureMapMessage == null) {
                    break;
                }
            }
            if (abstractGestureMapMessage.width == 0) {
                abstractGestureMapMessage.width = this.mGlMapView.getMapWidth();
            }
            if (abstractGestureMapMessage.height == 0) {
                abstractGestureMapMessage.height = this.mGlMapView.getMapHeight();
            }
            if ((n2 = abstractGestureMapMessage.getMapGestureState()) == 100) {
                this.gestureBegin();
            } else if (n2 == 101) {
                abstractGestureMapMessage.runCameraUpdate(gLMapState);
            } else if (n2 == 102) {
                this.gestureEnd();
            }
            this.mGestureEndMessageList.add(abstractGestureMapMessage);
        }
        if (this.mGestureEndMessageList.size() > 0) {
            this.recycleMessage();
        }
        return true;
    }

    private boolean processAnimations(GLMapState gLMapState) {
        try {
            if (this.mapAnimationMgr.getAnimationsCount() > 0) {
                gLMapState.recalculate();
                this.mapAnimationMgr.doAnimations(gLMapState);
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public void interruptAnimation() {
        if (this.isInMapAnimation(1)) {
            try {
                GLMapEngine gLMapEngine = this;
                gLMapEngine.doMapAnimationCancelCallback(gLMapEngine.mapAnimationMgr.getCancelCallback());
                this.clearAnimations(1, false);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                hn.c(throwable, this.getClass().getName(), "CancelableCallback.onCancel");
                throwable2.printStackTrace();
            }
        }
    }

    @Override
    public void addGroupAnimation(int n2, int n3, float f2, int n4, int n5, int n6, int n7, AMap.CancelableCallback cancelableCallback) {
        AdglMapAnimGroup adglMapAnimGroup = new AdglMapAnimGroup(n3);
        adglMapAnimGroup.setToCameraDegree(n5, 0);
        adglMapAnimGroup.setToMapAngle(n4, 0);
        adglMapAnimGroup.setToMapLevel(f2, 0);
        adglMapAnimGroup.setToMapCenterGeo(n6, n7, 0);
        if (this.mapAnimationMgr != null && adglMapAnimGroup.isValid()) {
            this.mapAnimationMgr.addAnimation(adglMapAnimGroup, cancelableCallback);
        }
    }

    private void doMapAnimationCancelCallback(final AMap.CancelableCallback cancelableCallback) {
        if (cancelableCallback == null) {
            return;
        }
        if (this.mGlMapView != null) {
            this.mGlMapView.getMainHandler().post(new Runnable(){

                public void run() {
                    try {
                        cancelableCallback.onCancel();
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
        }
    }

    private void doMapAnimationFinishCallback(final AMap.CancelableCallback cancelableCallback) {
        if (this.mMapListener != null) {
            this.mMapListener.afterAnimation();
        }
        if (cancelableCallback == null) {
            return;
        }
        if (this.mGlMapView != null) {
            this.mGlMapView.getMainHandler().post(new Runnable(){

                public void run() {
                    try {
                        cancelableCallback.onFinish();
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            });
        }
    }

    public boolean isInMapAnimation(int n2) {
        return this.getAnimateionsCount() > 0;
    }

    public int getAnimateionsCount() {
        if (this.mNativeMapengineInstance != 0L) {
            return this.mapAnimationMgr.getAnimationsCount();
        }
        return 0;
    }

    public void clearAllMessages(int n2) {
    }

    public void clearAnimations(int n2, boolean bl2) {
        this.mapAnimationMgr.clearAnimations();
    }

    public void clearAnimations(int n2, boolean bl2, int n3) {
        this.mapAnimationMgr.clearAnimations();
    }

    public void startMapSlidAnim(int n2, Point point, float f2, float f3) {
        if (point == null) {
            return;
        }
        try {
            this.clearAnimations(n2, true);
            GLMapState gLMapState = this.getCloneMapState();
            gLMapState.reset();
            gLMapState.recalculate();
            float f4 = f2;
            float f5 = f3;
            f2 = Math.abs(f4);
            float f6 = Math.abs(f3);
            float f7 = f2 > f6 ? f2 : f6;
            if (f7 > 12000.0f) {
                float f8;
                if (f2 > f6) {
                    f4 = f4 > 0.0f ? 12000.0f : -12000.0f;
                    f8 = 12000.0f / f2 * f3;
                } else {
                    f4 = 12000.0f / f6 * f4;
                    f8 = f3 > 0.0f ? 12000.0f : -12000.0f;
                }
                f5 = f8;
            }
            int n3 = this.mGlMapView.getMapWidth() >> 1;
            int n4 = this.mGlMapView.getMapHeight() >> 1;
            if (this.mGlMapView.isUseAnchor()) {
                n3 = this.mGlMapView.getMapConfig().getAnchorX();
                n4 = this.mGlMapView.getMapConfig().getAnchorY();
            }
            AdglMapAnimFling adglMapAnimFling = new AdglMapAnimFling(500, n3, n4);
            adglMapAnimFling.setPositionAndVelocity(f4, f5);
            adglMapAnimFling.commitAnimation(gLMapState);
            this.mapAnimationMgr.addAnimation(adglMapAnimFling, null);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void startPivotZoomRotateAnim(int n2, Point point, float f2, int n3, int n4) {
        if (f2 == -9999.0f && n3 == -9999) {
            return;
        }
    }

    private void gestureBegin() {
        ++this.mapGestureCount;
    }

    private void gestureEnd() {
        --this.mapGestureCount;
        if (this.mapGestureCount == 0) {
            this.recycleMessage();
        }
    }

    public int getStateMessageCount() {
        return this.mStateMessageList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(AbstractCameraUpdateMessage abstractCameraUpdateMessage, boolean bl2) {
        if (bl2) {
            List<AbstractCameraUpdateMessage> list = this.mAnimateStateMessageList;
            synchronized (list) {
                this.mAnimateStateMessageList.clear();
                this.mAnimateStateMessageList.add(abstractCameraUpdateMessage);
                return;
            }
        }
        List<AbstractCameraUpdateMessage> list = this.mStateMessageList;
        synchronized (list) {
            this.mStateMessageList.add(abstractCameraUpdateMessage);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCameraUpdateMessage getStateMessage() {
        List<AbstractCameraUpdateMessage> list = this.mStateMessageList;
        synchronized (list) {
            if (this.mStateMessageList.size() == 0) {
                return null;
            }
            return this.mStateMessageList.remove(0);
        }
    }

    private void recycleMessage() {
        AbstractGestureMapMessage abstractGestureMapMessage;
        while (this.mGestureEndMessageList.size() > 0 && (abstractGestureMapMessage = this.mGestureEndMessageList.remove(0)) != null) {
            if (abstractGestureMapMessage instanceof MoveGestureMapMessage) {
                ((MoveGestureMapMessage)abstractGestureMapMessage).recycle();
                continue;
            }
            if (abstractGestureMapMessage instanceof HoverGestureMapMessage) {
                ((HoverGestureMapMessage)abstractGestureMapMessage).recycle();
                continue;
            }
            if (abstractGestureMapMessage instanceof RotateGestureMapMessage) {
                ((RotateGestureMapMessage)abstractGestureMapMessage).recycle();
                continue;
            }
            if (!(abstractGestureMapMessage instanceof ScaleGestureMapMessage)) continue;
            ((ScaleGestureMapMessage)abstractGestureMapMessage).recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processStateMapMessage(GLMapState gLMapState) {
        if (this.mStateMessageList.size() <= 0) {
            if (this.isMoveCameraStep) {
                this.isMoveCameraStep = false;
            }
            return false;
        }
        this.isMoveCameraStep = true;
        if (gLMapState == null) {
            return false;
        }
        while (true) {
            AbstractCameraUpdateMessage abstractCameraUpdateMessage = null;
            List<AbstractCameraUpdateMessage> list = this.mStateMessageList;
            synchronized (list) {
                if (this.mStateMessageList.size() > 0) {
                    abstractCameraUpdateMessage = this.mStateMessageList.remove(0);
                }
                if (abstractCameraUpdateMessage == null) {
                    break;
                }
            }
            if (abstractCameraUpdateMessage.width == 0) {
                abstractCameraUpdateMessage.width = this.mGlMapView.getMapWidth();
            }
            if (abstractCameraUpdateMessage.height == 0) {
                abstractCameraUpdateMessage.height = this.mGlMapView.getMapHeight();
            }
            gLMapState.recalculate();
            abstractCameraUpdateMessage.runCameraUpdate(gLMapState);
        }
        return true;
    }

    public void initMapOpenLayer(String string2) {
        if (this.mNativeMapengineInstance != 0L && string2 != null) {
            GLMapEngine.nativeInitOpenLayer(1, this.mNativeMapengineInstance, string2.getBytes());
        }
    }

    public void setMapOpenLayerEnable(boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetOpenLayerEnable(1, this.mNativeMapengineInstance, bl2);
        }
    }

    public void pushRendererState() {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativePushRendererState(1, this.mNativeMapengineInstance);
        }
    }

    public void popRendererState() {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativePopRenderState(1, this.mNativeMapengineInstance);
        }
    }

    public int[] getMapModeState(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeGetMapModeState(n2, this.mNativeMapengineInstance, bl2);
        }
        return null;
    }

    public boolean setNativeMapModeAndStyle(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, StyleItem[] styleItemArray) {
        if (this.mNativeMapengineInstance == 0L) {
            return false;
        }
        int[] nArray = new int[]{n3, n4, n5, 0, 0};
        return GLMapEngine.nativeSetMapModeAndStyle(n2, this.mNativeMapengineInstance, nArray, bl2, bl3, styleItemArray);
    }

    public boolean setMapModeAndStyle(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, StyleItem[] styleItemArray) {
        if (this.mNativeMapengineInstance == 0L) {
            return false;
        }
        bl2 = this.setNativeMapModeAndStyle(n2, n3, n4, n5, bl2, bl3, styleItemArray);
        if (styleItemArray != null && bl3) {
            n3 = this.mGlMapView.getMapConfig().getCustomBackgroundColor();
            if (n3 != 0) {
                byte[] byArray = er.a(FileUtil.readFileContentsFromAssets(this.context, "map_assets" + File.separator + "bktile.data"), n3);
                this.setBackgroundTexture(n2, byArray);
            }
            String string2 = this.mGlMapView.getMapConfig().getCustomTextureResourcePath();
            if (this.mGlMapView.getMapConfig().isProFunctionAuthEnable() && !TextUtils.isEmpty((CharSequence)string2)) {
                this.mGlMapView.getMapConfig().setUseProFunction(true);
                byte[] byArray = FileUtil.readFileContents(string2);
                this.setCustomStyleTexture(n2, byArray);
            }
        } else if (n3 == 0 && n4 == 0 && n5 == 0) {
            byte[] byArray = FileUtil.readFileContentsFromAssets(this.context, "map_assets" + File.separator + "bktile.data");
            this.setBackgroundTexture(n2, byArray);
            byArray = FileUtil.readFileContentsFromAssets(this.context, "map_assets" + File.separator + "icons_5_17_1597739000.data");
            this.setCustomStyleTexture(n2, byArray);
        }
        return bl2;
    }

    public void putResourceData(int n2, byte[] byArray) {
    }

    @Override
    public void networkStateChanged(Context context) {
        if (this.mRequestDestroy) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L && this.mGlMapView != null) {
            this.isNetworkConnected = NetworkState.isNetworkConnected(context);
            this.mGlMapView.queueEvent(new Runnable(){

                public void run() {
                    GLMapEngine.nativeSetNetStatus(GLMapEngine.this.mNativeMapengineInstance, GLMapEngine.this.isNetworkConnected ? 1 : 0);
                }
            });
        }
    }

    public byte[] getLabelBuffer(int n2, int n3, int n4, int n5) {
        byte[] byArray;
        this.mLock.lock();
        try {
            byArray = new byte[3072];
            if (this.mNativeMapengineInstance != 0L) {
                GLMapEngine.nativeSelectMapPois(n2, this.mNativeMapengineInstance, n3, n4, n5, byArray);
            }
        }
        finally {
            this.mLock.unlock();
        }
        return byArray;
    }

    public long createOverlay(int n2, int n3) {
        if (this.mNativeMapengineInstance != 0L) {
            return GLMapEngine.nativeCreateOverlay(n2, this.mNativeMapengineInstance, n3);
        }
        return 0L;
    }

    public String addNativeOverlay(int n2, int n3, int n4) {
        if (this.mNativeMapengineInstance != 0L) {
            String string2 = GLMapEngine.nativeAddNativeOverlay(n2, this.mNativeMapengineInstance, n3, n4);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            return string2;
        }
        return null;
    }

    public long getGlOverlayMgrPtr(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            return GLMapEngine.nativeGetGlOverlayMgrPtr(n2, this.mNativeMapengineInstance);
        }
        return 0L;
    }

    public void setOvelayBundle(int n2, GLOverlayBundle<BaseMapOverlay<?, ?>> gLOverlayBundle) {
        this.bundle = gLOverlayBundle;
    }

    public void addOverlayTexture(int n2, GLTextureProperty gLTextureProperty) {
        if (this.mNativeMapengineInstance != 0L && gLTextureProperty != null && gLTextureProperty.mBitmap != null && !gLTextureProperty.mBitmap.isRecycled()) {
            GLMapEngine.nativeAddOverlayTexture(n2, this.mNativeMapengineInstance, gLTextureProperty.mId, gLTextureProperty.mAnchor, gLTextureProperty.mXRatio, gLTextureProperty.mYRatio, gLTextureProperty.mBitmap, gLTextureProperty.isGenMimps, gLTextureProperty.isRepeat);
        }
    }

    public GLOverlayBundle getOverlayBundle(int n2) {
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyOverlay(int n2, long l2) {
        Class<GLMapEngine> clazz = GLMapEngine.class;
        synchronized (GLMapEngine.class) {
            GLMapEngine.nativeDestroyOverlay(n2, l2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setSimple3DEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetSimple3DEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setStyleChangeGradualEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetStyleChangeGradualEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setRoadArrowEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetRoadArrowEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setNaviLabelEnable(int n2, boolean bl2, int n3, int n4) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetNaviLabelEnable(n2, this.mNativeMapengineInstance, bl2, n3, n4);
        }
    }

    public void setSkyTexture(int n2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetSkyTexture(n2, this.mNativeMapengineInstance, byArray);
        }
    }

    public void setBackgroundTexture(int n2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetSetBackgroundTexture(n2, this.mNativeMapengineInstance, byArray);
        }
    }

    public void setCustomStyleTexture(int n2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetCustomStyleTexture(n2, this.mNativeMapengineInstance, byArray);
        }
    }

    public void setCustomStyleData(int n2, byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return;
        }
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetCustomStyleData(n2, this.mNativeMapengineInstance, byArray, byArray2);
        }
    }

    public void setTrafficEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetTrafficEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setBuildingEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetBuildingEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setLabelEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetLabelEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setAllContentEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            if (bl2) {
                GLMapEngine.nativeSetAllContentEnable(n2, this.mNativeMapengineInstance, true);
            } else {
                GLMapEngine.nativeSetAllContentEnable(n2, this.mNativeMapengineInstance, false);
            }
            this.setSimple3DEnable(n2, false);
        }
    }

    public void setProjectionCenter(int n2, int n3, int n4) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetProjectionCenter(n2, this.mNativeMapengineInstance, n3, n4);
        }
    }

    public void setTrafficStyleWithTextureData(int n2, byte[] byArray) {
        if (this.mNativeMapengineInstance != 0L && byArray != null) {
            GLMapEngine.nativeSetTrafficTextureAllInOne(n2, this.mNativeMapengineInstance, byArray);
        }
    }

    public void startCheckEngineRenderComplete() {
        this.isEngineRenderComplete = false;
    }

    public void getCurTileIDs(int n2, int[] nArray) {
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = 0;
            }
            GLMapEngine.nativeGetCurTileIDs(n2, this.mNativeMapengineInstance, nArray, nArray.length);
        }
    }

    public void setIndoorEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetIndoorEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setOfflineDataEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetOfflineDataEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setHighlightSubwayEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetHighlightSubwayEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void setBuildingTextureEnable(int n2, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetBuildingTextureEnable(n2, this.mNativeMapengineInstance, bl2);
        }
    }

    public void initNativeTexture(int n2) {
        try {
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromAsset("arrow/arrow_line_inner.png");
            Bitmap bitmap = null;
            if (bitmapDescriptor != null) {
                bitmap = bitmapDescriptor.getBitmap();
            }
            bitmapDescriptor = BitmapDescriptorFactory.fromAsset("arrow/arrow_line_outer.png");
            Bitmap bitmap2 = null;
            if (bitmapDescriptor != null) {
                bitmap2 = bitmapDescriptor.getBitmap();
            }
            bitmapDescriptor = BitmapDescriptorFactory.fromAsset("arrow/arrow_line_shadow.png");
            Bitmap bitmap3 = null;
            if (bitmapDescriptor != null) {
                bitmap3 = bitmapDescriptor.getBitmap();
            }
            this.addOverlayTexture(n2, bitmap, 111, 4);
            this.addOverlayTexture(n2, bitmap2, 222, 4);
            this.addOverlayTexture(n2, bitmap3, 333, 4);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void addOverlayTexture(int n2, Bitmap bitmap, int n3, int n4) {
        GLTextureProperty gLTextureProperty = new GLTextureProperty();
        new GLTextureProperty().mId = n3;
        gLTextureProperty.mAnchor = n4;
        gLTextureProperty.mBitmap = bitmap;
        gLTextureProperty.mXRatio = 0.0f;
        gLTextureProperty.mYRatio = 0.0f;
        gLTextureProperty.isGenMimps = true;
        this.addOverlayTexture(n2, gLTextureProperty);
    }

    public void updateNativeArrowOverlay(int n2, String string2, int[] nArray, int[] nArray2, int n3, int n4, int n5, float f2, int n6, int n7, int n8, boolean bl2) {
        if (this.mNativeMapengineInstance != 0L && string2 != null) {
            GLMapEngine.nativeUpdateNativeArrowOverlay(n2, this.mNativeMapengineInstance, string2, nArray, nArray2, n3, n4, n5, f2, bl2, n6, n7, n8);
        }
    }

    public void removeNativeOverlay(int n2, String string2) {
        if (this.mNativeMapengineInstance != 0L && string2 != null) {
            GLMapEngine.nativeRemoveNativeOverlay(n2, this.mNativeMapengineInstance, string2);
        }
    }

    public void removeNativeAllOverlay(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeRemoveNativeAllOverlay(n2, this.mNativeMapengineInstance);
        }
    }

    public Bitmap getScreenShot(int n2, int n3, int n4, int n5, int n6) {
        if (this.mNativeMapengineInstance != 0L) {
            return er.a(GLMapEngine.nativeGetScreenShot(n2, this.mNativeMapengineInstance, n3, n4, n5, n6), n5 - n3, n6 - n4, true);
        }
        return null;
    }

    public GLMapEngine(Context context, IAMapDelegate iAMapDelegate) {
        if (context == null) {
            return;
        }
        this.context = context.getApplicationContext();
        this.mGlMapView = iAMapDelegate;
        this.mTextTextureGenerator = new TextTextureGenerator();
        this.mapAnimationMgr = new AdglMapAnimationMgr();
        this.mapAnimationMgr.setMapAnimationListener(new AdglMapAnimationMgr.MapAnimationListener(){

            public void onMapAnimationFinish(AMap.CancelableCallback cancelableCallback) {
                GLMapEngine.this.doMapAnimationFinishCallback(cancelableCallback);
            }
        });
        this.userAgent = System.getProperty("http.agent") + " amap/" + GlMapUtil.getAppVersionName(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAMapInstance(InitParam object) {
        if (object == null) {
            return false;
        }
        Class<GLMapEngine> clazz = GLMapEngine.class;
        synchronized (GLMapEngine.class) {
            GLMapEngine.nativeInitParam(((InitParam)object).mRootPath, ((InitParam)object).mConfigContent, ((InitParam)object).mOfflineDataPath, ((InitParam)object).mP3dCrossPath);
            object = "http://mpsapi.amap.com/";
            String string2 = "http://m5.amap.com/";
            DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
            int n2 = displayMetrics.densityDpi;
            float f2 = displayMetrics.density;
            DisplayMetrics displayMetrics2 = displayMetrics;
            float f3 = this.adapterDpiScale(displayMetrics2, displayMetrics2.widthPixels, displayMetrics.heightPixels, displayMetrics.densityDpi);
            this.mNativeMapengineInstance = GLMapEngine.nativeCreateAMapInstance("", (String)object, string2, n2, f2, f3);
            if (this.mNativeMapengineInstance == 0L) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return false;
            }
            GLMapEngine.nativeInitAMapEngineCallback(this.mNativeMapengineInstance, this);
            this.initNetworkState();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return true;
        }
    }

    private static String getEMUI() {
        String string2 = null;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            string2 = (String)clazz.getDeclaredMethod("get", String.class).invoke(clazz, "ro.build.version.emui");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private float adapterDpiScale(DisplayMetrics displayMetrics, int n2, int n3, int n4) {
        String string2 = GLMapEngine.getEMUI();
        float f2 = 1.0f;
        if (!(string2 == null || string2.isEmpty() || string2.indexOf("EmotionUI_8") == -1 && string2.indexOf("EmotionUI_9") == -1 || n4 <= 0)) {
            Field field;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            try {
                field = DisplayMetrics.class.getDeclaredField("noncompatWidthPixels");
                field.setAccessible(true);
                n5 = field.getInt(displayMetrics);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            try {
                field = DisplayMetrics.class.getDeclaredField("noncompatHeightPixels");
                field.setAccessible(true);
                n6 = field.getInt(displayMetrics);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            try {
                field = DisplayMetrics.class.getDeclaredField("noncompatDensityDpi");
                field.setAccessible(true);
                n7 = field.getInt(displayMetrics);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            if (n7 > n4 || n5 > n2 || n6 > n3) {
                float f3;
                f2 = (float)n7 / (float)n4;
                if (f3 > 2.0f) {
                    f2 = 2.0f;
                }
                if (f2 < 1.0f) {
                    f2 = 1.0f;
                }
            }
        }
        return f2;
    }

    private void initNetworkState() {
        this.mNetworkState = new NetworkState();
        this.mNetworkState.setNetworkListener(this);
        this.mNetworkState.registerNetChangeReceiver(this.context.getApplicationContext(), true);
        this.isNetworkConnected = NetworkState.isNetworkConnected(this.context.getApplicationContext());
        if (this.mNativeMapengineInstance != 0L) {
            GLMapEngine.nativeSetNetStatus(this.mNativeMapengineInstance, this.isNetworkConnected ? 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAMapEngineWithFrame(MapViewInitParam mapViewInitParam) {
        if (this.mNativeMapengineInstance != 0L) {
            Class<GLMapEngine> clazz = GLMapEngine.class;
            synchronized (GLMapEngine.class) {
                GLMapEngine.nativeCreateAMapEngineWithFrame(this.mNativeMapengineInstance, mapViewInitParam.engineId, mapViewInitParam.x, mapViewInitParam.y, mapViewInitParam.width, mapViewInitParam.height, mapViewInitParam.screenWidth, mapViewInitParam.screenHeight, mapViewInitParam.screenScale, mapViewInitParam.textScale, mapViewInitParam.mapZoomScale, mapViewInitParam.taskThreadCount);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }

    public void changeSurface(int n2, int n3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderAMap() {
        if (this.mNativeMapengineInstance == 0L) return;
        boolean bl2 = this.processMessage();
        Class<GLMapEngine> clazz = GLMapEngine.class;
        synchronized (GLMapEngine.class) {
            GLMapEngine.nativeRenderAMap(this.mNativeMapengineInstance, 1);
            GLMapEngine.nativePostRenderAMap(this.mNativeMapengineInstance, 1);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.initAnimation();
            if (bl2) {
                this.startCheckEngineRenderComplete();
            }
            if (this.isEngineRenderComplete) return;
            GLMapEngine.nativeSetRenderListenerStatus(1, this.mNativeMapengineInstance);
            return;
        }
    }

    public void releaseNetworkState() {
        if (this.mNetworkState != null) {
            this.mNetworkState.registerNetChangeReceiver(this.context.getApplicationContext(), false);
            this.mNetworkState.setNetworkListener(null);
            this.mNetworkState = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllAMapDownload() {
        try {
            Hashtable<Long, AMapLoader> hashtable = this.aMapLoaderHashtable;
            synchronized (hashtable) {
                Iterator<Map.Entry<Long, AMapLoader>> iterator = this.aMapLoaderHashtable.entrySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().getValue().doCancel();
                }
                this.aMapLoaderHashtable.clear();
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAMapEngine() {
        try {
            this.mRequestDestroy = true;
            this.cancelAllAMapDownload();
            List<Object> list = this.mutLock;
            synchronized (list) {
                if (this.mNativeMapengineInstance != 0L) {
                    this.mLock.lock();
                    try {
                        if (this.copyGLMapState != null) {
                            this.copyGLMapState.recycle();
                        }
                    }
                    finally {
                        this.mLock.unlock();
                    }
                    GLMapEngine.nativeDestroyCurrentState(this.mNativeMapengineInstance, this.state.getNativeInstance());
                    GLMapEngine.nativeDestroy(this.mNativeMapengineInstance);
                }
                this.mNativeMapengineInstance = 0L;
            }
            this.mGlMapView = null;
            list = this.mStateMessageList;
            synchronized (list) {
                this.mStateMessageList.clear();
            }
            list = this.mAnimateStateMessageList;
            synchronized (list) {
                this.mAnimateStateMessageList.clear();
            }
            list = this.mGestureMessageList;
            synchronized (list) {
                this.mGestureMessageList.clear();
            }
            this.mGestureEndMessageList.clear();
            this.mMapListener = null;
            this.bundle = null;
            eq.b();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            er.a(throwable2);
            return;
        }
    }

    public long getNativeMapController(int n2) {
        if (this.mNativeMapengineInstance != 0L) {
            return GLMapEngine.nativeGetNativeMapController(n2, this.mNativeMapengineInstance);
        }
        return 0L;
    }

    public boolean isNetworkConnected() {
        return this.isNetworkConnected;
    }

    private static native void nativeInitParam(String var0, String var1, String var2, String var3);

    private static native void nativeInitAMapEngineCallback(long var0, Object var2);

    private static native long nativeCreateAMapInstance(String var0, String var1, String var2, float var3, float var4, float var5);

    private static native void nativeSetNetStatus(long var0, int var2);

    private static native void nativeCreateAMapEngineWithFrame(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9, float var10, float var11, int var12);

    private static native void nativeSetServiceViewRect(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native void nativeRenderAMap(long var0, int var2);

    private static native void nativePostRenderAMap(long var0, int var2);

    private static native boolean nativeIsEngineCreated(long var0, int var2);

    private static native void nativeDestroy(long var0);

    private static native long nativeGetCurrentMapState(int var0, long var1);

    private static native void nativeDestroyCurrentState(long var0, long var2);

    private static native void nativeReceiveNetData(int var0, long var1, byte[] var3, long var4, int var6);

    private static native void nativeFinishDownLoad(int var0, long var1, long var3);

    private static native void nativeCancelDownLoad(int var0, long var1, long var3);

    private static native void nativeFailedDownLoad(int var0, long var1, long var3, int var5);

    private static native void nativeInitOpenLayer(int var0, long var1, byte[] var3);

    private static native void nativeSetOpenLayerEnable(int var0, long var1, boolean var3);

    private static native void nativeSetNaviLabelEnable(int var0, long var1, boolean var3, int var4, int var5);

    private static native void nativePushRendererState(int var0, long var1);

    private static native void nativePopRenderState(int var0, long var1);

    private static native int[] nativeGetMapModeState(int var0, long var1, boolean var3);

    private static native boolean nativeSetMapModeAndStyle(int var0, long var1, int[] var3, boolean var4, boolean var5, StyleItem[] var6);

    private static native void nativeSetParameter(int var0, long var1, int var3, int var4, int var5, int var6, int var7);

    private static native boolean nativeGetSrvViewStateBoolValue(int var0, long var1, int var3);

    private static native void nativeSetSrvViewStateBoolValue(int var0, long var1, int var3, boolean var4);

    private static native void nativeSelectMapPois(int var0, long var1, int var3, int var4, int var5, byte[] var6);

    protected static native long nativeCreateOverlay(int var0, long var1, int var3);

    protected static native void nativeDestroyOverlay(int var0, long var1);

    protected static native String nativeAddNativeOverlay(int var0, long var1, int var3, int var4);

    protected static native void nativeUpdateNativeArrowOverlay(int var0, long var1, String var3, int[] var4, int[] var5, int var6, int var7, int var8, float var9, boolean var10, int var11, int var12, int var13);

    protected static native void nativeRemoveNativeOverlay(int var0, long var1, String var3);

    protected static native void nativeRemoveNativeAllOverlay(int var0, long var1);

    private static native long nativeGetGlOverlayMgrPtr(int var0, long var1);

    private static native boolean nativeAddOverlayTexture(int var0, long var1, int var3, int var4, float var5, float var6, Bitmap var7, boolean var8, boolean var9);

    private static native void nativeSetIndoorBuildingToBeActive(int var0, long var1, String var3, int var4, String var5);

    private static native void nativeSetSimple3DEnable(int var0, long var1, boolean var3);

    private static native void nativeSetStyleChangeGradualEnable(int var0, long var1, boolean var3);

    private static native void nativeSetRoadArrowEnable(int var0, long var1, boolean var3);

    private static native void nativeSetSkyTexture(int var0, long var1, byte[] var3);

    private static native void nativeSetSetBackgroundTexture(int var0, long var1, byte[] var3);

    private static native void nativeSetCustomStyleTexture(int var0, long var1, byte[] var3);

    private static native void nativeSetCustomStyleData(int var0, long var1, byte[] var3, byte[] var4);

    private static native void nativeSetTrafficTexture(int var0, long var1, byte[] var3, byte[] var4, byte[] var5, byte[] var6);

    private static native void nativeSetTrafficTextureAllInOne(int var0, long var1, byte[] var3);

    private static native void nativeSetTrafficEnable(int var0, long var1, boolean var3);

    private static native void nativeSetLabelEnable(int var0, long var1, boolean var3);

    private static native void nativeSetAllContentEnable(int var0, long var1, boolean var3);

    private static native void nativeSetProjectionCenter(int var0, long var1, float var3, float var4);

    private static native void nativeSetRenderListenerStatus(int var0, long var1);

    private static native void nativeSetBuildingEnable(int var0, long var1, boolean var3);

    private static native void nativeSetIndoorEnable(int var0, long var1, boolean var3);

    private static native void nativeSetOfflineDataEnable(int var0, long var1, boolean var3);

    private static native void nativeSetHighlightSubwayEnable(int var0, long var1, boolean var3);

    private static native void nativeSetBuildingTextureEnable(int var0, long var1, boolean var3);

    private static native void nativeGetCurTileIDs(int var0, long var1, int[] var3, int var4);

    public static native String nativeGetMapEngineVersion(int var0);

    public static native long nativeGetNativeMapController(int var0, long var1);

    public static native int[] nativeGetScreenShot(int var0, long var1, int var3, int var4, int var5, int var6);

    public static class MapViewInitParam {
        public int engineId;
        public int x;
        public int y;
        public int width;
        public int height;
        public int screenWidth;
        public int screenHeight;
        public float screenScale;
        public float textScale;
        public float mapZoomScale;
        public int taskThreadCount = 8;
    }

    public static class InitParam {
        public String mRootPath = "";
        public String mConfigPath = "";
        public String mConfigContent = "";
        public String mOfflineDataPath = "";
        public String mP3dCrossPath = "";
    }
}

