/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.animation;

import android.view.animation.Interpolator;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.animation.GLAnimation;
import com.autonavi.amap.mapcore.animation.GLTransformation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLAnimationSet
extends GLAnimation {
    private static final int PROPERTY_FILL_AFTER_MASK = 1;
    private static final int PROPERTY_FILL_BEFORE_MASK = 2;
    private static final int PROPERTY_REPEAT_MODE_MASK = 4;
    private static final int PROPERTY_START_OFFSET_MASK = 8;
    private static final int PROPERTY_SHARE_INTERPOLATOR_MASK = 16;
    private static final int PROPERTY_DURATION_MASK = 32;
    private static final int PROPERTY_MORPH_MATRIX_MASK = 64;
    private static final int PROPERTY_CHANGE_BOUNDS_MASK = 128;
    private int mFlags = 0;
    private boolean mDirty;
    private boolean mHasAlpha;
    private ArrayList<GLAnimation> mAnimations = new ArrayList();
    private GLTransformation mTempTransformation = new GLTransformation();
    private long mLastEnd;

    public GLAnimationSet(boolean bl2) {
        this.setFlag(16, bl2);
        this.init();
    }

    @Override
    public void initialize() {
        boolean bl2;
        super.initialize();
        boolean bl3 = (this.mFlags & 0x20) == 32;
        boolean bl4 = (this.mFlags & 1) == 1;
        boolean bl5 = (this.mFlags & 2) == 2;
        boolean bl6 = (this.mFlags & 4) == 4;
        boolean bl7 = (this.mFlags & 0x10) == 16;
        boolean bl8 = bl2 = (this.mFlags & 8) == 8;
        if (bl7) {
            this.ensureInterpolator();
        }
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        int n2 = arrayList.size();
        long l2 = this.mDuration;
        boolean bl9 = this.mFillAfter;
        boolean bl10 = this.mFillBefore;
        int n3 = this.mRepeatMode;
        Interpolator interpolator = this.mInterpolator;
        long l3 = this.mStartOffset;
        for (int i2 = 0; i2 < n2; ++i2) {
            GLAnimation gLAnimation = arrayList.get(i2);
            if (bl3) {
                gLAnimation.setDuration(l2);
            }
            if (bl4) {
                gLAnimation.setFillAfter(bl9);
            }
            if (bl5) {
                gLAnimation.setFillBefore(bl10);
            }
            if (bl6) {
                gLAnimation.setRepeatMode(n3);
            }
            if (bl7) {
                gLAnimation.setInterpolator(interpolator);
            }
            if (bl2) {
                long l4 = gLAnimation.getStartOffset();
                gLAnimation.setStartOffset(l4 + l3);
            }
            gLAnimation.initialize();
        }
    }

    @Override
    public GLAnimationSet clone() throws CloneNotSupportedException {
        GLAnimationSet gLAnimationSet = (GLAnimationSet)super.clone();
        ((GLAnimationSet)super.clone()).mTempTransformation = new GLTransformation();
        gLAnimationSet.mAnimations = new ArrayList();
        int n2 = this.mAnimations.size();
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        for (int i2 = 0; i2 < n2; ++i2) {
            gLAnimationSet.mAnimations.add(arrayList.get(i2).clone());
        }
        return gLAnimationSet;
    }

    private void setFlag(int n2, boolean bl2) {
        if (bl2) {
            this.mFlags |= n2;
            return;
        }
        this.mFlags &= ~n2;
    }

    private void init() {
        this.mStartTime = 0L;
    }

    @Override
    public void setFillAfter(boolean bl2) {
        this.mFlags |= 1;
        super.setFillAfter(bl2);
    }

    @Override
    public void setFillBefore(boolean bl2) {
        this.mFlags |= 2;
        super.setFillBefore(bl2);
    }

    @Override
    public void setRepeatMode(int n2) {
        this.mFlags |= 4;
        super.setRepeatMode(n2);
    }

    @Override
    public void setStartOffset(long l2) {
        this.mFlags |= 8;
        super.setStartOffset(l2);
    }

    @Override
    public boolean hasAlpha() {
        if (this.mDirty) {
            GLAnimationSet gLAnimationSet = this;
            gLAnimationSet.mHasAlpha = false;
            gLAnimationSet.mDirty = false;
            int n2 = this.mAnimations.size();
            ArrayList<GLAnimation> arrayList = this.mAnimations;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!arrayList.get(i2).hasAlpha()) continue;
                this.mHasAlpha = true;
                break;
            }
        }
        return this.mHasAlpha;
    }

    @Override
    public void setDuration(long l2) {
        this.mFlags |= 0x20;
        super.setDuration(l2);
        this.mLastEnd = this.mStartOffset + this.mDuration;
    }

    public void addAnimation(Animation animation) {
        this.mAnimations.add(animation.glAnimation);
        if ((this.mFlags & 0x40) == 0 && animation.glAnimation.willChangeTransformationMatrix()) {
            this.mFlags |= 0x40;
        }
        if ((this.mFlags & 0x80) == 0 && animation.glAnimation.willChangeBounds()) {
            this.mFlags |= 0x80;
        }
        if ((this.mFlags & 0x20) == 32) {
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else if (this.mAnimations.size() == 1) {
            this.mDuration = animation.glAnimation.getStartOffset() + animation.glAnimation.getDuration();
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else {
            this.mLastEnd = Math.max(this.mLastEnd, animation.glAnimation.getStartOffset() + animation.glAnimation.getDuration());
            this.mDuration = this.mLastEnd - this.mStartOffset;
        }
        this.mDirty = true;
    }

    @Override
    public void setStartTime(long l2) {
        super.setStartTime(l2);
        int n2 = this.mAnimations.size();
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.get(i2).setStartTime(l2);
        }
    }

    @Override
    public long getStartTime() {
        long l2 = Long.MAX_VALUE;
        int n2 = this.mAnimations.size();
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        for (int i2 = 0; i2 < n2; ++i2) {
            GLAnimation gLAnimation = arrayList.get(i2);
            l2 = Math.min(l2, gLAnimation.getStartTime());
        }
        return l2;
    }

    @Override
    public void restrictDuration(long l2) {
        super.restrictDuration(l2);
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.get(i2).restrictDuration(l2);
        }
    }

    @Override
    public long getDuration() {
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        int n2 = arrayList.size();
        long l2 = 0L;
        if ((this.mFlags & 0x20) == 32) {
            l2 = this.mDuration;
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 = Math.max(l2, arrayList.get(i2).getDuration());
            }
        }
        return l2;
    }

    @Override
    public long computeDurationHint() {
        long l2 = 0L;
        int n2 = this.mAnimations.size();
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        --n2;
        while (n2 >= 0) {
            long l3 = arrayList.get(n2).computeDurationHint();
            if (l3 > l2) {
                l2 = l3;
            }
            --n2;
        }
        return l2;
    }

    @Override
    public boolean getTransformation(long l2, GLTransformation gLTransformation) {
        if (!this.mInitialized) {
            this.initialize();
        }
        int n2 = this.mAnimations.size();
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        GLTransformation gLTransformation2 = this.mTempTransformation;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        gLTransformation.clear();
        --n2;
        while (n2 >= 0) {
            GLAnimation gLAnimation = arrayList.get(n2);
            gLTransformation2.clear();
            bl2 = gLAnimation.getTransformation(l2, gLTransformation, this.getScaleFactor()) || bl2;
            bl3 = bl3 || gLAnimation.hasStarted();
            bl4 = gLAnimation.hasEnded() && bl4;
            --n2;
        }
        try {
            if (bl3 && !this.mStarted) {
                if (this.mListener != null) {
                    this.mListener.onAnimationStart();
                }
                this.mStarted = true;
            }
            if (bl4 != this.mEnded) {
                if (this.mListener != null) {
                    this.mListener.onAnimationEnd();
                }
                this.mEnded = bl4;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl2;
    }

    @Override
    public void scaleCurrentDuration(float f2) {
        ArrayList<GLAnimation> arrayList = this.mAnimations;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.get(i2).scaleCurrentDuration(f2);
        }
    }

    @Override
    public void reset() {
        super.reset();
    }

    public List<GLAnimation> getAnimations() {
        return this.mAnimations;
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return (this.mFlags & 0x40) == 64;
    }

    @Override
    public boolean willChangeBounds() {
        return (this.mFlags & 0x80) == 128;
    }

    public void cleanAnimation() {
        this.mAnimations.clear();
    }
}

