/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.graphics.Typeface;
import com.amap.api.mapcore.util.cx;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.TextOptions;
import com.autonavi.amap.mapcore.interfaces.IText;

public final class Text {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER_HORIZONTAL = 4;
    public static final int ALIGN_TOP = 8;
    public static final int ALIGN_BOTTOM = 16;
    public static final int ALIGN_CENTER_VERTICAL = 32;
    private IText textDelegate;
    private Marker marker;
    private TextOptions textOptions;

    public Text(IText iText) {
        this.textDelegate = iText;
    }

    public Text(Marker marker, TextOptions textOptions) {
        this.marker = marker;
        this.textOptions = textOptions;
    }

    public final void remove() {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.remove();
                return;
            }
            this.marker.remove();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void destroy() {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.destroy(true);
                return;
            }
            this.marker.destroy();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final String getId() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getId();
            }
            return this.marker.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setPosition(LatLng latLng) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setPosition(latLng);
                return;
            }
            this.marker.setPosition(latLng);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final LatLng getPosition() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getPosition();
            }
            return this.marker.getPosition();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setText(String string2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setText(string2);
                return;
            }
            this.textOptions.text(string2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void a() {
        this.marker.setIcon(cx.b(this.textOptions));
    }

    public final String getText() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getText();
            }
            return this.textOptions.getText();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setBackgroundColor(int n2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setBackgroundColor(n2);
                return;
            }
            this.textOptions.backgroundColor(n2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getBackgroundColor() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getBackgroundColor();
            }
            return this.textOptions.getBackgroundColor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setFontColor(int n2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setFontColor(n2);
                return;
            }
            this.textOptions.fontColor(n2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getFontColor() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getFontColor();
            }
            return this.textOptions.getFontColor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setFontSize(int n2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setFontSize(n2);
                return;
            }
            this.textOptions.fontSize(n2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getFontSize() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getFontSize();
            }
            return this.textOptions.getFontSize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setTypeface(Typeface typeface) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setTypeface(typeface);
                return;
            }
            this.textOptions.typeface(typeface);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final Typeface getTypeface() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getTypeface();
            }
            return this.textOptions.getTypeface();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setAlign(int n2, int n3) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setAlign(n2, n3);
                return;
            }
            this.textOptions.align(n2, n3);
            this.marker.setAnchor(cx.a(this.textOptions.getAlignX(), true), cx.a(this.textOptions.getAlignY(), false));
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getAlignX() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getAlignX();
            }
            return this.textOptions.getAlignX();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final int getAlignY() {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.getAlignY();
            } else {
                this.textOptions.getAlignY();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return 0;
    }

    public final void setVisible(boolean bl2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setVisible(bl2);
                return;
            }
            this.marker.setVisible(bl2);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isVisible() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.isVisible();
            }
            return this.marker.isVisible();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Text)) {
            return false;
        }
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.equalsRemote(((Text)object).textDelegate);
            }
            return this.marker.equals(((Text)object).marker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final int hashCode() {
        if (this.textDelegate != null) {
            return this.textDelegate.hashCodeRemote();
        }
        return this.marker.hashCode();
    }

    public final void setObject(Object object) {
        if (this.textDelegate != null) {
            this.textDelegate.setObject(object);
            return;
        }
        this.marker.setObject(object);
    }

    public final Object getObject() {
        if (this.textDelegate != null) {
            return this.textDelegate.getObject();
        }
        return this.marker.getObject();
    }

    public final void setRotate(float f2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setRotateAngle(f2);
                return;
            }
            this.marker.setRotateAngle(f2);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getRotate() {
        if (this.textDelegate != null) {
            return this.textDelegate.getRotateAngle();
        }
        return this.marker.getRotateAngle();
    }

    public final void setZIndex(float f2) {
        if (this.textDelegate != null) {
            this.textDelegate.setZIndex(f2);
            return;
        }
        this.marker.setZIndex(f2);
    }

    public final float getZIndex() {
        if (this.textDelegate != null) {
            return this.textDelegate.getZIndex();
        }
        return this.marker.getZIndex();
    }
}

