/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolylineOptions;
import com.autonavi.amap.mapcore.interfaces.IPolyline;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline
extends BaseOverlay {
    private IPolyline polylineDelegate;
    private PolylineOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public Polyline(IGlOverlayLayer iGlOverlayLayer, PolylineOptions polylineOptions) {
        super("");
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = polylineOptions;
    }

    public Polyline(IGlOverlayLayer iGlOverlayLayer, PolylineOptions polylineOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = polylineOptions;
    }

    public Polyline(IPolyline iPolyline) {
        super("");
        this.polylineDelegate = iPolyline;
    }

    public void remove() {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.remove();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            this.overlayName = null;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public String getId() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<LatLng> list) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setPoints(list);
                return;
            }
            Polyline polyline = this;
            synchronized (polyline) {
                if (this.options != null) {
                    this.options.setPoints(list);
                    this.a();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public List<LatLng> getPoints() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getPoints();
            }
            if (this.options != null) {
                return this.options.getPoints();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setGeodesic(boolean bl2) {
        try {
            if (this.polylineDelegate != null) {
                if (this.polylineDelegate.isGeodesic() != bl2) {
                    List<LatLng> list = this.getPoints();
                    this.polylineDelegate.setGeodesic(bl2);
                    this.setPoints(list);
                    return;
                }
            } else if (this.options != null) {
                this.options.geodesic(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean isGeodesic() {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.isGeodesic();
        }
        return this.options != null && this.options.isGeodesic();
    }

    public void setDottedLine(boolean bl2) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setDottedLine(bl2);
            return;
        }
        if (this.options != null) {
            this.options.setDottedLine(bl2);
            this.a();
        }
    }

    public boolean isDottedLine() {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.isDottedLine();
        }
        if (this.options != null) {
            return this.options.isDottedLine();
        }
        return false;
    }

    public void setWidth(float f2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setWidth(f2);
                return;
            }
            if (this.options != null) {
                this.options.width(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public float getWidth() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getWidth();
            }
            if (this.options != null) {
                return this.options.getWidth();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setColor(int n2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setColor(n2);
                return;
            }
            if (this.options != null) {
                this.options.color(n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public int getColor() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getColor();
            }
            if (this.options != null) {
                return this.options.getColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setZIndex(float f2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setZIndex(f2);
                return;
            }
            if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public float getZIndex() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getZIndex();
            }
            if (this.options != null) {
                return this.options.getZIndex();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setVisible(bl2);
                return;
            }
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean isVisible() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.isVisible();
            }
            if (this.options != null) {
                return this.options.isVisible();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Polyline)) {
            return false;
        }
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.equalsRemote(((Polyline)object).polylineDelegate);
            }
            return super.equals(object) || ((Polyline)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.hashCodeRemote();
            }
            return super.hashCode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public LatLng getNearestLatLng(LatLng latLng) {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.getNearestLatLng(latLng);
        }
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (iGlOverlayLayer != null) {
            return iGlOverlayLayer.getNearestLatLng(this.options, latLng);
        }
        return null;
    }

    public void setTransparency(float f2) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setTransparency(f2);
            return;
        }
        if (this.options != null) {
            this.options.transparency(f2);
            this.a();
        }
    }

    public void setAboveMaskLayer(boolean bl2) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setAboveMaskLayer(bl2);
            return;
        }
        if (this.options != null) {
            this.options.aboveMaskLayer(bl2);
            this.a();
        }
    }

    public void setCustomTexture(BitmapDescriptor bitmapDescriptor) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setCustomTexture(bitmapDescriptor);
            return;
        }
        if (this.options != null) {
            this.options.setCustomTexture(bitmapDescriptor);
            this.a();
        }
    }

    public void setOptions(PolylineOptions polylineOptions) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setOptions(polylineOptions);
            return;
        }
        this.options = polylineOptions;
        this.a();
    }

    public PolylineOptions getOptions() {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.getOptions();
        }
        return this.options;
    }

    @Deprecated
    public void setCustemTextureIndex(List<Integer> list) {
        this.setCustomTextureIndex(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomTextureIndex(List<Integer> list) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setCustomTextureIndex(list);
            return;
        }
        Polyline polyline = this;
        synchronized (polyline) {
            if (this.options != null) {
                this.options.setCustomTextureIndex(list);
                this.a();
            }
            return;
        }
    }

    public void setShownRatio(float f2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setShownRatio(f2);
                return;
            }
            if (this.options != null) {
                this.options.setShownRatio(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void setShownRange(float f2, float f3) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setShowRange(f2, f3);
                return;
            }
            if (this.options != null) {
                this.options.setShownRange(f2, f3);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public float getShownRatio() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getShownRatio();
            }
            if (this.options != null) {
                return this.options.getShownRatio();
            }
            return -1.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1.0f;
        }
    }

    public void showPolylineRangeEnabled(boolean bl2) {
        try {
            if (this.polylineDelegate == null && this.options != null) {
                this.options.showPolylineRangeEnabled(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public boolean isShowPolylineRangeEnable() {
        try {
            if (this.polylineDelegate != null) {
                return false;
            }
            if (this.options != null) {
                return this.options.isShowPolylineRangeEnable();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setPolylineShowRange(float f2, float f3) {
        try {
            if (this.polylineDelegate == null && this.options != null) {
                this.options.setPolylineShowRange(f2, f3);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public float getPolylineShownRangeBegin() {
        try {
            if (this.polylineDelegate != null) {
                return 0.0f;
            }
            if (this.options != null) {
                return this.options.getPolylineShownRangeBegin();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public float getPolylineShownRangeEnd() {
        try {
            if (this.polylineDelegate != null) {
                return 0.0f;
            }
            if (this.options != null) {
                return this.options.getPolylineShownRangeEnd();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setFootPrintTexture(BitmapDescriptor bitmapDescriptor) {
        try {
            if (this.polylineDelegate == null && this.options != null) {
                this.options.setFootPrintTexture(bitmapDescriptor);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public BitmapDescriptor getFootPrintTexture() {
        try {
            if (this.polylineDelegate != null) {
                return null;
            }
            if (this.options != null) {
                return this.options.getFootPrintTexture();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setFootPrintGap(float f2) {
        try {
            if (this.polylineDelegate == null && this.options != null) {
                this.options.setFootPrintGap(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public float getFootPrintGap() {
        try {
            if (this.polylineDelegate != null) {
                return 0.0f;
            }
            if (this.options != null) {
                return this.options.getFootPrintGap();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setEraseTexture(boolean bl2, BitmapDescriptor bitmapDescriptor) {
        try {
            if (this.polylineDelegate == null && this.options != null) {
                this.options.setEraseTexture(bl2, bitmapDescriptor);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public BitmapDescriptor getEraseTexture() {
        try {
            if (this.polylineDelegate != null) {
                return null;
            }
            if (this.options != null) {
                return this.options.getEraseTexture();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public boolean getEraseVisible() {
        try {
            if (this.polylineDelegate != null) {
                return false;
            }
            if (this.options != null) {
                return this.options.getEraseVisible();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setEraseColor(boolean bl2, int n2) {
        try {
            if (this.polylineDelegate == null && this.options != null) {
                this.options.setEraseColor(bl2, n2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public int getEraseColor() {
        try {
            if (this.polylineDelegate != null) {
                return 0;
            }
            if (this.options != null) {
                return this.options.getEraseColor();
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        try {
            Polyline polyline = this;
            synchronized (polyline) {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                    iGlOverlayLayer.updateOption(this.overlayName, this.options);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setCustomTextureList(List<BitmapDescriptor> list) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setCustomTextureList(list);
                return;
            }
            this.options.setCustomTextureList(list);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

