/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import android.util.Log;
import com.amap.api.mapcore.util.eq;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BasePointOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import com.autonavi.amap.mapcore.interfaces.IMarker;
import com.autonavi.amap.mapcore.interfaces.IMarkerAction;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Marker
extends BasePointOverlay {
    private IMarker markerDelegate;
    private MarkerOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private Object object;
    private IPoint geoPoint;
    private boolean isRemoved = false;
    private DPoint viewModeLatLngDp = new DPoint();
    private LatLng viewModeLatLng = null;
    private boolean isUseAnimation = false;
    private Animation mCurAnimation = null;
    private Animation.AnimationListener mCurAnimationListener = null;
    private a mCurInnerAnimationListener = null;
    private boolean isClickable = true;
    private boolean isInfoWindowEnable = true;

    public Marker(IMarker iMarker) {
        super("");
        this.markerDelegate = iMarker;
    }

    public Marker(IGlOverlayLayer iGlOverlayLayer, MarkerOptions markerOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = markerOptions;
    }

    public final void setPeriod(int n2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setPeriod(n2);
                return;
            }
            this.options.period(n2);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final int getPeriod() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getPeriod();
            }
            return this.options.getPeriod();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public final void setIcons(ArrayList<BitmapDescriptor> arrayList) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setIcons(arrayList);
                return;
            }
            this.options.icons(arrayList);
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final ArrayList<BitmapDescriptor> getIcons() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getIcons();
            }
            return this.options.getIcons();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public final void remove() {
        try {
            IGlOverlayLayer iGlOverlayLayer;
            if (this.markerDelegate != null) {
                this.markerDelegate.remove();
                return;
            }
            if (this.isInfoWindowShown()) {
                this.hideInfoWindow();
            }
            if ((iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get()) != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            this.isRemoved = true;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.destroy(true);
                return;
            }
            this.remove();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final String getId() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setPerspective(boolean bl2) {
    }

    public final boolean isPerspective() {
        return false;
    }

    @Override
    public final void setPosition(LatLng latLng) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setPosition(latLng);
                return;
            }
            if (this.options != null) {
                this.options.position(latLng);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final LatLng getPosition() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getPosition();
            }
            if (this.options != null) {
                Object object;
                if (this.isViewMode()) {
                    ((IGlOverlayLayer)this.glOverlayLayerRef.get()).getMap().getPixel2LatLng(this.options.getScreenX(), this.options.getScreenY(), this.viewModeLatLngDp);
                    if (this.viewModeLatLng != null && this.viewModeLatLng.latitude == this.viewModeLatLngDp.y && this.viewModeLatLng.longitude == this.viewModeLatLngDp.x) {
                        return this.viewModeLatLng;
                    }
                    return new LatLng(this.viewModeLatLngDp.y, this.viewModeLatLngDp.x);
                }
                if (this.isUseAnimation && (object = this.a("getPosition", null)) != null) {
                    return (LatLng)object;
                }
                return this.options.getPosition();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public final void setTitle(String string2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setTitle(string2);
                return;
            }
            if (this.options != null) {
                this.options.title(string2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final String getTitle() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getTitle();
            }
            if (this.options != null) {
                return this.options.getTitle();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public final void setSnippet(String string2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setSnippet(string2);
                return;
            }
            if (this.options != null) {
                this.options.snippet(string2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final String getSnippet() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.getSnippet();
            }
            if (this.options != null) {
                return this.options.getSnippet();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public final void setIcon(BitmapDescriptor bitmapDescriptor) {
        try {
            if (bitmapDescriptor != null) {
                if (this.markerDelegate != null) {
                    this.markerDelegate.setIcon(bitmapDescriptor);
                    return;
                }
                if (this.options != null) {
                    this.options.icon(bitmapDescriptor);
                    this.a();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void setAnchor(float f2, float f3) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setAnchor(f2, f3);
                return;
            }
            if (this.options != null) {
                this.options.anchor(f2, f3);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void setDraggable(boolean bl2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setDraggable(bl2);
                return;
            }
            if (this.options != null) {
                this.options.draggable(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isDraggable() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isDraggable();
        }
        if (this.options != null) {
            return this.options.isDraggable();
        }
        return false;
    }

    @Override
    public final void showInfoWindow() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.showInfoWindow();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.showInfoWindow(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void hideInfoWindow() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.hideInfoWindow();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.hideInfoWindow(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isInfoWindowShown() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isInfoWindowShown();
        }
        Object object = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (!TextUtils.isEmpty((CharSequence)this.overlayName) && object != null && (object = this.a("isInfoWindowShown", null)) instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    public final void setVisible(boolean bl2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setVisible(bl2);
                return;
            }
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final boolean isVisible() {
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.isVisible();
            }
            if (this.options != null) {
                return this.options.isVisible();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Marker)) {
            return false;
        }
        try {
            if (this.markerDelegate != null) {
                return this.markerDelegate.equalsRemote(((Marker)object).markerDelegate);
            }
            if (this.options != null) {
                return this.options.equals(((Marker)object).options) && this.overlayName.equals(((Marker)object).overlayName);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public final int hashCode() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.hashCode();
        }
        if (this.options != null) {
            int n2 = 31 + (this.overlayName == null ? 0 : this.overlayName.hashCode());
            return 31 * n2 + this.options.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public final void setObject(Object object) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setObject(object);
            return;
        }
        this.object = object;
    }

    @Override
    public final Object getObject() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getObject();
        }
        return this.object;
    }

    @Override
    public final void setRotateAngle(float f2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setRotateAngle(f2);
                return;
            }
            if (this.options != null) {
                this.options.rotateAngle(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final float getRotateAngle() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getRotateAngle();
        }
        if (this.options != null) {
            if (this.isUseAnimation) {
                Object object = this.a("getRotateAngle", null);
                Log.e((String)"mapcore", (String)"getRotateAngle ".concat(String.valueOf(object)));
                if (object != null) {
                    return ((Double)object).floatValue();
                }
            }
            return this.options.getRotateAngle();
        }
        return 0.0f;
    }

    public final void setToTop() {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.set2Top();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.set2Top(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    public final void setGeoPoint(IPoint object) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setGeoPoint((IPoint)object);
            return;
        }
        this.geoPoint = object;
        if (object != null) {
            object = VirtualEarthProjection.pixelsToLatLong(((IPoint)object).x, ((IPoint)object).y, 20);
            LatLng latLng = new LatLng(((DPoint)object).y, ((DPoint)object).x, false);
            ((DPoint)object).recycle();
            this.options.position(latLng);
            this.a();
        }
    }

    public final IPoint getGeoPoint() {
        LatLng latLng;
        if (this.markerDelegate != null) {
            return this.markerDelegate.getGeoPoint();
        }
        if (this.geoPoint == null) {
            this.geoPoint = new IPoint();
        }
        if ((latLng = this.getPosition()) != null) {
            VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20, this.geoPoint);
        }
        return this.geoPoint;
    }

    public final void setFlat(boolean bl2) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setFlat(bl2);
                return;
            }
            if (this.options != null) {
                this.options.setFlat(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isFlat() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isFlat();
        }
        if (this.options != null) {
            return this.options.isFlat();
        }
        return false;
    }

    public final void setPositionByPixels(int n2, int n3) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setPositionByPixels(n2, n3);
            return;
        }
        if (this.options != null) {
            this.options.setScreenPosition(n2, n3);
            this.a();
        }
    }

    public final void setZIndex(float f2) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setZIndex(f2);
            return;
        }
        if (this.options != null) {
            this.options.zIndex(f2);
            this.a();
        }
    }

    public final float getZIndex() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getZIndex();
        }
        if (this.options != null) {
            return this.options.getZIndex();
        }
        return 0.0f;
    }

    @Override
    public final void setAnimation(Animation animation) {
        try {
            if (this.markerDelegate != null) {
                this.markerDelegate.setAnimation(animation);
                return;
            }
            if (animation != null && this.mCurAnimationListener != null) {
                animation.setAnimationListener(this.mCurAnimationListener);
            }
            this.mCurAnimation = animation;
            this.isUseAnimation = animation != null;
            this.a("setAnimation", new Object[]{animation});
            if (animation != null) {
                animation.resetUpdateFlags();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    @Override
    public final boolean startAnimation() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.startAnimation();
        }
        Object object = this.a("startAnimation", null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public final void setAnimationListener(Animation.AnimationListener animationListener) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setAnimationListener(animationListener);
            return;
        }
        this.mCurAnimationListener = animationListener;
        this.mCurInnerAnimationListener = new a(animationListener, 0);
        if (this.mCurAnimation != null) {
            this.a("setAnimationListener", new Object[]{this.mCurAnimationListener});
        }
    }

    public final float getAlpha() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.getAlpha();
            }
        } else if (this.options != null) {
            Object object;
            if (this.isUseAnimation && (object = this.a("getAlpha", null)) != null) {
                return ((Double)object).floatValue();
            }
            return this.options.getAlpha();
        }
        return 1.0f;
    }

    public final void setAlpha(float f2) {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setAlpha(f2);
            }
            return;
        }
        if (this.options != null) {
            this.options.alpha(f2);
            this.a();
        }
    }

    public final int getDisplayLevel() {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            return iMarkerAction.getDisplayLevel();
        }
        return 5;
    }

    public final MarkerOptions getOptions() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.getOptions();
            }
        } else if (this.options != null) {
            return this.options;
        }
        return null;
    }

    public final boolean isClickable() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.isClickable();
            }
        } else {
            Object object = this.a("isClickable", null);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        return this.isClickable;
    }

    public final boolean isInfoWindowAutoOverturn() {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            return iMarkerAction.isInfoWindowAutoOverturn();
        }
        return false;
    }

    @Override
    public final boolean isInfoWindowEnable() {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                return iMarkerAction.isInfoWindowEnable();
            }
        } else if (this.options != null) {
            return this.options.isInfoWindowEnable();
        }
        return this.isInfoWindowEnable;
    }

    public final void setInfoWindowEnable(boolean bl2) {
        this.isInfoWindowEnable = bl2;
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setInfoWindowEnable(bl2);
            }
            return;
        }
        if (this.options != null) {
            this.options.infoWindowEnable(bl2);
            this.a();
        }
    }

    public final void setMarkerOptions(MarkerOptions markerOptions) {
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setMarkerOptions(markerOptions);
            }
            return;
        }
        this.options = markerOptions;
        this.a();
    }

    public final void setAutoOverturnInfoWindow(boolean bl2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setAutoOverturnInfoWindow(bl2);
        }
    }

    public final void setClickable(boolean bl2) {
        this.isClickable = bl2;
        if (this.markerDelegate != null) {
            IMarkerAction iMarkerAction = this.markerDelegate.getIMarkerAction();
            if (iMarkerAction != null) {
                iMarkerAction.setClickable(bl2);
            }
            return;
        }
        this.a("setClickable", new Object[]{bl2});
    }

    public final void setDisplayLevel(int n2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setDisplayLevel(n2);
        }
    }

    public final void setFixingPointEnable(boolean bl2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setFixingPointEnable(bl2);
        }
    }

    public final boolean isRemoved() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.isRemoved();
        }
        return this.isRemoved;
    }

    public final void setPositionNotUpdate(LatLng latLng) {
        this.setPosition(latLng);
    }

    public final void setRotateAngleNotUpdate(float f2) {
        IMarkerAction iMarkerAction;
        if (this.markerDelegate != null && (iMarkerAction = this.markerDelegate.getIMarkerAction()) != null) {
            iMarkerAction.setRotateAngleNotUpdate(f2);
        }
    }

    public final void setBelowMaskLayer(boolean bl2) {
        if (this.markerDelegate != null) {
            this.markerDelegate.setBelowMaskLayer(bl2);
            return;
        }
        if (this.options != null) {
            this.options.belowMaskLayer(bl2);
            this.a();
        }
    }

    public final float getAnchorU() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getAnchorU();
        }
        if (this.options != null) {
            return this.options.getAnchorU();
        }
        return 0.0f;
    }

    public final float getAnchorV() {
        if (this.markerDelegate != null) {
            return this.markerDelegate.getAnchorV();
        }
        if (this.options != null) {
            return this.options.getAnchorV();
        }
        return 0.0f;
    }

    private Object a(String string2, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string2, objectArray);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public final boolean isViewMode() {
        if (this.options != null) {
            return this.options.isViewMode();
        }
        return false;
    }

    private final class a
    implements Animation.AnimationListener {
        private final Runnable b;
        private final Runnable c;

        private a(final Animation.AnimationListener animationListener) {
            this.b = new Runnable(){

                public final void run() {
                    try {
                        if (animationListener != null) {
                            animationListener.onAnimationStart();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            };
            this.c = new Runnable(){

                public final void run() {
                    try {
                        if (animationListener != null) {
                            animationListener.onAnimationEnd();
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            };
        }

        public final void onAnimationStart() {
            eq.a().a(this.b);
        }

        public final void onAnimationEnd() {
            eq.a().a(this.c);
        }

        /* synthetic */ a(Animation.AnimationListener animationListener, byte by2) {
            this(animationListener);
        }
    }
}

