/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.HeatMapItem;
import com.amap.api.maps.model.HeatMapLayerOptions;
import com.amap.api.maps.model.LatLng;
import com.autonavi.amap.mapcore.interfaces.IHeatMapLayer;
import java.lang.ref.WeakReference;

public class HeatMapLayer
extends BaseOverlay {
    private IHeatMapLayer mHeatMapLayer;
    private HeatMapLayerOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public HeatMapLayer(IHeatMapLayer iHeatMapLayer) {
        super("");
        this.mHeatMapLayer = iHeatMapLayer;
    }

    public HeatMapLayer(IGlOverlayLayer iGlOverlayLayer, HeatMapLayerOptions heatMapLayerOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = heatMapLayerOptions;
        this.a();
    }

    public void destroy() {
        try {
            if (this.mHeatMapLayer != null) {
                this.mHeatMapLayer.remove();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public String getId() {
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setZIndex(float f2) {
        try {
            if (this.mHeatMapLayer != null) {
                this.mHeatMapLayer.setZIndex(f2);
                return;
            }
            if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public float getZIndex() {
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.getZIndex();
            }
            if (this.options != null) {
                return this.options.getZIndex();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.mHeatMapLayer != null) {
                this.mHeatMapLayer.setVisible(bl2);
                return;
            }
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public boolean isVisible() {
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.isVisible();
            }
            return this.options != null && this.options.isVisible();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HeatMapLayer)) {
            return false;
        }
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.equalsRemote(((HeatMapLayer)object).mHeatMapLayer);
            }
            return super.equals(object) || ((HeatMapLayer)object).getId().equals(this.getId());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.hashCodeRemote();
            }
            return super.hashCode();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public HeatMapItem getHeatMapItem(LatLng object) {
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.getHeatMapItem((LatLng)object);
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null && (object = iGlOverlayLayer.getNativeProperties(this.overlayName, "getHeatMapItem", new Object[]{object})) instanceof HeatMapItem) {
                return (HeatMapItem)object;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public HeatMapLayerOptions getOptions() {
        try {
            if (this.mHeatMapLayer != null) {
                return this.mHeatMapLayer.getOptions();
            }
            return this.options;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setOptions(HeatMapLayerOptions heatMapLayerOptions) {
        try {
            if (this.mHeatMapLayer != null) {
                this.mHeatMapLayer.setOptions(heatMapLayerOptions);
                return;
            }
            this.options = heatMapLayerOptions;
            this.a();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

