/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.GroundOverlayOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.interfaces.IGroundOverlay;
import java.lang.ref.WeakReference;

public final class GroundOverlay
extends BaseOverlay {
    private IGroundOverlay iGroundOverlayDelegate;
    private GroundOverlayOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private LatLng point;
    private float width;
    private float high;

    public GroundOverlay(IGroundOverlay iGroundOverlay) {
        super("");
        this.iGroundOverlayDelegate = iGroundOverlay;
    }

    public GroundOverlay(IGlOverlayLayer iGlOverlayLayer, GroundOverlayOptions groundOverlayOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = groundOverlayOptions;
    }

    public final void remove() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.remove();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            if (this.options != null && this.options.getImage() != null) {
                this.options.getImage().recycle();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final String getId() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setPosition(LatLng latLng) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setPosition(latLng);
                return;
            }
            if (this.options != null && latLng != null) {
                float f2;
                float f3 = this.width > 0.0f ? this.width : this.options.getWidth();
                float f4 = f2 = this.high > 0.0f ? this.high : this.options.getHeight();
                if (f3 == 0.0f) {
                    this.point = latLng;
                    return;
                }
                if (f2 == 0.0f) {
                    this.options.position(latLng, f3);
                    this.a();
                    return;
                }
                if (f2 > 0.0f) {
                    this.options.position(latLng, f3, f2);
                    this.a();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final LatLng getPosition() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getPosition();
            }
            if (this.options != null) {
                return this.options.getLocation();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setDimensions(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setDimensions(f2);
                return;
            }
            if (this.options != null) {
                LatLng latLng = this.point != null ? this.point : this.options.getLocation();
                if (latLng == null) {
                    this.width = f2;
                    return;
                }
                this.options.position(latLng, f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void setImage(BitmapDescriptor bitmapDescriptor) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setImage(bitmapDescriptor);
                return;
            }
            if (this.options != null) {
                this.options.image(bitmapDescriptor);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final void setDimensions(float f2, float f3) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setDimensions(f2, f3);
                return;
            }
            if (this.options != null) {
                if ((this.point != null ? this.point : this.options.getLocation()) == null) {
                    this.width = f2;
                    this.high = f3;
                    return;
                }
                this.options.position(this.options.getLocation(), f2, f3);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getWidth() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getWidth();
            }
            if (this.options != null) {
                return this.options.getWidth();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final float getHeight() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getHeight();
            }
            if (this.options != null) {
                return this.options.getHeight();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setPositionFromBounds(LatLngBounds latLngBounds) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setPositionFromBounds(latLngBounds);
                return;
            }
            if (this.options != null && latLngBounds != null) {
                this.options.positionFromBounds(latLngBounds);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final LatLngBounds getBounds() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getBounds();
            }
            if (this.options != null) {
                return this.options.getBounds();
            }
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public final void setBearing(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setBearing(f2);
                return;
            }
            if (this.options != null) {
                this.options.bearing(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getBearing() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getBearing();
            }
            if (this.options != null) {
                return this.options.getBearing();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setZIndex(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setZIndex(f2);
                return;
            }
            if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getZIndex() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getZIndex();
            }
            if (this.options != null) {
                return this.options.getZIndex();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final void setVisible(boolean bl2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setVisible(bl2);
                return;
            }
            if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final boolean isVisible() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.isVisible();
            }
            if (this.options != null) {
                return this.options.isVisible();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final void setTransparency(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setTransparency(f2);
                return;
            }
            if (this.options != null) {
                this.options.transparency(f2);
                this.a();
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public final float getTransparency() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getTransparency();
            }
            if (this.options != null) {
                return this.options.getTransparency();
            }
            return 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof GroundOverlay)) {
            return false;
        }
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.equalsRemote(((GroundOverlay)object).iGroundOverlayDelegate);
            }
            return super.equals(object) || ((GroundOverlay)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public final void destroy() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.destroy();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public final int hashCode() {
        if (this.iGroundOverlayDelegate != null) {
            return this.iGroundOverlayDelegate.hashCode();
        }
        return super.hashCode();
    }

    private void a() {
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
            iGlOverlayLayer.updateOption(this.overlayName, this.options);
        }
    }
}

