/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BasePointOverlay;
import com.amap.api.maps.model.GL3DModelOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.animation.Animation;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.interfaces.IglModel;
import java.lang.ref.WeakReference;

public class GL3DModel
extends BasePointOverlay {
    private IglModel mModel;
    private GL3DModelOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private Object object;

    public GL3DModel(IglModel iglModel) {
        super("");
        this.mModel = iglModel;
    }

    public GL3DModel(IGlOverlayLayer iGlOverlayLayer, GL3DModelOptions gL3DModelOptions, String string2) {
        super(string2);
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = gL3DModelOptions;
    }

    public void setPosition(LatLng latLng) {
        try {
            if (this.mModel != null) {
                this.mModel.setPosition(latLng);
                return;
            }
            this.options.position(latLng);
            this.a();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setAngle(float f2) {
        try {
            if (this.mModel != null) {
                this.mModel.setRotateAngle(f2);
                return;
            }
            this.options.angle(f2);
            this.a();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public float getAngle() {
        try {
            if (this.mModel != null) {
                return this.mModel.getRotateAngle();
            }
            return this.options.getAngle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    public LatLng getPosition() {
        try {
            if (this.mModel != null) {
                return this.mModel.getPosition();
            }
            return this.options.getLatLng();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getId() {
        try {
            if (this.mModel != null) {
                return this.mModel.getId();
            }
            return this.overlayName;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void setAnimation(Animation animation) {
        try {
            if (this.mModel != null) {
                this.mModel.setAnimation(animation);
                return;
            }
            this.a("setAnimation", new Object[]{animation});
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean startAnimation() {
        if (this.mModel != null) {
            return this.mModel.startAnimation();
        }
        Object object = this.a("startAnimation", null);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public void setModelFixedLength(int n2) {
        try {
            if (this.mModel != null) {
                this.mModel.setModelFixedLength(n2);
                return;
            }
            this.options.setModelFixedLength(n2);
            this.a();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void remove() {
        try {
            if (this.mModel != null) {
                this.mModel.remove();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                iGlOverlayLayer.removeOverlay(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean isVisible() {
        try {
            if (this.mModel != null) {
                return this.mModel.isVisible();
            }
            return this.options.isVisible();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.mModel != null) {
                this.mModel.setVisible(bl2);
                return;
            }
            this.options.setVisible(bl2);
            this.a();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setObject(Object object) {
        try {
            if (this.mModel != null) {
                this.mModel.setObject(object);
                return;
            }
            this.object = object;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public Object getObject() {
        if (this.mModel != null) {
            return this.mModel.getObject();
        }
        return this.object;
    }

    public void setRotateAngle(float f2) {
        try {
            this.setAngle(f2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public float getRotateAngle() {
        try {
            return this.getAngle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    public void setZoomLimit(float f2) {
        if (this.mModel != null) {
            this.mModel.setZoomLimit(f2);
        }
    }

    public void destroy() {
        if (this.mModel != null) {
            this.mModel.destroy();
            return;
        }
        this.remove();
    }

    public void setGeoPoint(IPoint iPoint) {
        if (this.mModel != null) {
            this.mModel.setGeoPoint(iPoint);
        }
    }

    public void setTitle(String string2) {
        if (this.mModel != null) {
            this.mModel.setTitle(string2);
            return;
        }
        if (this.options != null) {
            this.options.title(string2);
            this.a();
        }
    }

    public String getTitle() {
        try {
            if (this.mModel != null) {
                return this.mModel.getTitle();
            }
            if (this.options != null) {
                return this.options.getTitle();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public String getSnippet() {
        try {
            if (this.mModel != null) {
                return this.mModel.getSnippet();
            }
            if (this.options != null) {
                return this.options.getSnippet();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public void setSnippet(String string2) {
        if (this.mModel != null) {
            this.mModel.setSnippet(string2);
            return;
        }
        if (this.options != null) {
            this.options.snippet(string2);
            this.a();
        }
    }

    public void showInfoWindow() {
        try {
            if (this.mModel != null) {
                this.mModel.showInfoWindow();
                return;
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                iGlOverlayLayer.showInfoWindow(this.overlayName);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public boolean isInfoWindowEnable() {
        return true;
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null && iGlOverlayLayer != null) {
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private Object a(String string2, Object[] objectArray) {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                return iGlOverlayLayer.getNativeProperties(this.overlayName, string2, objectArray);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

