/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.widget.FrameLayout;
import com.amap.api.mapcore.util.ea;
import com.amap.api.mapcore.util.er;
import com.amap.api.mapcore.util.ew;
import com.amap.api.mapcore.util.ex;
import com.amap.api.mapcore.util.t;
import com.amap.api.maps.model.BitmapDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;

public final class BitmapDescriptorFactory {
    private static final String ICON_ID_PREFIX = "com.amap.api.icon_";
    private static int nextId = 0;
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;

    public static BitmapDescriptor fromResource(int n2) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                return BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(n2)));
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            er.a(throwable);
            ex.b(ew.f, "read bitmap from res failed " + throwable2.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromView(View view) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                context = new FrameLayout(context);
                context.addView(view);
                context.setDrawingCacheEnabled(true);
                return BitmapDescriptorFactory.fromBitmap(er.a((View)context));
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            er.a(throwable);
            ex.b(ew.f, "read bitmap from view failed " + throwable2.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromPath(String object) {
        try {
            return BitmapDescriptorFactory.fromBitmap(BitmapFactory.decodeFile((String)object));
        }
        catch (Throwable throwable) {
            object = throwable;
            er.a(throwable);
            ex.b(ew.f, "read bitmap from disk failed " + ((Throwable)object).getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromAsset(String object) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                return BitmapDescriptorFactory.fromBitmap(er.a(context, (String)object));
            }
            object = BitmapDescriptorFactory.class.getResourceAsStream("/assets/".concat(String.valueOf(object)));
            context = BitmapFactory.decodeStream((InputStream)object);
            ((InputStream)object).close();
            return BitmapDescriptorFactory.fromBitmap((Bitmap)context);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            er.a(throwable);
            ex.b(ew.f, "read bitmap from assets failed " + throwable2.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor fromFile(String object) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                object = context.openFileInput((String)object);
                context = BitmapFactory.decodeStream((InputStream)object);
                ((FileInputStream)object).close();
                object = BitmapDescriptorFactory.fromBitmap((Bitmap)context);
                er.c((Bitmap)context);
                return object;
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            er.a(throwable);
            ex.b(ew.f, "read bitmap from disk failed " + throwable2.getMessage());
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker() {
        try {
            return BitmapDescriptorFactory.fromAsset(ea.a.b.name() + ".png");
        }
        catch (Throwable throwable) {
            er.a(throwable);
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker(float f2) {
        try {
            float f3;
            f2 = (int)(f2 + 15.0f) / 30 * 30;
            if (f3 > 330.0f) {
                f2 = 330.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            String string2 = "";
            if (f2 == 0.0f) {
                string2 = "RED";
            } else if (f2 == 30.0f) {
                string2 = "ORANGE";
            } else if (f2 == 60.0f) {
                string2 = "YELLOW";
            } else if (f2 == 120.0f) {
                string2 = "GREEN";
            } else if (f2 == 180.0f) {
                string2 = "CYAN";
            } else if (f2 == 210.0f) {
                string2 = "AZURE";
            } else if (f2 == 240.0f) {
                string2 = "BLUE";
            } else if (f2 == 270.0f) {
                string2 = "VIOLET";
            } else if (f2 == 300.0f) {
                string2 = "MAGENTA";
            } else if (f2 == 330.0f) {
                string2 = "ROSE";
            }
            return BitmapDescriptorFactory.fromAsset(string2 + ".png");
        }
        catch (Throwable throwable) {
            er.a(throwable);
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        try {
            if (nextId == Integer.MAX_VALUE) {
                nextId = 0;
            }
            String string2 = ICON_ID_PREFIX + ++nextId;
            return new BitmapDescriptor(bitmap, string2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            er.a(throwable);
            ex.b(ew.f, "read bitmap from bitmap failed " + throwable2.getMessage());
            return null;
        }
    }

    public static Context getContext() {
        return t.a;
    }
}

