/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.content.Context;
import com.amap.api.mapcore.util.ag;
import com.amap.api.mapcore.util.ek;
import com.amap.api.mapcore.util.ep;
import com.amap.api.mapcore.util.hn;
import com.amap.api.maps.model.LatLng;

public class CoordinateConverter {
    private static final String TAG = "CoordinateConverter";
    private Context ctx;
    private CoordType coordType = null;
    private LatLng sourceLatLng = null;

    public CoordinateConverter(Context context) {
        this.ctx = context;
    }

    public CoordinateConverter from(CoordType coordType) {
        this.coordType = coordType;
        return this;
    }

    public CoordinateConverter coord(LatLng latLng) {
        this.sourceLatLng = latLng;
        return this;
    }

    public LatLng convert() {
        if (this.coordType == null) {
            return null;
        }
        if (this.sourceLatLng == null) {
            return null;
        }
        LatLng latLng = null;
        try {
            String string2 = "";
            switch (this.coordType) {
                case BAIDU: {
                    latLng = ag.a(this.sourceLatLng);
                    string2 = "baidu";
                    break;
                }
                case MAPBAR: {
                    latLng = ag.b(this.ctx, this.sourceLatLng);
                    string2 = "mapbar";
                    break;
                }
                case MAPABC: {
                    string2 = "mapabc";
                    latLng = this.sourceLatLng;
                    break;
                }
                case SOSOMAP: {
                    string2 = "sosomap";
                    latLng = this.sourceLatLng;
                    break;
                }
                case ALIYUN: {
                    string2 = "aliyun";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GOOGLE: {
                    string2 = "google";
                    latLng = this.sourceLatLng;
                    break;
                }
                case GPS: {
                    string2 = "gps";
                    latLng = ag.a(this.ctx, this.sourceLatLng);
                }
            }
            ep.a(this.ctx, string2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            hn.c(throwable2, TAG, "convert");
            latLng = this.sourceLatLng;
        }
        return latLng;
    }

    public static boolean isAMapDataAvailable(double d2, double d3) {
        return ek.a(d2, d3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordType {
        BAIDU,
        MAPBAR,
        GPS,
        MAPABC,
        SOSOMAP,
        ALIYUN,
        GOOGLE;

    }
}

