/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.graphics.Point;
import android.util.Log;
import com.amap.api.mapcore.util.ab;
import com.amap.api.mapcore.util.ac;
import com.amap.api.mapcore.util.ad;
import com.amap.api.mapcore.util.af;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.AbstractCameraUpdateMessage;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;

public final class CameraUpdateFactory {
    private static final String CLASSNAME = "CameraUpdateFactory";

    public static CameraUpdate zoomIn() {
        return new CameraUpdate(af.a());
    }

    public static CameraUpdate zoomOut() {
        return new CameraUpdate(af.b());
    }

    public static CameraUpdate scrollBy(float f2, float f3) {
        ad ad2 = new ad();
        new ad().nowType = AbstractCameraUpdateMessage.Type.scrollBy;
        ad2.xPixel = f2;
        ad2.yPixel = f3;
        return new CameraUpdate(ad2);
    }

    public static CameraUpdate zoomTo(float f2) {
        return new CameraUpdate(af.a(f2));
    }

    public static CameraUpdate zoomBy(float f2) {
        return new CameraUpdate(af.a(f2, null));
    }

    public static CameraUpdate zoomBy(float f2, Point point) {
        return new CameraUpdate(af.a(f2, point));
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        if (cameraPosition == null) {
            Log.w((String)CLASSNAME, (String)"cameraPosition is null");
            return new CameraUpdate(new ac());
        }
        return new CameraUpdate(af.a(cameraPosition));
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        if (latLng == null) {
            Log.w((String)CLASSNAME, (String)"latLng is null");
            return new CameraUpdate(new ac());
        }
        return new CameraUpdate(af.a(CameraPosition.builder().target(latLng).zoom(Float.NaN).bearing(Float.NaN).tilt(Float.NaN).build()));
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f2) {
        if (latLng == null) {
            Log.w((String)CLASSNAME, (String)"target is null");
            return new CameraUpdate(new ac());
        }
        return new CameraUpdate(af.a(latLng, f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        if (latLngBounds == null) {
            Log.w((String)CLASSNAME, (String)"bounds is null");
            return new CameraUpdate(new ac());
        }
        return new CameraUpdate(af.a(latLngBounds, n2));
    }

    public static CameraUpdate changeLatLng(LatLng latLng) {
        if (latLng == null) {
            Log.w((String)CLASSNAME, (String)"target is null");
            return new CameraUpdate(new ac());
        }
        latLng = VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20);
        return new CameraUpdate(af.a((Point)latLng));
    }

    public static CameraUpdate changeBearing(float f2) {
        return new CameraUpdate(af.c(f2 % 360.0f));
    }

    public static CameraUpdate changeBearingGeoCenter(float f2, IPoint object) {
        if (object == null) {
            Log.w((String)CLASSNAME, (String)"geoPoint is null");
            return new CameraUpdate(new ac());
        }
        object = new Point(((IPoint)object).x, ((IPoint)object).y);
        ac ac2 = new ac();
        new ac().nowType = AbstractCameraUpdateMessage.Type.newCameraPosition;
        ac2.geoPoint = object = new DPoint(((Point)object).x, ((Point)object).y);
        ac2.bearing = f2 %= 360.0f;
        return new CameraUpdate(ac2);
    }

    public static CameraUpdate changeTilt(float f2) {
        return new CameraUpdate(af.b(f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        if (latLngBounds == null) {
            Log.w((String)CLASSNAME, (String)"bounds is null");
            return new CameraUpdate(new ac());
        }
        ab ab2 = new ab();
        new ab().nowType = AbstractCameraUpdateMessage.Type.newLatLngBoundsWithSize;
        ab2.bounds = latLngBounds;
        ab2.paddingLeft = n4;
        ab2.paddingRight = n4;
        ab2.paddingTop = n4;
        ab2.paddingBottom = n4;
        ab2.width = n2;
        ab2.height = n3;
        return new CameraUpdate(ab2);
    }

    public static CameraUpdate newLatLngBoundsRect(LatLngBounds latLngBounds, int n2, int n3, int n4, int n5) {
        if (latLngBounds == null) {
            Log.w((String)CLASSNAME, (String)"bounds is null");
            return new CameraUpdate(new ac());
        }
        ab ab2 = new ab();
        new ab().nowType = AbstractCameraUpdateMessage.Type.newLatLngBounds;
        ab2.bounds = latLngBounds;
        ab2.paddingLeft = n2;
        ab2.paddingRight = n3;
        ab2.paddingTop = n4;
        ab2.paddingBottom = n5;
        return new CameraUpdate(ab2);
    }
}

