/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.amap.api.mapcore.util.gi;
import com.amap.api.mapcore.util.gj;
import com.amap.api.mapcore.util.gl;
import com.amap.api.mapcore.util.gt;
import com.amap.api.mapcore.util.l;
import com.amap.api.maps.AMapException;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.NaviPara;
import com.amap.api.maps.model.PoiPara;
import com.amap.api.maps.model.RoutePara;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMapUtils {
    private static final String AMAPNAVIURL = "androidamap://navi?sourceApplication=%s&lat=%f&lon=%f&dev=0&style=%d";
    private static final String AMAPPOISEARCHURL = "androidamap://arroundpoi?sourceApplication=%s&keywords=%s&dev=0";
    private static final String AMAPROUTEURL = "androidamap://route?sourceApplication=%s&slat=%f&slon=%f&sname=%s&dlat=%f&dlon=%f&dname=%s&dev=0&t=%d";
    private static final int TRANSIT_ROUTE_MODEL = 1;
    private static final int DRING_ROUTE_MODEL = 2;
    public static final int DRIVING_DEFAULT = 0;
    public static final int DRIVING_SAVE_MONEY = 1;
    public static final int DRIVING_SHORT_DISTANCE = 2;
    public static final int DRIVING_NO_HIGHWAY = 3;
    public static final int DRIVING_AVOID_CONGESTION = 4;
    public static final int DRIVING_NO_HIGHWAY_AVOID_SHORT_MONEY = 5;
    public static final int DRIVING_NO_HIGHWAY_AVOID_CONGESTION = 6;
    public static final int DRIVING_SAVE_MONEY_AVOID_CONGESTION = 7;
    public static final int DRIVING_NO_HIGHWAY_SAVE_MONEY_AVOID_CONGESTION = 8;
    public static final int BUS_TIME_FIRST = 0;
    public static final int BUS_MONEY_LITTLE = 1;
    public static final int BUS_TRANSFER_LITTLE = 2;
    public static final int BUS_WALK_LITTLE = 3;
    public static final int BUS_COMFORT = 4;
    public static final int BUS_NO_SUBWAY = 5;
    private static final double EARTHRADIUS = 6378137.0;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double R = 6378137.0;
    private static final double NF_PI = 0.01745329251994329;

    public static float calculateLineDistance(LatLng object, LatLng object2) {
        if (object == null || object2 == null) {
            try {
                throw new AMapException("\u975e\u6cd5\u5750\u6807\u503c");
            }
            catch (AMapException aMapException) {
                aMapException.printStackTrace();
                return 0.0f;
            }
        }
        try {
            double d2 = ((LatLng)object).longitude;
            double d3 = ((LatLng)object).latitude;
            double d4 = ((LatLng)object2).longitude;
            double d5 = ((LatLng)object2).latitude;
            d4 *= 0.01745329251994329;
            d5 *= 0.01745329251994329;
            double d6 = Math.sin(d2 *= 0.01745329251994329);
            double d7 = Math.sin(d3 *= 0.01745329251994329);
            double d8 = Math.cos(d2);
            double d9 = Math.cos(d3);
            double d10 = Math.sin(d4);
            double d11 = Math.sin(d5);
            double d12 = Math.cos(d4);
            double d13 = Math.cos(d5);
            object = new double[3];
            object2 = new double[3];
            object[0] = d9 * d8;
            object[1] = d9 * d6;
            object[2] = d7;
            object2[0] = d13 * d12;
            object2[1] = d13 * d10;
            object2[2] = d11;
            return (float)(Math.asin(Math.sqrt((double)((object[0] - object2[0]) * (object[0] - object2[0]) + (object[1] - object2[1]) * (object[1] - object2[1]) + (object[2] - object2[2]) * (object[2] - object2[2]))) / 2.0) * 1.27420015798544E7);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public static float calculateArea(LatLng latLng, LatLng latLng2) {
        if (latLng == null || latLng2 == null) {
            try {
                throw new AMapException("\u975e\u6cd5\u5750\u6807\u503c");
            }
            catch (AMapException aMapException) {
                aMapException.printStackTrace();
                return 0.0f;
            }
        }
        try {
            double d2;
            double d3 = Math.sin(latLng.latitude * Math.PI / 180.0) - Math.sin(latLng2.latitude * Math.PI / 180.0);
            double d4 = (latLng2.longitude - latLng.longitude) / 360.0;
            if (d2 < 0.0) {
                d4 += 1.0;
            }
            return (float)(2.5560394669790553E14 * d3 * d4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public static float calculateArea(List<LatLng> list) {
        if (list == null || list.size() < 3) {
            return 0.0f;
        }
        double d2 = 0.0;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            LatLng latLng = list.get(i2);
            LatLng latLng2 = list.get((i2 + 1) % n2);
            double d3 = latLng.longitude * 111319.49079327357 * Math.cos(latLng.latitude * (Math.PI / 180));
            double d4 = latLng.latitude * 111319.49079327357;
            double d5 = latLng2.longitude * 111319.49079327357 * Math.cos(latLng2.latitude * (Math.PI / 180));
            double d6 = latLng2.latitude * 111319.49079327357;
            d2 += d3 * d6 - d5 * d4;
        }
        return Math.abs((float)(d2 / 2.0));
    }

    public static void getLatestAMapApp(Context context) {
        try {
            String string2 = "http://wap.amap.com/";
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10800000);
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)string2));
            new a("glaa", context).start();
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static void openAMapNavi(NaviPara naviPara, Context context) throws AMapException {
        if (AMapUtils.a(context)) {
            if (naviPara.getTargetPoint() != null) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.addFlags(0x10800000);
                    intent.addCategory("android.intent.category.DEFAULT");
                    Context context2 = context;
                    intent.setData(Uri.parse((String)String.format(Locale.US, AMAPNAVIURL, gj.b(context2), naviPara.getTargetPoint().latitude, naviPara.getTargetPoint().longitude, naviPara.getNaviStyle())));
                    intent.setPackage("com.autonavi.minimap");
                    new a("oan", context).start();
                    context.startActivity(intent);
                    return;
                }
                catch (Throwable throwable) {
                    throw new AMapException("\u79fb\u52a8\u8bbe\u5907\u4e0a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe\u6216\u9ad8\u5fb7\u5730\u56fe\u7248\u672c\u8f83\u65e7");
                }
            }
            throw new AMapException("\u975e\u6cd5\u53c2\u6570");
        }
        throw new AMapException("\u79fb\u52a8\u8bbe\u5907\u4e0a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe\u6216\u9ad8\u5fb7\u5730\u56fe\u7248\u672c\u8f83\u65e7");
    }

    public static void openAMapPoiNearbySearch(PoiPara poiPara, Context context) throws AMapException {
        if (AMapUtils.a(context)) {
            if (poiPara.getKeywords() != null && poiPara.getKeywords().trim().length() > 0) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.addFlags(0x10800000);
                    intent.addCategory("android.intent.category.DEFAULT");
                    Object object = context;
                    object = String.format(Locale.US, AMAPPOISEARCHURL, gj.b(object), poiPara.getKeywords());
                    if (poiPara.getCenter() != null) {
                        object = (String)object + "&lat=" + poiPara.getCenter().latitude + "&lon=" + poiPara.getCenter().longitude;
                    }
                    intent.setData(Uri.parse((String)object));
                    intent.setPackage("com.autonavi.minimap");
                    new a("oan", context).start();
                    context.startActivity(intent);
                    return;
                }
                catch (Throwable throwable) {
                    throw new AMapException("\u79fb\u52a8\u8bbe\u5907\u4e0a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe\u6216\u9ad8\u5fb7\u5730\u56fe\u7248\u672c\u8f83\u65e7");
                }
            }
            throw new AMapException("\u975e\u6cd5\u53c2\u6570");
        }
        throw new AMapException("\u79fb\u52a8\u8bbe\u5907\u4e0a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe\u6216\u9ad8\u5fb7\u5730\u56fe\u7248\u672c\u8f83\u65e7");
    }

    public static void openAMapDrivingRoute(RoutePara routePara, Context context) throws AMapException {
        AMapUtils.a(routePara, context, 2);
    }

    public static void openAMapTransitRoute(RoutePara routePara, Context context) throws AMapException {
        AMapUtils.a(routePara, context, 1);
    }

    public static void openAMapWalkingRoute(RoutePara routePara, Context context) throws AMapException {
        AMapUtils.a(routePara, context, 4);
    }

    private static void a(RoutePara routePara, Context context, int n2) throws AMapException {
        if (AMapUtils.a(context)) {
            if (AMapUtils.a(routePara)) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.addFlags(0x10800000);
                    intent.addCategory("android.intent.category.DEFAULT");
                    intent.setData(Uri.parse((String)AMapUtils.b(routePara, context, n2)));
                    intent.setPackage("com.autonavi.minimap");
                    new a("oan", context).start();
                    context.startActivity(intent);
                    return;
                }
                catch (Throwable throwable) {
                    throw new AMapException("\u79fb\u52a8\u8bbe\u5907\u4e0a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe\u6216\u9ad8\u5fb7\u5730\u56fe\u7248\u672c\u8f83\u65e7");
                }
            }
            throw new AMapException("\u975e\u6cd5\u53c2\u6570");
        }
        throw new AMapException("\u79fb\u52a8\u8bbe\u5907\u4e0a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe\u6216\u9ad8\u5fb7\u5730\u56fe\u7248\u672c\u8f83\u65e7");
    }

    private static boolean a(RoutePara routePara) {
        return routePara.getStartPoint() != null && routePara.getEndPoint() != null && routePara.getStartName() != null && routePara.getStartName().trim().length() > 0 && routePara.getEndName() != null && routePara.getEndName().trim().length() > 0;
    }

    private static String b(RoutePara routePara, Context object, int n2) {
        object = String.format(Locale.US, AMAPROUTEURL, gj.b(object), routePara.getStartPoint().latitude, routePara.getStartPoint().longitude, routePara.getStartName(), routePara.getEndPoint().latitude, routePara.getEndPoint().longitude, routePara.getEndName(), n2);
        if (n2 == 1) {
            object = (String)object + "&m=" + routePara.getTransitRouteStyle();
        } else if (n2 == 2) {
            object = (String)object + "&m=" + routePara.getDrivingRouteStyle();
        }
        return object;
    }

    private static boolean a(Context context) {
        try {
            context = context.getPackageManager().getPackageInfo("com.autonavi.minimap", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        return context != null;
    }

    static final class a
    extends Thread {
        String a = "";
        Context b;

        public a(String string2, Context context) {
            this.a = string2;
            if (context != null) {
                this.b = context.getApplicationContext();
            }
        }

        public final void run() {
            if (this.b != null) {
                try {
                    gt gt2 = new gt.a(this.a, "7.9.1", l.c).a(new String[]{"com.amap.api.maps"}).a();
                    gl.a(this.b, gt2);
                    this.interrupt();
                    return;
                }
                catch (gi gi2) {
                    gi2.printStackTrace();
                }
            }
        }
    }
}

