//
//  UEPTouchEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPBehaviorEvent.h"

NS_ASSUME_NONNULL_BEGIN

//Touch事件， 辅助检测无效区域点击用 ， 只上报(touchStart, touchEnd)
@interface UEPTouchEvent : UEPBehaviorEvent

//必填参数
@property (nonatomic, assign) UEPTouchEventType type;      //开始、结束

//必填参数 , Native 通过[UEPUtil xPathForView:view] 获取
@property (nonatomic, copy) NSString           *xPath;     //控件路径（xPath）

//必填参数， Native 通过[UEPUtil hashCodeStringForView:view] 获取
// @property (nonatomic, copy) NSString           *target;    //控件实例标识（Hash Code）

//必填参数
@property (nonatomic, assign) CGPoint           point;     //touch坐标点

//选填参数
@property (nonatomic, copy) NSString           *entityId;     //业务控件标识

@end

NS_ASSUME_NONNULL_END
