//
//  UEPPlayEvent.h
//  uep
//
//  Created by JL on 2020/11/13.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <uep/uep.h>
#import "UEPBehaviorEvent.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPPlayEvent : UEPBehaviorEvent

//必填参数， Native 通过[UEPUtil hashCodeStringForView:view] 获取
// @property (nonatomic, copy) NSString          *target;       //控件实例标识（Hash Code）

@property (nonatomic, copy) NSString        *xPath;         //控件路径（xPath）

@property (nonatomic, assign) UEPPlayState  playState;      // 播放状态
@property (nonatomic, assign) UEPMediaType  mediaType;      // 媒体类型
@property (nonatomic, assign) long long     mediaTime;      // 媒体总时间，单位毫秒
@property (nonatomic, assign) long long     playTime;       // 播放进度时间，单位毫秒
@property (nonatomic, assign) long long     mediaPlayTime;  // 播放时长，单位毫秒，业务透传
@property (nonatomic, assign) float         playSpeed;      // 播放倍速
@property (nonatomic, copy) NSString        *mediaSrc;      // 媒体源
@property (nonatomic, copy) NSString        *playScene;     // 播放场景，对应bizId
@property (nonatomic, copy) NSString        *spm;           // SPM
@property (nonatomic, copy) NSString        *scm;           // SCM
@property (nonatomic, strong) NSDictionary  *params;        // 业务扩展参数
@property (nonatomic, copy) NSString        *entityId;      // 业务控件标识

@end

NS_ASSUME_NONNULL_END
