//
//  UEPOperator.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPEvent.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPOperator : NSObject

@property (nonatomic, assign) UEPEventType dealTypes; //通过位异或(UEPEventType)，可以处理多个类型事件

- (UEPEventType)defaultSupportDealTypes;

@end


@protocol UEPSortOperatorProtocol <NSObject>

@required
- (NSArray<UEPEvent*>*)sortEvents:(NSArray<UEPEvent*>*)events;

@end

@protocol UEPFilterOperatorProtocol <NSObject>

@required
//是否过滤当前事件，YES为过滤掉当前事件
- (BOOL)filterEvent:(UEPEvent*)event;

@end


// 逻辑算子要实现此协议，否则注册不上
@protocol UEPProcessOperatorProtocol <NSObject>

@required
- (void)processEvent:(UEPEvent*)event;

@end


NS_ASSUME_NONNULL_END
