//
//  UEPMiningEvent.h
//  uep
//
//  Created by 浪浪 on 2022/3/24.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <uep/uep.h>

NS_ASSUME_NONNULL_BEGIN

// 前端页面分析事件
@interface UEPMiningEvent : UEPEvent

@property(nonatomic, strong)NSString *appId;

@property(nonatomic, strong)NSString *appName;

@property(nonatomic, strong)NSString *version;

@property(nonatomic, strong)NSString *url;

@property(nonatomic, strong)NSString *timing;

@property(nonatomic, assign)BOOL pageDisappeared;

@property(nonatomic, strong)NSDictionary *extraData;

@property(nonatomic, assign)BOOL dataFormated;      // 数据是否格式化

@property(nonatomic, assign)BOOL isMainPage;        // 是否是主页

// 可复用本次采集数据的场景集合，即定义中的taskName集合, 如 ["EM_IndexingAlipay","EMTest"]
@property(nonatomic, strong)NSArray<NSString *> *scenes;

// <场景名称:子场景名称>，若场景或子场景为空，则无需添加该场景映射, 如 {"EM_IndexingAlipay" : "33scene_goverment"}
@property(nonatomic, strong)NSDictionary<NSString *, NSString *> *sceneMap;

// 采集文案的scope, 参考 子项白名单中 contentScope配置定义
@property(nonatomic, strong)NSDictionary<NSString *, NSArray<NSString *> *> *scope;

// Int    最大文案长度
@property(nonatomic, assign)NSInteger maxTextLen;

// UEP类型，Dom, Snapshot, Http  10.3.20支持
@property(nonatomic, strong)NSString *dataType;

// 数据压缩类型, 仅针对Dom有效     10.3.20支持
@property(nonatomic, strong)NSString *compressType;
@end

NS_ASSUME_NONNULL_END
