//
//  UEPJSApiEvent.h
//  uep
//
//  Created by 浪浪 on 2022/3/28.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <uep/uep.h>
//#import <AriverCore/RVKContext.h>

NS_ASSUME_NONNULL_BEGIN

@interface UEPJSApiEvent : UEPEvent

@property(nonatomic, strong)NSString *appId;

@property(nonatomic, strong)NSString *url;

@property(nonatomic, strong)NSString *apiName;

@property(nonatomic, assign)NSInteger staytime;

@property(nonatomic, assign)BOOL firstCall;             // 当前页面首次调用此api

@property(nonatomic, assign)NSInteger errorCode;        //错误码，0表示成功，非0否表示错误

@property(nonatomic, strong)NSString *errorStr;         //错误描述

@property(nonatomic, assign)BOOL        needDetail;     // 上报明细总开关，为关时直接过滤，不管是否有出入参明细keys

@property(nonatomic, assign)BOOL        needDetailErr;    //是否明细上报错误信息

@property(nonatomic, strong)NSDictionary *inParams;        //入参信息
@property(nonatomic, strong)NSDictionary *outParams;    // 出参信息

@property(nonatomic, strong)NSArray<NSString *>    *needInParamsKeys;    // 明细上报入参keys,为空不上报
@property(nonatomic, strong)NSArray<NSString *>    *needOutParamsKeys;    // 明细上报出参keys,为空不上报

@property(nonatomic, strong)NSString *page_token;       // 怕属页面标识，对应pageEvent.subPageToken

- (instancetype)initWithPageHash:(NSUInteger)hashCode DEPRECATED_MSG_ATTRIBUTE("10.2.63 Method is DEPRECATED,please use method [UEPJSApiEvent initWithPageContext:]");

//- (instancetype)initWithPageContext:(PSDContext *)pageContext;

- (instancetype)initWithPageToken:(NSString *)pageToken;

//+ (NSString *)getPageTokenWithContext:(PSDContext *)pageContext;

@end

NS_ASSUME_NONNULL_END
