//
//  UEPExposureEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPBehaviorEvent.h"
#import "UEPBehaviorProtocol.h"
#import "UEPExposureItem.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPExposureEvent : UEPBehaviorEvent<UEPActionProtocol>

//必填参数 , Native 通过[UEPUtil xPathForView:view] 获取
@property (nonatomic, copy) NSString           *xPath;              //曝光控件路径（xPath）
@property (nonatomic, assign) NSInteger        exposurePercent;     //曝光百分比（0-100）
@property (nonatomic, assign) UEPExposureState exposureState;       //曝光状态（开始、结束）

//选填参数
@property (nonatomic, copy) NSString           *spm;                //SPM
@property (nonatomic, copy) NSString           *scm;                //SCM
@property (nonatomic, strong) NSDictionary     *param;              //业务扩展参数
@property (nonatomic, strong) NSData           *bizInfo;            //业务schema化扩展参数
@property (nonatomic, copy) NSString           *eventId;            //业务schema化 对应eventId
@property (nonatomic, copy) NSString           *entityId;           //业务控件标识

@property (nonatomic, assign) BOOL             needCleanFromPage;   // 完成曝光后是否从页面缓存中清除，默认否，主要用于：控件隐藏，控件提前removefromsuperview
@property (nonatomic, assign) BOOL             exposeOnce;          // 强制立刻且只曝光一次
@property (atomic, assign) BOOL                clicked;             // 是否点击过 10.2.53, 需要事件消费侧被修改，需要实现线程安全的set/get
@property (nonatomic, strong) NSString         *selector;           // 前端选择器，前端组件才有 10.2.53
@property (nonatomic, strong) NSString         *text;               // 文案采集 10.2.60
@property (nonatomic, strong) NSString         *srcPageHash;        // 初始page hash值
@property (nonatomic, strong) NSArray<UEPExposureItem *> *exposureItems;      // 绑定批量曝光
@property (nonatomic, assign) BOOL             noBindPage;          // 不绑定页面

+ (BOOL)enableLogExposeWithSpm:(NSString *)spm;
- (NSString *)state;

@end

NS_ASSUME_NONNULL_END
