//
//  UEPEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <APProtocolBuffers/ProtocolBuffers.h>

@class APDPBGeneratedMessage;

NS_ASSUME_NONNULL_BEGIN


typedef enum {
    UEPageTypeNone = 0, // "none"
    UEPageTypeNative,   // "native"
    UEPageTypeH5,       // "h5"
    UEPageTypeTiny,     // "tiny"
} UEPageType;

typedef enum {
    UEPageStateNone = 0,
    UEPageStateAppear,
    UEPageStateDisAppear,
    UEPageStateBack,       //H5/小程序 采集
    UEPageStateDestroy,
} UEPageState;

typedef enum {
    UEPScrollStateNone = 0,
    UEPScrollStateBegin,
    UEPScrollStateEnd,
} UEPScrollState;

typedef enum {
    UEPScrollDirectionNone = 0,
    UEPScrollDirectionVertical,
    UEPScrollDirectionHorizontal,
} UEPScrollDirection;

typedef enum {
    UEPExposureStateNone = 0,
    UEPExposureStateStart,
    UEPExposureStateEnd,
} UEPExposureState;

typedef enum {
    UEPInputTypeNone = 0,   // “none”
    UEPInputTypeText,       // 单行文本输入 “text”
    UEPInputTypeTextArea,   // 多行文本输入 "textarea"
    UEPInputTypeSelect,     // 下拉选择 "select"
    UEPInputTypeRadio,      // 单选按钮 "radio"
    UEPInputTypeCheckBox,   // 多选按钮 "checkbox"
    UEPInputTypeSwitch,     // 开关按钮 "switch"
} UEPInputType;

typedef enum {
    UEPTouchEventNone = 0,
    UEPTouchEventStart,
    UEPTouchEventEnd,
} UEPTouchEventType;


typedef enum {
    UEPAppStatusNone = 0,
    UEPAppStatusEnterForground,
    UEPAppStatusEnterBackground
} UEPAppStatus;


typedef enum {
    UEPAppInNone = 0, // "none"
    UEPAppInScheme,   // "scheme"
    UEPAppInPush,     // "push"
    UEPAppInUlink,    // "ulink"
    UEPAppInWidget,   // "widget"
    UEPAppIn3Dtouch,  // "3dtouch"
} UEPAppInType;


typedef enum {
    UEPPushEventTypeNone = 0,
    UEPPushEventClickType,
} UEPPushEventType;

typedef enum {
    UEPPushChannelTypeNone = 0,
    UEPPushChannelTypeVendor,
    UEPPushChannelTypeBuildIn,
    UEPPushChannelTypeMix,
} UEPPushChannelType;


typedef NS_OPTIONS(UInt64,UEPEventType) {
  
    UEPEventNone               = 0,
    UEPEventClick              = 1ULL<<0,
    UEPEventTouch              = 1ULL<<1,
    UEPEventPage               = 1ULL<<2,
    UEPEventAppStatus          = 1ULL<<3,
    UEPEventExposure           = 1ULL<<4,
    UEPEventScroll             = 1ULL<<5,
    UEPEventInput              = 1ULL<<6,
    UEPEventAppIn              = 1ULL<<7,
    UEPEventAppOut             = 1ULL<<8,
    UEPEventRouterBlock        = 1ULL<<9,
    UEPEventStartApp           = 1ULL<<10,
    UEPEventPush               = 1ULL<<11,
    UEPEventScan               = 1ULL<<12,
    UEPEventPay                = 1ULL<<13,
    UEPEventSpm                = 1ULL<<14,
    UEPEventRpc                = 1ULL<<15,
    UEPEventTorch              = 1ULL<<16,
    UEPEventLbs                = 1ULL<<17,
    UEPEventPlay               = 1ULL<<18,
    UEPEventNodeSubmit         = 1ULL<<19,
    UEPEventVerify             = 1ULL<<20,
    UEPEventGesture            = 1ULL<<21,
    UEPEventPrompt             = 1ULL<<22,
    UEPEventShare              = 1ULL<<23,
    UEPEventTrigger            = 1ULL<<24,
    UEPEventRiskCall           = 1ULL<<25,
    
    UEPEventExposeLog          = 1ULL<<26,
    UEPEventPageOpenLog        = 1ULL<<27,
    UEPEventPageMonitorLog     = 1ULL<<28,
    UEPEventScrollLog          = 1ULL<<29,
    
    UEPEventWatermark          = 1ULL<<30,
    UEPEventMining             = 1ULL<<31,
    UEPEventJSApi              = 1ULL<<33,
    UEPEventAnt                = 1ULL<<34,
    UEPEventPerformance        = 1ULL<<35,
    UEPEventTaskLog            = 1ULL<<36,
    
    UEPEventKeyboard           = 1ULL<<37,
    UEPEventBack               = 1ULL<<38,
    UEPEventRender               = 1ULL<<39,
    
    UEPEventLoading              = 1ULL<<40,
    
    UEPEventMax                = 1ULL<<63,
};

typedef enum {
    UEPSpmTypeNone = 0,
    UEPSpmTypeNoneClick,
    UEPSpmTypeClick = UEPSpmTypeNoneClick,
    UEPSpmTypeExpo,
    UEPSpmTypeStartPage,
    UEPSpmTypeEndPage,
    UEPSpmTypeTracking,
    UEPSpmTypeDestroyPage,
    UEPTINYTypeStartPage,
    UEPTINYTypeEndPage,
    UEPTINYTypeTracking
}UEPSpmType;

typedef enum {
    UEPMediaTypeNone = 0,
    UEPMediaTypeVideo,
    UEPMediaTypeAudio
}UEPMediaType;

typedef enum {
    UEPPlayStateNone = 0,
    UEPPlayStateStart,
    UEPPlayStateRestart,
    UEPPlayStatePause,
    UEPPlayStateDrag,
    UEPPlayStateResume,
    UEPPlayStateError,
    UEPPlayStateEnd
}UEPPlayState;


@protocol UEPEventLogProtocol <NSObject>

@required

// 子类重写，生成事件日志
- (void)reportEventLog;

+ (UEPEventType)eventType;

+ (NSString *)behaviorType;

@optional
// 子类重写，本地打印日志输出
- (void)printEventLog;

// 声明事件支持的属性集合
- (NSSet *)getPropertysSet;

// 支持SSP/CEP计算属性定义
- (id)getEventProperty:(NSString *)key;

@end

@interface UEPEvent : NSObject<NSCopying, UEPEventLogProtocol>

- (NSString *)eventBehavior;

//必填参数
@property (nonatomic, assign) long long     timestamp; //事件发生时间戳（timeSince1970，单位ms）

//选填参数
@property (nonatomic, copy) NSString        *bizCode;  //业务码，选填

- (NSString *)currentUid;

- (UEPEventType)eventType;

- (NSString *)behaviorType;


// 定义AntMan输出标题，可重写
- (NSString * _Nonnull)eventTitle;

// 是否忽略antman，默认值：NO，不忽略
- (BOOL)skipAntmanLog;

// 1. CEP规则匹配输出事件会使用此方法格式化, 不必重写
// 2. AntMan会使用此方法输出UEP事件，并取key=name值标识, 可通过实现eventTitle自定义
- (NSDictionary *)toDictionary;

@end

#define UEPDefaultBizType (@"autoevent")
#define UEPDefaultBizGroup (@"autoevent")

#define kUepBehaviorTypePage       @"page"
#define kUepBehaviorTypeClick      @"click"

NS_ASSUME_NONNULL_END
