//
//  UEPConfigService.h
//  uep
//
//  Created by LiMengtian on 2019/12/24.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APConfig/APConfigService.h>

NS_ASSUME_NONNULL_BEGIN


@interface UEPConfigService : NSObject

/// 查询native页面采集配置
/// @param appId 应用Id
/// @param pageName 页面名
+ (nullable NSDictionary *)queryNativeConfigWithAppId:(NSString *)appId
                                             pageName:(NSString *)pageName;
/// 查询H5页面采集配置
/// @param appId 应用Id
/// @param version 版本号
/// @param url url地址
+ (nullable NSDictionary *)queryH5ConfigWithAppId:(NSString *)appId
                                            version:(NSString *)version
                                                url:(NSString *)url;

/// 查询小程序页面采集配置
/// @param appId 应用Id
/// @param version 版本号
+ (nullable NSDictionary *)queryTinyConfigWithAppId:(NSString *)appId
                                                version:(NSString *)version;

/// 查询Cube区块采集配置
/// @param appId 应用Id
/// @param version 版本号
/// @param xPath xPath
/// @param mouldId 模板Id

+ (nullable NSDictionary *)queryCubeConfigWithAppId:(NSString *)appId
                                            version:(NSString *)version
                                              xPath:(NSString *)xPath
                                            mouldId:(NSString *)mouldId;

//查询UEP总开关是否生效
+ (BOOL)queryUEPEnable;

+ (NSString*)v2ConfigString;
//点击串联
+ (BOOL)uepClickComputeEnable;
//页面串联
+ (BOOL)uepPageComputeEnable;

+ (BOOL)uepRedirectSpmTrackerEnable;

+ (BOOL)enablePromptWithCategory:(NSString *)promptCategory;

// 融合开关
+ (BOOL)uepIsCombineMode;

+ (BOOL)canExposureSpm:(NSString *)spm;

+ (BOOL)canExposureTSpm:(NSString *)spm text:(NSString *)text;

+ (BOOL)uepCombineWithApp:(NSString *)appId;
// AIX 开关
+ (NSArray *)uepAIXConfigValue;

+ (BOOL)enableFetchTitle;

+ (BOOL)uepIgnoreXpathClickCount:(NSString *)xpath;

+ (BOOL)enableSubPageLog:(NSString *)pageName;

+ (BOOL)boolValueForConfig:(NSString *)configKey;

+ (BOOL)boolValueForConfig:(NSString *)configKey defaultValue:(BOOL)defaultVal;

+ (BOOL)boolValueForConfig:(NSString *)configKey defaultValue:(BOOL)defaultVal useCache:(BOOL)cache;

+ (CGFloat)floatValueForConfig:(NSString *)configKey defaultValue:(CGFloat)defaultVal;

+ (long)longValueForConfig:(NSString *)configKey defaultValue:(long)defaultVal;

// 只返回array/map对象，获取字符串接口使用stringForConfig:
+ (id)objectValueForConfig:(NSString *)configKey;

+ (NSString *)stringForConfig:(NSString *)configKey;

+ (BOOL)configWithAppIdIsEnable:(NSString *)key;
+ (BOOL)configWithAppid:(NSString *)appId byKey:(NSString *) key;

+ (BOOL)checkExposureUpateForSpm:(NSString *)spm configKey:(NSString *)configKey defaultValue:(NSArray *)defaultValue;

/**
 曝光点击事件容器exinfo4参数
 */

+ (NSArray *)nebulaRemoteLogParamsList;
/**
 访问事件容器exinfo4参数
 */
+ (NSArray *)nebulaReportDataParamsList;

+ (BOOL)enableAutoVstManualSrc;

//是否写埋点日志
+ (BOOL)enableUepApplogForSpm:(NSString *)spm;

//uep切换时串联是否过滤
+ (BOOL)isUepReportSpmTrackerDistableContact:(NSString *)spm ext:(NSDictionary *)extParams;
+ (BOOL)isAutoPageDistableContact:(NSString *)spm;

@end

NS_ASSUME_NONNULL_END
