//
//  UEPClickEvent.h
//  uep
//
//  Created by 李春荣 on 2019/12/16.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import "UEPBehaviorEvent.h"
#import "UEPBehaviorProtocol.h"

NS_ASSUME_NONNULL_BEGIN

@interface UEPClickEvent : UEPBehaviorEvent <NSCopying, UEPActionProtocol>

//必填参数 , Native 通过[UEPUtil xPathForView:view] 获取
@property (nonatomic, copy) NSString           *xPath;        //控件路径（xPath）

//必填参数， Native 通过[UEPUtil hashCodeStringForView:view] 获取
//@property (nonatomic, copy) NSString           *target;       //控件实例标识（Hash Code）

//必填参数
@property (nonatomic, assign) CGPoint           point;        //点击坐标点


//选填参数
@property (nonatomic, copy) NSString           *text;         //点击文案（比如H5 点击A标签的链接）
//选填参数
@property (nonatomic, assign) BOOL             clickAble;     //是否无效点击(小程序场景能够识别 无效点击, 其它场景不用care这个字段)

//选填参数
@property (nonatomic, copy) NSString           *spm;          //SPM
//选填参数
@property (nonatomic, copy) NSString           *scm;          //SCM
//选填参数
@property (nonatomic, strong) NSDictionary     *param;        //业务扩展参数

//选填参数
@property (nonatomic, strong) NSData           *bizInfo;      //业务schema化扩展参数
//选填参数
@property (nonatomic, copy) NSString           *eventId;      //业务schema化 对应eventId

//选填参数
@property (nonatomic, copy) NSString           *entityId;     //业务控件标识

@property (nonatomic, assign) BOOL             isFromNebula;  //是否容器的点击

//选填参数
@property (nonatomic, strong) NSDictionary     *accessibilityInfo;   // 无障碍信息

@property (nonatomic, strong)NSString          *selector;// 前端选择器，前端点击才有

@end

NS_ASSUME_NONNULL_END
