//
//  UEPActNodeSession.h
//  uep
//
//  Created by 浪浪 on 2021/1/13.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import "UEPActBaseNode.h"

NS_ASSUME_NONNULL_BEGIN

/**
 行为链路根结点，每次冷启动或回到首页时更新，子节点是app Node
 */
@interface UEPActNodeSession : UEPActBaseNode

// 会话唯一标识
@property(nonatomic, strong, readonly)NSString *sessionSeq;

// 前次会话
@property(nonatomic, strong)NSString *referSessionSeq;

// 结束时间
@property(nonatomic, assign)long long endTimestamp;

// 唤端信息
@property(nonatomic, strong)NSMutableArray *startupsList;

// 前后台事件， 10.2.50新增
@property(nonatomic, strong)NSMutableArray *appStatusList;

- (instancetype)initWithSessionSeq:(NSString *)sessionSeq startTime:(NSTimeInterval)start;

- (NSArray *)appsList;

@end

NS_ASSUME_NONNULL_END
