//
//  UEPActNodeMgr.h
//  uep
//
//  Created by 浪浪 on 2021/1/13.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UEPActNodeSession.h"
#import "UEPActNodePage.h"
#import "UEPActMetaData.h"
#import "UEPActNodeClick.h"
#import "UEPActFilter.h"

@class UEPAppInEvent;
@class UEPPushEvent;
@class UEPAppStatusEvent;
@class UEPPageEvent;

NS_ASSUME_NONNULL_BEGIN

typedef enum {
    UEPReportForClick,
    UEPReportForBg,
    UEPReportForMaxNode,
    UEPReportForRestart,
    UEPReportForBgAtHome
} UEPReportType;

@interface UEPActNodeMgr : NSObject

+ (instancetype)sharedInstance;

@property(nonatomic, strong)UEPActNodeSession *preSessionNode;

@property(nonatomic, strong)UEPActNodeSession *curSessionNode;

@property (atomic, strong)UEPActNodeContext *context;

@property(nonatomic, strong)UEPActFilter *filter;

// 获取完整链路节点
- (NSArray<UEPActBaseNode *> *)getFullPath;

// 获取到当前访问节点的最短路径
- (NSArray<UEPActBaseNode *> *)getShortPath;

- (BOOL)enableNode;

// 输出标准的格式化路径，现只包括app/page/click节点
- (NSString *)getPathString;

// 当前页面唯一标识
- (NSString *)getCurrentPageSeq;

- (NSString *)getCurrentSceneSeq;

- (NSString *)getCurrentAppId;

- (NSString *)getCurrentUrl;

- (NSString *)getPathStringWithFilter:(UEPOutputFilter)filter;

- (BOOL)checkSessionWithClick:(UEPActNodeClick *)click;

- (BOOL)checkSessionWithBehaviorNode:(UEPActBaseNode *)behaviorNode;

- (BOOL)checkSessionWithCurrentPage;

// - (void)updateNodeSessionWithClick:(UEPActNodeClick *)click;

- (BOOL)insertNode:(UEPActBaseNode *)node withParentId:(nullable NSString *)parentId;

// 从指定位置开始寻找添加位置，相对上面方法startNode = sessionNode;
- (BOOL)insertNode:(UEPActBaseNode *)node withParentId:(nullable NSString *)parentId startPosition:(UEPActBaseNode *)startNode;

// 添加叶子节点到当前页，非叶子节点会添加失败
- (BOOL)addNodeToCurrentPage:(UEPActBaseNode *)node;

- (void)updatePageNode:(NSString *)page_seq event:(UEPPageEvent *)finishedEvent;

- (void)updateleafNode:(NSString*)node_seq event:(UEPEvent *)endEvent type:(UEPActNodeType)nodeType;

- (void)addStartupInfoWithAppIn:(UEPAppInEvent *)appin;

- (void)addStartupInfoWithPush:(UEPPushEvent *)appin;

- (void)addAppStatusToSession:(UEPActBaseNode *)bgfgNode;

// 刷新sesson进入后台或到达限下阀值
- (void)reportPartSession:(UEPReportType)reportType;

// 提交上次运行时缓存数据
- (BOOL)reportCacheSessionIfNeed;

- (void)archiveCurrentSession;

- (void)cleanArichiveData;

@end

NS_ASSUME_NONNULL_END
