//
//  UEPActBaseNode.h
//  uep
//
//  Created by 浪浪 on 2021/1/13.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UEPActUtils.h"

NS_ASSUME_NONNULL_BEGIN

// node节点树结构，参考：https://yuque.antfin-inc.com/mobile-infra/kidwx6/sewf1c
@class UEPActNodeContext;
@class UEPActNodeMgr;
@class APDPBGeneratedMessage;

@class UEPActBaseNode;
typedef BOOL(^UEPOutputFilter)(UEPActBaseNode *node, UEPActNodeType nodeType);

@interface UEPActBaseNode : NSObject<NSCopying>

// 和session一一对应，每生成一个session,session上的所有子节点的context是同一个对象
@property(nonatomic, strong)UEPActNodeContext *context;

// 父结点
//@property(nonatomic, weak)UEPActBaseNode *parentNode;

// 逻辑父节点，app/scene会有，从哪个page来的
@property(nonatomic, weak, readonly)UEPActBaseNode *referParentNode;

// 事件开始时间戳
@property(nonatomic, assign, readonly)long long timestamp;

//// 缓存访问tag，防止出现环情结构访问
//@property(nonatomic, strong)NSMutableArray *tagsList;

#pragma mark - 初始化
- (instancetype)init;

#pragma mark - 节点管理
// 把节点添加到合适的位置，不一定是入参节点的子节点，可能是更后序的子孙节点
// 入参rootNode表示树根节点, parentId表示要添加到节点的nodeId, 可为空
- (BOOL)addToTree:(UEPActBaseNode *)rootNode withParentId:(nullable NSString *)parentId;

- (UEPActBaseNode *)findNode:(NSString *)nodeId type:(UEPActNodeType)type;

- (void)bindReferNodeIfNeed:(UEPActNodeContext *)context;

// 删除子节点，双向删除，断开相互之间的指针指向（subNodes,parent, refer等）
- (BOOL)cleanSubNode:(UEPActBaseNode *)subNode;

// 清理当前节点的分层子节点和逻辑子节点，只父节点单向删除，子节点指针不修改
- (void)removeAllSubNodes;

- (UEPActBaseNode *)parentNode;

- (void)cleanParentNode;

- (void)cleanContextAndParent;

// 当前节点是否能直接添加指定子节点
// parentId可选
- (BOOL)canAppendSubNode:(UEPActBaseNode *)node withParentId:(NSString *)parentId;

// 是否是当前节点的子节点类型
- (BOOL)supportSubnode:(UEPActBaseNode *)node;

#pragma mark - 状态更新

- (void)updateRecursionContext:(UEPActNodeContext *)context;

- (void)updateTimestamp:(long long)timestamp;

- (void)processParams;

// - (NSDictionary *)filterParams:(NSDictionary *)srcParams paramKey:(NSString *)paramKey;

#pragma mark - 获取节点信息

// 当前节点唯一标识
- (NSString *)getNodeId;

// 当前节点所属appId
- (NSString *)getNodeAppId;

// 获取节点的直接子节点列表
- (NSArray<UEPActBaseNode *> *)getSubNodes;

// 获取包括自己和所有子节点，递归所有后序节点
//- (NSArray<UEPActBaseNode *> *)getFullPath;

//// 获取到当前节点的最短路径节点，从当前节点向前递归查找
//- (NSArray<UEPActBaseNode *> *)getShortPath;

// 节点类型
- (UEPActNodeType)getNodeType;

// 节点默认输出信息，只有当前节点信息
- (NSDictionary *)getLogInfo;

#pragma mark - 数据上报

// 转换成上传pb模型,
- (APDPBGeneratedMessage *)generatePbMessage;

// 转换子列表模型, 入参子节点列表，传空则取self.subNodes
- (NSArray<APDPBGeneratedMessage *> *)generateSubnodesPbWithList:(NSArray<UEPActBaseNode *> *)subnodes;

- (NSArray<APDPBGeneratedMessage *> *)generateSubnodesPb;

@end

NS_ASSUME_NONNULL_END
